/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.CascadeManager;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectLister;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.execute.ConnectionWrapper;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.execute.StatementWrapper;
import oracle.javatools.db.extension.DBObjectRegistry;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.InvalidSQLException;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractDatabase
extends AbstractDBObjectProvider
implements Database {
    private static final String SQLSTATE_NOT_IMPLEMENTED = "S1C00";
    private static final String ODBC_NOT_IMPLEMENTED = "IM001";
    private String m_connStore;
    private String m_connName;
    private Connection m_conn;
    private Connection m_oldConn;
    private DatabaseDescriptor m_descriptor;
    private String m_type;
    private Integer m_version;
    private boolean m_reconnecting;
    private final Lock m_connectionLock = new ReentrantLock();
    private final Holder<String> m_currentSchemaName = new Holder();
    private final Holder<String> m_username = new Holder();
    private final Holder<String> m_catalog = new Holder();

    protected AbstractDatabase(String string, String string2, Connection connection) {
        this(string, string2, connection, null, 0);
    }

    protected AbstractDatabase(String string, String string2, Connection connection, String string3, int n) {
        this.m_connStore = string;
        this.m_connName = string2;
        this.m_conn = connection;
        if (string3 != null) {
            this.m_type = string3;
            this.m_version = n;
        }
        this.getLogger().log(Level.FINE, "{0}: new {1}", new Object[]{string2, this.getClass().getName()});
        if (DBObjectRegistry.isActive()) {
            for (Map.Entry<String, DBObjectBuilder> entry : DBObjectRegistry.getInstance().getBuilders(this.getDatabaseType(), this.getDatabaseVersion(), this).entrySet()) {
                this.registerBuilder(entry.getKey(), entry.getValue());
            }
        }
        this.registerBuilders();
        this.registerValidators();
        this.reconnected(connection);
    }

    @Override
    public final String getProviderType() {
        return "db";
    }

    @Override
    public final Object getProviderIdentifier() {
        return this.getQualifiedName();
    }

    @Override
    public final String getDatabaseType() {
        if (this.m_type == null) {
            this.m_type = this.getDescriptor().getDatabaseType();
        }
        return this.m_type;
    }

    @Override
    public final int getDatabaseVersion() {
        if (this.m_version == null) {
            this.m_version = this.getDescriptor().getDatabaseVersion();
        }
        return this.m_version;
    }

    protected void registerValidators() {
        Map<String, DBObjectValidator> map = this.getDescriptor().getValidators(this);
        for (String string : map.keySet()) {
            this.registerValidator(string, map.get(string));
        }
    }

    protected final boolean exists(SystemObject systemObject) {
        if (systemObject != null) {
            String string;
            String string2;
            if (systemObject instanceof MaterializedViewLog) {
                string2 = "TABLE";
                string = ((MaterializedViewLog)systemObject).getLogTable();
            } else {
                string2 = systemObject.getType();
                string = AbstractDatabase.convertObject(systemObject);
            }
            return this.exists(string2, AbstractDatabase.convertObject(DBUtil.getSchema(systemObject)), string);
        }
        return false;
    }

    protected abstract void registerBuilders();

    @Override
    public final Connection getConnection() {
        try {
            return this.getConnection(true);
        }
        catch (DBException dBException) {
            return this.getConnectionImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Connection getConnection(boolean bl) throws DBException {
        Connection connection;
        if (bl) {
            this.m_connectionLock.lock();
            try {
                String string = Thread.currentThread().getName() + ": ";
                if (this.m_reconnecting) {
                    this.getLogger().fine(string + "Reconnect needed but we are already reconnecting!");
                } else if (this.isConnectionAlive()) {
                    this.getLogger().fine(string + "Connection is alive!");
                } else {
                    this.m_reconnecting = true;
                    try {
                        this.closeImpl();
                        Connection connection2 = this.createConnectionImpl(true);
                        if (connection2 != null) {
                            this.m_conn = connection2;
                            this.reconnected(this.m_conn);
                            this.fireProviderReloaded();
                            this.getLogger().info(Thread.currentThread().getName() + APIBundle.format("CONN_RECONNECTED", this.getName()));
                        }
                    }
                    finally {
                        this.m_reconnecting = false;
                    }
                }
                connection = this.getConnectionImpl();
            }
            finally {
                this.m_connectionLock.unlock();
            }
        }
        connection = this.getConnectionImpl();
        return connection;
    }

    protected final Connection createDuplicateConnection() throws DBException {
        return this.createConnectionImpl(false);
    }

    private Connection createConnectionImpl(boolean bl) throws DBException {
        DatabaseFactory.ConnectionCreator connectionCreator;
        Connection connection = null;
        if (this.m_connStore != null && this.m_connName != null && (connectionCreator = DatabaseFactory.findConnectionCreator(this.m_connStore)) != null) {
            Connection connection2 = connectionCreator.createConnectionImpl(this.m_connName);
            if (bl) {
                if (connection2 != null && connection2 != this.m_conn) {
                    if (this.m_oldConn == null || connectionCreator.shouldClearCaches(this.m_oldConn, connection2, this)) {
                        this.clearAllCaches();
                    }
                    connection = connection2;
                }
            } else {
                connection = connection2;
            }
        }
        return connection;
    }

    private Connection getConnectionImpl() {
        return this.m_conn == null ? this.m_oldConn : this.m_conn;
    }

    @Override
    public final boolean isClosed() {
        return !this.isConnectionAlive();
    }

    @Override
    public final boolean isConnectionAlive() {
        boolean bl = false;
        Connection connection = this.m_conn;
        if (connection != null) {
            bl = this.isConnectionAlive(connection);
        }
        return bl;
    }

    protected boolean isConnectionAliveImpl(Connection connection) throws SQLException, DBException {
        boolean bl = false;
        String string = this.getAliveTestStatement();
        if (ModelUtil.hasLength((String)string)) {
            StatementWrapper statementWrapper = new StatementWrapper(this.m_connName, connection, string);
            statementWrapper.setBypassExecutionProxy(true);
            try {
                bl = statementWrapper.execute();
            }
            catch (DBException dBException) {
                if (dBException.getCause() instanceof SQLException) {
                    this.getLogger().fine(dBException.getCause().getMessage());
                }
                throw dBException;
            }
        } else {
            try {
                connection.getMetaData();
                bl = true;
            }
            catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
                throw sQLFeatureNotSupportedException;
            }
            catch (SQLException sQLException) {
                this.getLogger().fine(sQLException.getMessage());
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnectionAlive(Connection connection) {
        AliveTester aliveTester = new AliveTester(connection);
        if (Thread.holdsLock(connection)) {
            aliveTester.run();
        } else {
            Thread thread = new Thread((Runnable)aliveTester, "AliveLockThread." + this.m_connName);
            AliveTester aliveTester2 = aliveTester;
            synchronized (aliveTester2) {
                long l = System.currentTimeMillis();
                thread.start();
                int n = 1;
                Thread.State state = thread.getState();
                while (aliveTester.isAlive == null && state != Thread.State.TERMINATED && (state != Thread.State.BLOCKED || System.currentTimeMillis() <= l + 500L)) {
                    try {
                        aliveTester.wait(n);
                    }
                    catch (InterruptedException interruptedException) {
                        aliveTester.interrupt();
                        Thread.currentThread().interrupt();
                        break;
                    }
                    state = thread.getState();
                    if (n >= 64) continue;
                    n *= 2;
                }
            }
            if (thread.getState() == Thread.State.BLOCKED) {
                aliveTester.interrupt();
                DBLog.getLogger(this).log(Level.INFO, Thread.currentThread().getName() + ": " + APIBundle.get("ALIVE_BLOCKED"), new Object[]{this.getConnectionName()});
            }
        }
        boolean bl = Boolean.FALSE != aliveTester.isAlive();
        aliveTester.setAlive(false);
        return bl;
    }

    protected String getAliveTestStatement() {
        return null;
    }

    @Override
    public Boolean isConnectionClosed(SQLException sQLException) {
        return this.isConnectionClosedImpl(sQLException, this.getConnectionImpl());
    }

    protected Boolean isConnectionClosedImpl(SQLException sQLException, Connection connection) {
        Boolean bl = null;
        if (sQLException != null && sQLException.getSQLState() == "08003") {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasTransaction() {
        String string;
        final Connection connection = this.m_conn;
        if (connection != null && ModelUtil.hasLength((String)(string = this.getTransactionTestQuery()))) {
            final Holder holder = new Holder((Object)false);
            final Holder holder2 = new Holder((Object)false);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    QueryWrapper queryWrapper = new QueryWrapper(AbstractDatabase.this.m_connName, connection, string, new Object[0]);
                    QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void processResultSet(ResultSet resultSet) throws DBException {
                            String string;
                            try {
                                if (resultSet.next() && ModelUtil.hasLength((String)(string = resultSet.getString(1)))) {
                                    holder.set((Object)true);
                                }
                            }
                            catch (SQLException sQLException) {
                                Holder holder = holder2;
                                synchronized (holder) {
                                    holder2.set((Object)true);
                                    holder2.notifyAll();
                                }
                            }
                            finally {
                                string = holder2;
                                synchronized (string) {
                                    holder2.set((Object)true);
                                    holder2.notifyAll();
                                }
                            }
                        }
                    };
                    try {
                        queryWrapper.executeQuery(queryRunnable);
                    }
                    catch (DBException dBException) {
                        AbstractDatabase.this.getLogger().log(Level.INFO, "hasTransaction query failed for {0}: {1}", new Object[]{AbstractDatabase.this.m_connName, dBException.getMessage()});
                    }
                }
            };
            Thread thread = new Thread(runnable, "DatabaseHasTransactionThread");
            thread.start();
            while (!((Boolean)holder2.get()).booleanValue()) {
                Holder holder3 = holder2;
                synchronized (holder3) {
                    try {
                        holder2.wait(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                    if (thread.getState() == Thread.State.BLOCKED) {
                        this.getLogger().log(Level.INFO, "Connection for \"{0}\" is busy, cannot perform hasTransaction test.", new Object[]{this.m_connName});
                        break;
                    }
                    if (thread.getState() == Thread.State.TERMINATED) {
                        break;
                    }
                }
            }
            return (Boolean)holder.get();
        }
        return false;
    }

    protected String getTransactionTestQuery() {
        return null;
    }

    @Override
    public void testSQLStatement(String string) throws DBException {
        QueryWrapper queryWrapper = new QueryWrapper((Database)this, string);
        try {
            queryWrapper.executeQuery(null);
        }
        catch (DBException dBException) {
            throw new InvalidSQLException(string, dBException.getMessage());
        }
    }

    @Override
    public final String getName() {
        return this.m_connName;
    }

    final void setConnectionName(String string) {
        this.m_connName = string;
    }

    @Override
    public final String getConnectionName() {
        return this.m_connName;
    }

    @Override
    public final String getConnectionStore() {
        return this.m_connStore;
    }

    @Override
    public final String getQualifiedName() {
        return DatabaseFactory.encodeIdentifier(this.getConnectionStore(), this.getConnectionName());
    }

    protected void reconnected(Connection connection) {
    }

    @Override
    public void clearAllCaches() {
        super.clearAllCaches();
        this.m_username.set(null);
        this.m_currentSchemaName.set(null);
        this.m_catalog.set(null);
    }

    @Override
    public void close() {
        this.closeImpl();
        this.clearAllCaches();
        this.fireProviderClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeImpl() {
        AbstractDatabase abstractDatabase = this;
        synchronized (abstractDatabase) {
            if (this.m_conn != null) {
                final Connection connection = this.m_conn;
                this.m_oldConn = this.m_conn;
                this.m_conn = null;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (!connection.isClosed()) {
                                AbstractDatabase.this.getLogger().log(Level.FINE, APIBundle.format("INFO_DISCONNECTING", AbstractDatabase.this.m_connName));
                                connection.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            AbstractDatabase.this.getLogger().log(Level.WARNING, APIBundle.format("ERROR_DISCONNECTING", AbstractDatabase.this.m_connName) + sQLException.getMessage());
                        }
                        catch (Exception exception) {
                            DBLog.logStackTrace(APIBundle.format("ERROR_DISCONNECTING", AbstractDatabase.this.m_connName) + exception.getMessage(), exception);
                        }
                    }
                };
                Thread thread = new Thread(runnable, "ConnectionCloseThread");
                thread.start();
            }
        }
    }

    @Override
    public boolean exists(String string, String string2, String string3) {
        boolean bl = false;
        try {
            DBObjectCriteria<SystemObject> dBObjectCriteria = new DBObjectCriteria<SystemObject>(SystemObject.class, string);
            dBObjectCriteria.setSchemaName(string2);
            dBObjectCriteria.setName(string3);
            bl = !this.listObjects(dBObjectCriteria).isEmpty();
        }
        catch (DBException dBException) {
            this.getLogger().warning(APIBundle.format("EXISTS_CHECK_ERR", string, string3, dBException.getMessage()));
        }
        return bl;
    }

    @Override
    public boolean isObjectValid(String string, String string2, String string3) {
        return this.exists(string, string2, string3);
    }

    protected final Schema createSchema(String string) {
        Schema schema = new Schema(string);
        schema.setID(new NameBasedID((DBObject)schema, (AbstractDBObjectProvider)this));
        return schema;
    }

    @Deprecated
    protected void finishCreate(SystemObject[] systemObjectArray, SystemObject[] systemObjectArray2) throws DBException {
    }

    public Collection<DBObjectChange> finishUpdates(Difference difference) throws DBException {
        SystemObject systemObject;
        ArrayList<SystemObject> arrayList = new ArrayList<SystemObject>();
        ArrayList<SystemObject> arrayList2 = new ArrayList<SystemObject>();
        ArrayList<DBObjectChange> arrayList3 = new ArrayList<DBObjectChange>();
        DBException dBException = null;
        for (Difference object : difference.getChildren()) {
            Object object2;
            systemObject = (SystemObject)object.getUpdatedObject();
            SystemObject systemObject2 = (SystemObject)object.getOriginalObject();
            if (systemObject == null) {
                if (systemObject2 == null) continue;
                arrayList2.add(systemObject2);
                continue;
            }
            Schema schema = DBUtil.getSchema(systemObject);
            Schema schema2 = schema == null ? null : this.findSchema(schema.getName());
            boolean bl = false;
            if (systemObject2 == null) {
                object2 = this.getCreatedObject(systemObject.getType(), schema2, systemObject.getName());
                if (object2 == null) {
                    bl = true;
                } else {
                    this.resetObject(systemObject, (SystemObject)object2, this.getExistingTimestamp((SystemObject)object2), false);
                    arrayList.add(systemObject);
                }
            } else {
                object2 = DBObjectCriteria.createSingleObjectCriteria(systemObject.getType(), schema2, systemObject.getName());
                ((DBObjectCriteria)object2).setSkipTimestampCheck(true);
                Object t = this.loadObjectImpl(object2);
                if (t == null) {
                    this.uncacheObject(systemObject2);
                    bl = true;
                } else {
                    ArrayList<DBObject> arrayList4 = new ArrayList<DBObject>();
                    this.collectCascadableChildChanges(object, arrayList4);
                    for (DBObject dBObject : arrayList4) {
                        this.resetCachedDependentObjects(dBObject);
                    }
                    DBObjectChange dBObjectChange = this.resetObject(systemObject2, (SystemObject)t, this.getExistingTimestamp((SystemObject)t));
                    if (dBObjectChange != null) {
                        arrayList3.add(dBObjectChange);
                    }
                }
            }
            if (!bl) continue;
            dBException = DBException.append(dBException, new DBException((DBObject)systemObject, APIBundle.format("ERROR_FETCHING_NEW_OBJECT", systemObject.getType(), systemObject.getName())));
        }
        if (arrayList.size() > 0) {
            this.fireObjectsAdded(arrayList);
        }
        if (arrayList2.size() > 0) {
            this.fireObjectsRemoved(arrayList2);
            for (SystemObject systemObject3 : arrayList2) {
                if (systemObject3 instanceof Index && (systemObject = ((Index)systemObject3).getTable()) != null) {
                    ((Table)systemObject).removeIndex((Index)systemObject3);
                    DBObjectChange.fireChildrenRemoved(systemObject, Collections.singletonList(systemObject3));
                }
                this.resetCachedDependentObjects(systemObject3);
                this.uncacheObject(systemObject3);
            }
        }
        if (dBException != null) {
            throw dBException;
        }
        return arrayList3;
    }

    private void collectCascadableChildChanges(Difference difference, Collection<DBObject> collection) {
        if (difference.isLoaded() && !difference.isSame()) {
            Object object;
            Object object2 = difference.getOriginalObject();
            if (object2 instanceof DBObject && ((object = (DBObject)difference.getUpdatedObject()) == null || !DBUtil.areNamesAndTypesEqual((DBObject)object2, (DBObject)object))) {
                collection.add((DBObject)object2);
            }
            for (Difference difference2 : difference.getChildren()) {
                this.collectCascadableChildChanges(difference2, collection);
            }
        }
    }

    private void resetCachedDependentObjects(DBObject dBObject) {
        CascadeManager cascadeManager = this.getCascadeManager();
        try {
            for (DBObjectID dBObjectID : cascadeManager.listReferers(dBObject)) {
                try {
                    DBObjectID dBObjectID2 = DBUtil.getUppermostParent(dBObjectID);
                    SystemObject systemObject = (SystemObject)dBObjectID2.resolveID();
                    if (systemObject == null) continue;
                    this.resetObject(systemObject, null, null);
                }
                catch (DBException dBException) {
                    this.getLogger().log(Level.WARNING, APIBundle.format("CASCADE_DELETE_ID_ERR", dBObject.getType(), dBObject.getName(), dBException.getMessage()));
                }
            }
        }
        catch (CancelledException cancelledException) {
            DBLog.logStackTrace("This process shouldn't be cancellable, the cache will now be invalid.", cancelledException);
        }
    }

    protected SystemObject getCreatedObject(String string, Schema schema, String string2) throws DBException {
        DBObjectCriteria<SystemObject> dBObjectCriteria = DBObjectCriteria.createSingleObjectCriteria(string, schema, string2);
        dBObjectCriteria.setSkipTimestampCheck(true);
        return this.loadObjectImpl(dBObjectCriteria);
    }

    @Deprecated
    protected void finishDelete(SystemObject[] systemObjectArray) {
    }

    @Override
    public String getDatabaseSource(String string, Schema schema, String string2) throws DBException {
        return null;
    }

    @Override
    public String getDatabaseSource(String string, Schema schema, String string2, String string3) throws DBException {
        return null;
    }

    @Override
    public Schema getDefaultSchema() throws DBException {
        String string = this.getCurrentSchemaName();
        Schema schema = this.findSchema(string);
        if (schema == null) {
            schema = this.getSchema(null);
        }
        return schema;
    }

    @Deprecated
    protected boolean isUsernameCaseInsensitive() {
        return true;
    }

    protected final String getCurrentSchemaName() throws DBException {
        String string = (String)this.m_currentSchemaName.get();
        if (string == null) {
            string = this.queryCurrentSchemaName();
            if (string == null) {
                string = this.getUserName();
            }
            this.m_currentSchemaName.set((Object)string);
        }
        return string;
    }

    protected String queryCurrentSchemaName() throws DBException {
        ConnectionWrapper connectionWrapper = new ConnectionWrapper(this, APIBundle.get("GET_CURR_SCHEMA"));
        return connectionWrapper.call(new ConnectionWrapper.SQLCallable<String>(connectionWrapper){

            @Override
            public String call() throws SQLException {
                String string = null;
                try {
                    string = this.getConnection().getSchema();
                }
                catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
                    AbstractDatabase.this.getLogger().fine("Driver doesn't support getSchema()");
                }
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    AbstractDatabase.this.getLogger().log(Level.FINE, "Driver failed calling getSchema() - possibly not JDBC 4.0 compliant.", throwable);
                }
                return string;
            }
        });
    }

    public final String getCatalog() {
        String string = (String)this.m_catalog.get();
        if (string == null) {
            try {
                string = this.queryCatalog();
            }
            catch (DBException dBException) {
                this.getLogger().log(Level.WARNING, APIBundle.format("CATALOG_QUERY_ERR", dBException.getMessage()));
            }
            if (string == null) {
                string = "";
            }
            this.m_catalog.set((Object)string);
        }
        return string;
    }

    protected String queryCatalog() throws DBException {
        ConnectionWrapper connectionWrapper = new ConnectionWrapper(this, APIBundle.get("GET_CATALOG"));
        return connectionWrapper.call(new ConnectionWrapper.SQLCallable<String>(connectionWrapper){

            @Override
            public String call() throws SQLException {
                String string;
                block2: {
                    string = null;
                    try {
                        string = this.getConnection().getCatalog();
                    }
                    catch (SQLException sQLException) {
                        if (AbstractDatabase.this.isUnsupportedOperation(sQLException)) break block2;
                        throw sQLException;
                    }
                }
                return string;
            }
        });
    }

    @Override
    public final String getUserName() {
        String string = (String)this.m_username.get();
        if (string == null) {
            try {
                string = this.queryCurrentUserName();
            }
            catch (DBException dBException) {
                this.getLogger().log(Level.WARNING, APIBundle.format("USER_QUERY_ERR", dBException.getMessage()));
            }
            this.m_username.set((Object)string);
        }
        return string;
    }

    protected String queryCurrentUserName() throws DBException {
        ConnectionWrapper connectionWrapper = new ConnectionWrapper(this, APIBundle.get("GET_USER_NAME"));
        return connectionWrapper.call(new ConnectionWrapper.SQLCallable<String>(connectionWrapper){

            @Override
            public String call() throws SQLException {
                String string = this.getConnection().getMetaData().getUserName();
                return AbstractDatabase.this.getInternalName(string, "SCHEMA");
            }
        });
    }

    @Override
    public boolean supportsDebugging() {
        return false;
    }

    @Override
    protected <T extends SystemObject> T getObjectImpl(DBObjectCriteria<T> dBObjectCriteria) throws DBException {
        T t = null;
        if (!dBObjectCriteria.isAllowedType("SCHEMA")) {
            t = this.getDescriptor().getBuiltInObject(dBObjectCriteria);
        }
        if (t == null) {
            t = super.getObjectImpl(dBObjectCriteria);
        }
        return t;
    }

    @Override
    public DatabaseDescriptor getDescriptor() {
        if (this.m_descriptor == null) {
            this.m_descriptor = DatabaseFactory.getDatabaseDescriptor(this);
        }
        return this.m_descriptor;
    }

    @Override
    public boolean canRestrictSchemaList() {
        return false;
    }

    @Deprecated
    public void setStatement(Statement statement) {
    }

    @Deprecated
    public void cancelStatement() {
    }

    protected final SystemObject findOrCreateObject(String string, Schema schema, String string2, Object object) throws DBException {
        return this.findOrCreateObject(string, null, schema, string2, object);
    }

    protected final SystemObject findOrCreateObject(String string, String string2, Schema schema, String string3, Object object) throws DBException {
        return this.findOrCreateObject(string, string2, schema, string3, object, null);
    }

    protected final SystemObject findOrCreateObject(String string, String string2, Schema schema, String string3, Object object, Long l) throws DBException {
        return this.findOrCreateObject(string, string2, schema, string3, object, l, false);
    }

    protected final SystemObject findOrCreateObject(DBObjectLister.ObjectInfo objectInfo, DBObjectCriteria dBObjectCriteria) throws DBException {
        return this.findOrCreateObject(objectInfo.getType(), dBObjectCriteria.getDatabaseName(), objectInfo.getSchema(), objectInfo.getName(), objectInfo.getIdentifier(), objectInfo.getTimestamp(), dBObjectCriteria.getSkipTimestampCheck());
    }

    private SystemObject findOrCreateObject(String string, String string2, Schema schema, String string3, Object object, Long l, boolean bl) throws DBException {
        Object object2;
        DBObjectID dBObjectID = this.createID(string2, schema, string3, string, object);
        SystemObject systemObject = this.findObject(string, schema, string3);
        if (systemObject == null || ModelUtil.areDifferent((Object)systemObject.getID(), (Object)dBObjectID)) {
            object2 = this.getBuilderForType(string);
            if (object2 == null) {
                throw new DBException(null, "missing builder for type " + string);
            }
            systemObject = (SystemObject)object2.createObject(string3, schema, dBObjectID);
            this.markForLazyInit((AbstractBuildableObject)((Object)systemObject));
            this.cacheObject(systemObject, true);
        }
        if (l != null) {
            if (!bl && (object2 = this.getExistingTimestamp(systemObject)) != null && (Long)object2 < l) {
                this.resetObject(systemObject, systemObject, l);
            }
            systemObject.setProperty("Timestamp", l);
            this.putCachedTimestampKey(systemObject.getID(), l);
        } else if (!this.supportsTimestamps(string)) {
            this.putCachedTimestampKey(systemObject.getID(), true);
        }
        return systemObject;
    }

    public final DBObjectID createID(Schema schema, String string, String string2, Object object) {
        return this.createID(null, schema, string, string2, object);
    }

    public final DBObjectID createID(String string, Schema schema, String string2, String string3, Object object) {
        BaseObjectID baseObjectID;
        if (object == null) {
            baseObjectID = new NameBasedID(string3, schema == null ? null : schema.getName(), string2, this);
        } else {
            IdentifierBasedID identifierBasedID = new IdentifierBasedID(string3, object, (AbstractDBObjectProvider)this);
            identifierBasedID.setName(string2);
            if (schema != null) {
                identifierBasedID.setSchemaName(schema.getName());
            }
            baseObjectID = identifierBasedID;
        }
        if (baseObjectID instanceof BaseObjectID && ModelUtil.hasLength((String)string)) {
            ((BaseObjectID)baseObjectID).setDatabaseName(string);
        }
        return baseObjectID;
    }

    public String getDBExceptionMessage(SQLException sQLException) {
        return sQLException.toString();
    }

    public boolean isUnsupportedOperation(SQLException sQLException) {
        boolean bl = false;
        bl = sQLException instanceof SQLFeatureNotSupportedException ? true : AbstractDatabase.isSQLStateNotImplemented(sQLException);
        return bl;
    }

    public static boolean isSQLStateNotImplemented(SQLException sQLException) {
        boolean bl = false;
        String string = sQLException.getSQLState();
        if (ModelUtil.areEqual((Object)string, (Object)SQLSTATE_NOT_IMPLEMENTED) || ModelUtil.areEqual((Object)string, (Object)ODBC_NOT_IMPLEMENTED)) {
            bl = true;
        }
        return bl;
    }

    private class AliveTester
    implements Runnable {
        private volatile Boolean isAlive;
        private volatile boolean isInterrupted;
        private final Connection conn;

        AliveTester(Connection connection) {
            this.conn = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.isAlive() == null) {
                Connection connection = this.conn;
                synchronized (connection) {
                    if (!this.isInterrupted) {
                        try {
                            if (this.conn.isClosed()) {
                                this.setAlive(false);
                            } else if (!this.isInterrupted) {
                                this.setAlive(AbstractDatabase.this.isConnectionAliveImpl(this.conn));
                            }
                        }
                        catch (Exception exception) {
                            AbstractDatabase.this.getLogger().log(Level.INFO, APIBundle.get("ALIVE_FAILED"), new Object[]{AbstractDatabase.this.m_connName, exception.getMessage()});
                        }
                    }
                }
            }
        }

        private void setAlive(boolean bl) {
            this.isAlive = bl;
        }

        Boolean isAlive() {
            return this.isAlive;
        }

        void interrupt() {
            this.isInterrupted = true;
        }

        boolean isInterrupted() {
            return this.isInterrupted;
        }
    }
}

