/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Collection;
import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Schema;

public abstract class Relation
extends AbstractSchemaObject {
    protected Relation() {
    }

    protected Relation(String string, Schema schema) {
        super(string, schema);
    }

    public void setColumns(Column[] columnArray) {
        this.getChildSupport("columns").setChildArray(columnArray);
    }

    public Column[] getColumns() {
        return this.getChildSupport("columns").getChildArray(Column.class);
    }

    public void addColumn(Column column) {
        this.getChildSupport("columns").addChild(column);
    }

    public void addColumn(int n, Column column) {
        this.getChildSupport("columns").addChild(n, column);
    }

    public Column getColumn(String string) {
        return (Column)this.getChildSupport("columns").findChild(string);
    }

    public void removeColumn(Column column) {
        this.getChildSupport("columns").removeChild(column);
    }

    public Constraint[] getConstraints() {
        return this.getChildSupport("constraints").getChildArray(Constraint.class);
    }

    public void setConstraints(Constraint[] constraintArray) {
        this.getChildSupport("constraints").setChildArray(constraintArray);
    }

    public Constraint getConstraint(String string) {
        return (Constraint)this.getChildSupport("constraints").findChild(string);
    }

    public void addConstraint(Constraint constraint) {
        this.getChildSupport("constraints").addChild(constraint);
    }

    public void removeConstraint(Constraint constraint) {
        this.getChildSupport("constraints").removeChild(constraint);
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> collection, String ... stringArray) {
        super.getOwnedObjectsImpl(collection, stringArray);
        if (stringArray != null) {
            boolean bl = false;
            Collection<String> collection2 = Constraint.getConstraintTypes();
            for (String object : stringArray) {
                if (!collection2.contains(object)) continue;
                bl = true;
                break;
            }
            if (bl) {
                for (Constraint constraint : this.getConstraints()) {
                    if (!this.includesType(constraint.getConstraintType(), stringArray)) continue;
                    collection.add(constraint);
                }
            }
        }
    }
}

