/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.lang.reflect.Field;
import java.sql.Types;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseRegistry;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.DataTypeSynonym;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.marshal.AbstractResourceCache;
import oracle.javatools.util.ModelUtil;

public class DataTypeCache
extends AbstractResourceCache {
    private final Map<String, DataType> m_dataTypes = new TreeMap<String, DataType>();
    private final Map<String, Integer> m_sqlTypes = new HashMap<String, Integer>();
    private DatabaseDescriptor m_jdbcDescriptor;
    private ResourceBundle m_bundle;

    public DataTypeCache(DatabaseDescriptor databaseDescriptor, String string) {
        super(databaseDescriptor, string);
    }

    private void checkTypeName(String string) {
        if (!ModelUtil.hasLength((String)string)) {
            throw new IllegalArgumentException("All types must have a non-empty name.");
        }
        if (this.m_dataTypes.containsKey(string)) {
            throw new IllegalArgumentException(string + " already registered");
        }
    }

    private void registerDataType(String string, DataType dataType) {
        this.checkTypeName(string);
        this.m_dataTypes.put(string, dataType);
        dataType.setID(new DataTypeID(string, this.getDatabaseDescriptor()));
        if (dataType instanceof PredefinedDataType) {
            DataTypeRegistry.getInstance().registerAttributes(dataType);
        }
    }

    public final void registerDataType(DataType dataType) {
        this.registerDataType(dataType.getName(), dataType);
    }

    public final void registerDataTypeResource(PredefinedDataType predefinedDataType) {
        String string = predefinedDataType.getName();
        this.registerDataTypeResource(string, predefinedDataType);
    }

    public final void registerDataType(String string) {
        PredefinedDataType predefinedDataType = new PredefinedDataType(string);
        this.registerDataTypeResource(string, predefinedDataType);
    }

    private void registerDataTypeResource(String string, PredefinedDataType predefinedDataType) {
        this.markForLazyInit(predefinedDataType, this.getResourcePath(string + ".xml"));
        this.registerDataType(string, predefinedDataType);
    }

    public final void registerDataTypeSynonym(String string, String string2) {
        DataType dataType = this.m_dataTypes.get(string2);
        if (dataType == null) {
            throw new IllegalArgumentException(string2 + " is not registered.");
        }
        if (dataType instanceof DataTypeSynonym) {
            throw new IllegalArgumentException(string2 + " is already a synonym.");
        }
        DataTypeSynonym dataTypeSynonym = new DataTypeSynonym(string, dataType);
        this.registerDataType(string, dataTypeSynonym);
    }

    public Collection<DataType> listSupportedDataTypes() {
        Collection<DataType> collection = this.m_dataTypes.values();
        return new ArrayList<DataType>(collection);
    }

    public DataType getDataType(String string) {
        return this.m_dataTypes.get(string);
    }

    public int getDataTypeCount() {
        return this.m_dataTypes.size();
    }

    public final void setResourceBundle(ResourceBundle resourceBundle) {
        this.m_bundle = resourceBundle;
    }

    @Override
    protected void lazyObjectBuilt(DBObject dBObject) {
        if (dBObject instanceof PredefinedDataType) {
            PredefinedDataType predefinedDataType = (PredefinedDataType)dBObject;
            if (predefinedDataType.getSQLType() == null) {
                DataType dBObject2;
                Integer n;
                DataTypeAttribute[] dataTypeAttributeArray = predefinedDataType.getName();
                DatabaseDescriptor databaseDescriptor = this.getJdbcDescriptor();
                if (databaseDescriptor != null && (n = (dBObject2 = databaseDescriptor.getDataType((String)dataTypeAttributeArray)) != null ? dBObject2.getSQLType() : this.getSQLType((String)dataTypeAttributeArray)) != null) {
                    predefinedDataType.setSQLType(n);
                }
            }
            if (this.m_bundle != null) {
                for (DataTypeAttribute dataTypeAttribute : predefinedDataType.getDataTypeAttributes()) {
                    dataTypeAttribute.setResourceBundle(this.m_bundle);
                }
            }
        }
    }

    private DatabaseDescriptor getJdbcDescriptor() {
        if (this.m_jdbcDescriptor == null) {
            this.m_jdbcDescriptor = DatabaseRegistry.getInstance().getDatabaseDescriptor("Generic JDBC", 0);
        }
        return this.m_jdbcDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getSQLType(String string) {
        Map<String, Integer> map = this.m_sqlTypes;
        synchronized (map) {
            if (this.m_sqlTypes.size() == 0) {
                for (Field field : Types.class.getDeclaredFields()) {
                    try {
                        this.m_sqlTypes.put(field.getName(), (Integer)field.get(null));
                    }
                    catch (Exception exception) {
                        this.getLogger().finest(exception.getMessage());
                    }
                }
            }
        }
        return this.m_sqlTypes.get(string);
    }
}

