/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.property.Property;
import oracle.javatools.util.ModelUtil;

public class DataTypeUsage
extends AbstractChildDBObject {
    public static final String TYPE = "DataTypeUsage";
    private final Map<String, Object> m_attributeValues = new HashMap<String, Object>(){

        @Override
        public Object put(String string, Object object) {
            Object object2 = object == null ? super.remove(string) : super.put(string, object);
            if (string != null && ModelUtil.areDifferent(object2, (Object)object)) {
                DataTypeUsage.this.firePropertyChanged(Property.createPath("attributeValues", string), object2, object);
            }
            return object2;
        }

        @Override
        public Object remove(Object object) {
            return object instanceof String ? this.put((String)object, (Object)null) : null;
        }
    };

    public DataTypeUsage() {
    }

    public DataTypeUsage(DataType dataType) {
        if (dataType != null) {
            this.setDataTypeID(dataType.getID());
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    protected boolean equalsImpl(AbstractDBObject abstractDBObject) {
        return super.equalsImpl(abstractDBObject) && DBUtil.areEqualIgnoreNullValues(this.m_attributeValues, ((DataTypeUsage)abstractDBObject).m_attributeValues);
    }

    @Override
    protected void copyToImpl(AbstractDBObject abstractDBObject, DBObject dBObject, IDPolicy iDPolicy) {
        super.copyToImpl(abstractDBObject, dBObject, iDPolicy);
        ((DataTypeUsage)abstractDBObject).setAttributeValues(this.m_attributeValues);
    }

    public final void setDataTypeID(DBObjectID dBObjectID) {
        this.setProperty("dataTypeID", dBObjectID);
    }

    public final DBObjectID getDataTypeID() {
        return (DBObjectID)this.getProperty("dataTypeID");
    }

    public final void setAttributeValues(Map<String, Object> map) {
        if (map != this.m_attributeValues) {
            if (map == null) {
                map = Collections.emptyMap();
            }
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.addAll(map.keySet());
            hashSet.addAll(this.m_attributeValues.keySet());
            for (String string : hashSet) {
                this.putAttributeValue(string, map.get(string));
            }
        }
    }

    public final Map<String, Object> getAttributeValues() {
        return this.m_attributeValues;
    }

    public final Object getAttributeValue(String string) {
        return this.m_attributeValues.get(string);
    }

    public final void putAttributeValue(String string, Object object) {
        this.m_attributeValues.put(string, object);
    }

    public final void deleteAttributeValue(String string) {
        this.putAttributeValue(string, null);
    }

    public final boolean hasAttributeValue(String string) {
        return this.m_attributeValues.containsKey(string);
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> collection) {
        super.getReferenceIDsImpl(collection);
        for (Object object : this.m_attributeValues.values()) {
            if (!(object instanceof DBObjectID)) continue;
            collection.add((DBObjectID)object);
        }
    }

    @Override
    public boolean replaceReferenceIDs(Map<? extends DBObjectID, ? extends DBObjectID> map) {
        boolean bl = super.replaceReferenceIDs(map);
        for (Map.Entry<String, Object> entry : this.m_attributeValues.entrySet()) {
            Object object = entry.getValue();
            if (!(object instanceof DBObjectID) || !map.containsKey((DBObjectID)object)) continue;
            entry.setValue(map.get((DBObjectID)object));
            bl = true;
        }
        return bl;
    }
}

