/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DataTypeValidationException;
import oracle.javatools.db.datatypes.DefaultValueValidationException;
import oracle.javatools.db.token.TokenPattern;

public class PredefinedDataType
extends AbstractBuildableObject
implements DataType {
    private String[] m_tokenizedDefinition;
    private TokenPattern m_search;

    public PredefinedDataType() {
    }

    public PredefinedDataType(String string) {
        super(string, null);
    }

    public PredefinedDataType(int n, String string) {
        this(n, string, null, new DataTypeAttribute[0]);
    }

    public PredefinedDataType(int n, String string, String string2, DataTypeAttribute ... dataTypeAttributeArray) {
        super(string, null);
        this.setDefinition(string2);
        this.setDataTypeAttributes(dataTypeAttributeArray);
    }

    public PredefinedDataType(int n, String string, String string2, long l, long l2, long l3, boolean bl, DataTypeAttribute ... dataTypeAttributeArray) {
        this(n, string, string2, dataTypeAttributeArray);
        this.addAttribute(new DataTypeAttribute("size", "DATATYPE_ATTRIBUTE_LABEL_SIZE", l, new Long(l2), new Long(l3), bl), 0);
    }

    @Override
    public final String getType() {
        return "DATATYPE";
    }

    public final void addAttribute(DataTypeAttribute dataTypeAttribute) {
        this.getChildSupport("dataTypeAttributes").addChild(dataTypeAttribute);
    }

    public final void addAttribute(DataTypeAttribute dataTypeAttribute, int n) {
        this.getChildSupport("dataTypeAttributes").addChild(n, dataTypeAttribute);
    }

    public final void removeAttribute(DataTypeAttribute dataTypeAttribute) {
        this.getChildSupport("dataTypeAttributes").removeChild(dataTypeAttribute);
    }

    @Override
    public DataTypeUsage createDefaultUsage() {
        DataTypeUsage dataTypeUsage = new DataTypeUsage(this);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (DataTypeAttribute dataTypeAttribute : this.getDataTypeAttributes()) {
            if (!dataTypeAttribute.isMandatory()) continue;
            hashMap.put(dataTypeAttribute.getName(), dataTypeAttribute.getDefaultValue());
        }
        if (hashMap.size() > 0) {
            dataTypeUsage.setAttributeValues(hashMap);
        }
        return dataTypeUsage;
    }

    @Override
    public DataTypeUsage createUsage(Map<String, Object> map) {
        String string2;
        assert (map != null);
        DataTypeUsage dataTypeUsage = new DataTypeUsage(this);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (String string2 : map.keySet()) {
            DataTypeAttribute dataTypeAttribute = this.getDataTypeAttribute(string2);
            if (dataTypeAttribute == null || !dataTypeAttribute.isDeclarable() || map.get(string2) == null) continue;
            hashMap.put(string2, map.get(string2));
        }
        string2 = (String)map.get("name");
        if (string2 != null) {
            this.addAttributeValues(hashMap, string2, new DTAContext());
        }
        dataTypeUsage.setAttributeValues(hashMap);
        return dataTypeUsage;
    }

    @Override
    @Deprecated
    public void validateUsage(DataTypeUsage dataTypeUsage, DBObject dBObject) throws DataTypeValidationException {
    }

    @Override
    @Deprecated
    public void validateDefaultValue(Object object, DataTypeUsage dataTypeUsage, DBObject dBObject) throws DefaultValueValidationException {
    }

    @Override
    public String getDDL(DataTypeUsage dataTypeUsage) {
        DDLGenImpl dDLGenImpl = new DDLGenImpl(this.getDefinitionForSearch());
        return dDLGenImpl.getDDL(dataTypeUsage.getAttributeValues());
    }

    @Override
    public final boolean hasDataTypeAttribute(String string) {
        return this.getDataTypeAttribute(string) != null;
    }

    @Override
    public final DataTypeAttribute getDataTypeAttribute(String string) {
        return (DataTypeAttribute)this.getChildSupport("dataTypeAttributes").findChild(string);
    }

    @Override
    public final DataTypeAttribute[] getDataTypeAttributes() {
        return this.getChildSupport("dataTypeAttributes").getChildArray(DataTypeAttribute.class);
    }

    public final void setDataTypeAttributes(DataTypeAttribute[] dataTypeAttributeArray) {
        this.getChildSupport("dataTypeAttributes").setChildArray(dataTypeAttributeArray);
    }

    @Override
    public Integer getSQLType() {
        return (Integer)this.getProperty("SQLType");
    }

    public void setSQLType(Integer n) {
        this.setProperty("SQLType", n);
    }

    public ValueType getValueType() {
        return (ValueType)((Object)this.getProperty("valueType"));
    }

    public void setValueType(ValueType valueType) {
        this.setProperty("valueType", (Object)valueType);
    }

    public BigDecimal getMinValue() {
        return (BigDecimal)this.getProperty("minValue");
    }

    public void setMinValue(BigDecimal bigDecimal) {
        this.setProperty("minValue", bigDecimal);
    }

    public BigDecimal getMaxValue() {
        return (BigDecimal)this.getProperty("maxValue");
    }

    public void setMaxValue(BigDecimal bigDecimal) {
        this.setProperty("maxValue", bigDecimal);
    }

    public String getDefinition() {
        return (String)this.getProperty("definition");
    }

    public void setDefinition(String string) {
        this.setProperty("definition", string);
        this.clearSearchCache();
    }

    public String getSearchDefinition() {
        return (String)this.getProperty("searchDefinition");
    }

    public void setSearchDefinition(String string) {
        this.setProperty("searchDefinition", string);
        this.clearSearchCache();
    }

    protected String getDefinitionForSearch() {
        String string = this.getSearchDefinition();
        if (string == null) {
            string = this.getDefinition();
        }
        if (string == null) {
            string = this.getName();
        }
        return string;
    }

    private void clearSearchCache() {
        this.m_search = null;
        this.m_tokenizedDefinition = null;
    }

    private void addAttributeValues(Map map, String string, DTAContext dTAContext) {
        if (this.m_tokenizedDefinition == null) {
            this.m_tokenizedDefinition = PredefinedDataType.tokenize(this.getDefinitionForSearch(), "[]( ),");
        }
        dTAContext.m_dataType = string;
        String[] stringArray = PredefinedDataType.tokenize(string, "( ),");
        dTAContext.m_index = 0;
        dTAContext.m_valueIndex = 0;
        while (dTAContext.m_index < this.m_tokenizedDefinition.length && dTAContext.m_valueIndex < stringArray.length) {
            this.addAttributeValues(map, stringArray, false, dTAContext);
            ++dTAContext.m_index;
        }
    }

    private void addOptionalAttributeValue(Map map, String[] stringArray, DTAContext dTAContext) {
        ++dTAContext.m_index;
        if (!this.addAttributeValues(map, stringArray, true, dTAContext)) {
            int n = 1;
            do {
                if (this.m_tokenizedDefinition[dTAContext.m_index].equals("[")) {
                    ++n;
                    continue;
                }
                if (!this.m_tokenizedDefinition[dTAContext.m_index].equals("]")) continue;
                --n;
            } while (n > 0 && ++dTAContext.m_index < this.m_tokenizedDefinition.length);
        }
    }

    private boolean addAttributeValues(Map map, String[] stringArray, boolean bl, DTAContext dTAContext) {
        while (dTAContext.m_valueIndex < stringArray.length && dTAContext.m_index < this.m_tokenizedDefinition.length && !this.m_tokenizedDefinition[dTAContext.m_index].equals("]")) {
            if (this.m_tokenizedDefinition[dTAContext.m_index].equals("[")) {
                this.addOptionalAttributeValue(map, stringArray, dTAContext);
            } else if (this.m_tokenizedDefinition[dTAContext.m_index].charAt(0) == '<') {
                String string = this.m_tokenizedDefinition[dTAContext.m_index].substring(1, this.m_tokenizedDefinition[dTAContext.m_index].length() - 1);
                DataTypeAttribute dataTypeAttribute = this.getDataTypeAttribute(string);
                int n = dataTypeAttribute.getValueType();
                if (n == 1 || n == 2) {
                    map.put(string, DataTypeHelper.getAttributeValue(stringArray[dTAContext.m_valueIndex], (DataType)dataTypeAttribute.getParent(), string));
                } else if (n == 0) {
                    Object object = stringArray[dTAContext.m_valueIndex];
                    if (this.getDataTypeAttribute(string).getValues() != null) {
                        int n2;
                        String[] stringArray2 = this.getDataTypeAttribute(string).getValues();
                        while ((n2 = this.isValidValue((String)object, stringArray2)) == -1 && ++dTAContext.m_valueIndex < stringArray.length) {
                            object = (String)object + stringArray[dTAContext.m_valueIndex];
                        }
                        if (dTAContext.m_valueIndex < stringArray.length) {
                            map.put(string, stringArray2[n2]);
                        } else if (!bl) {
                            DBLog.getLogger(this).warning("Data type \"" + dTAContext.m_dataType + "\" doesn't match its definition : " + this.getDefinitionForSearch());
                        }
                    }
                }
                ++dTAContext.m_valueIndex;
            } else {
                if (bl) {
                    if (this.m_tokenizedDefinition[dTAContext.m_index].compareToIgnoreCase(stringArray[dTAContext.m_valueIndex]) != 0) {
                        return false;
                    }
                } else assert (this.m_tokenizedDefinition[dTAContext.m_index].compareToIgnoreCase(stringArray[dTAContext.m_valueIndex]) == 0) : "Data type \"" + dTAContext.m_dataType + "\" doesn't match its definition : " + this.getDefinitionForSearch();
                ++dTAContext.m_valueIndex;
            }
            ++dTAContext.m_index;
        }
        return true;
    }

    private int isValidValue(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].replaceAll("\\s", "").compareToIgnoreCase(string) != 0) continue;
            return i;
        }
        return -1;
    }

    protected static String[] tokenize(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.replaceAll("\\s", " "), string2, true);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.charAt(0) == ' ') continue;
            arrayList.add(string3);
            ++n;
        }
        return arrayList.toArray(new String[n]);
    }

    @Override
    public boolean matches(String string) {
        return DataTypeHelper.matches(this.getSearch(), string) != null;
    }

    @Override
    public DataTypeUsage createUsage(String string) {
        return DataTypeHelper.getUsageFromString(this, this.getSearch(), string);
    }

    private TokenPattern getSearch() {
        if (this.m_search == null) {
            this.m_search = DataTypeHelper.buildSearch(this.getDefinitionForSearch(), this.getDataTypeAttributes());
        }
        return this.m_search;
    }

    public static enum ValueType {
        SIGNED_INT,
        UNSIGNED_INT,
        FLOAT,
        CHAR,
        BINARY,
        DATE,
        TIMESTAMP;


        public static boolean isNumericType(ValueType valueType) {
            return valueType != null && valueType.ordinal() < 3;
        }
    }

    private static class DTAContext {
        private int m_index;
        private int m_valueIndex;
        private String m_dataType;

        private DTAContext() {
        }
    }

    static class DDLGenImpl {
        private int m_index;
        private final String m_definition;

        DDLGenImpl(String string) {
            this.m_definition = string;
        }

        String getDDL(Map<String, Object> map) {
            Object object = "";
            if (this.m_definition != null) {
                this.m_index = 0;
                while (this.m_index < this.m_definition.length()) {
                    object = (String)object + this.getDDL(map, false);
                    ++this.m_index;
                }
            }
            return object;
        }

        private String getDDL(Map<String, Object> map, boolean bl) {
            char c;
            Object object = "";
            int n = this.m_definition.length();
            while (this.m_index < n && (c = this.m_definition.charAt(this.m_index)) != ']') {
                if (c == '[') {
                    object = (String)object + this.getOptionalDDL(map);
                } else if (c == '<') {
                    Object object2 = "";
                    while (++this.m_index < this.m_definition.length() && this.m_definition.charAt(this.m_index) != '>') {
                        object2 = (String)object2 + this.m_definition.charAt(this.m_index);
                    }
                    Object object3 = map.get(object2);
                    if (bl && object3 == null) {
                        return "";
                    }
                    if (object3 != null) {
                        object = (String)object + object3.toString();
                    }
                } else if (c == '\\' && this.m_index < n - 1) {
                    char c2 = this.m_definition.charAt(this.m_index + 1);
                    if (c2 == '<' || c2 == '>' || c2 == '[' || c2 == ']') {
                        object = (String)object + c2;
                        ++this.m_index;
                    } else {
                        object = (String)object + c;
                    }
                } else {
                    object = (String)object + c;
                }
                ++this.m_index;
            }
            return object;
        }

        private String getOptionalDDL(Map map) {
            ++this.m_index;
            String string = this.getDDL(map, true);
            if (string.length() == 0) {
                while (this.m_index < this.m_definition.length() && this.m_definition.charAt(this.m_index) != ']') {
                    if (this.m_definition.charAt(this.m_index) == '[') {
                        this.getOptionalDDL(map);
                    }
                    ++this.m_index;
                }
            }
            return string;
        }
    }
}

