/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ddl.TokenContext;
import oracle.javatools.db.ddl.TokenProcessor;
import oracle.javatools.db.plsql.DBObjectPlSqlFragment;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlUtilCore;
import oracle.javatools.db.plsql.parser.PlSqlParser;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.util.ModelUtil;

public abstract class TokenGenerator {
    private TokenProcessor m_processor;
    private String m_tokenName;

    public abstract void generateToken(TokenContext var1);

    public abstract Object evaluateToken(TokenContext var1);

    public Collection<String> getPropertiesProcessed(String string, DBObjectProvider dBObjectProvider) {
        return Collections.emptyList();
    }

    @Deprecated
    public Collection<String> getPropertiesAltered(String string, DBObjectProvider dBObjectProvider) {
        return Collections.emptyList();
    }

    public Map<PropertyAction.ChildAction, Collection<String>> getAlterPropertiesProcessed(String string, DBObjectProvider dBObjectProvider) {
        return this.createPropertyMap(this.getPropertiesAltered(string, dBObjectProvider), null, null);
    }

    protected final Map<PropertyAction.ChildAction, Collection<String>> createPropertyMap(Collection<String> collection, Collection<String> collection2, Collection<String> collection3) {
        EnumMap<PropertyAction.ChildAction, Collection<String>> enumMap = new EnumMap<PropertyAction.ChildAction, Collection<String>>(PropertyAction.ChildAction.class);
        enumMap.put(PropertyAction.ChildAction.ADD, collection2);
        enumMap.put(PropertyAction.ChildAction.REMOVE, collection3);
        enumMap.put(PropertyAction.ChildAction.MODIFY, collection);
        return enumMap;
    }

    protected final TokenProcessor getProcessor() {
        return this.m_processor;
    }

    final void setProcessor(TokenProcessor tokenProcessor, String string) {
        this.m_processor = tokenProcessor;
        this.m_tokenName = string;
    }

    final String getTokenName() {
        return this.m_tokenName;
    }

    public static class DefaultSchemaGenerator
    extends TokenGenerator {
        public static final String TOKEN = "defaultSchema";

        @Override
        public void generateToken(TokenContext tokenContext) {
            Schema schema = tokenContext.getDefaultSchema();
            tokenContext.append(schema);
        }

        @Override
        public Object evaluateToken(TokenContext tokenContext) {
            Schema schema;
            boolean bl = true;
            Object object = tokenContext.getObject();
            if (object instanceof DBObject && (schema = DBUtil.getSchema((DBObject)object)) != null) {
                Schema schema2 = tokenContext.getDefaultSchema();
                bl = DBUtil.areNamesAndTypesEqual(schema, schema2);
            }
            return bl;
        }
    }

    public static class CommentGenerator
    extends TokenGenerator {
        public static final String TOKEN = "quotedComment";

        @Override
        public void generateToken(TokenContext tokenContext) {
            String string = this.getComment(tokenContext);
            if (ModelUtil.hasLength((String)string) && !string.equals(" ")) {
                tokenContext.appendString("'", false);
                tokenContext.appendString(string.replace("'", "''"), false);
                tokenContext.appendString("'", false);
            } else {
                tokenContext.appendString("''", false);
            }
        }

        private String getComment(TokenContext tokenContext) {
            String string = null;
            Object object = tokenContext.getObject();
            if (object instanceof DBObject) {
                string = (String)((DBObject)object).getProperty("Comment");
            }
            return string;
        }

        @Override
        public Object evaluateToken(TokenContext tokenContext) {
            String string = this.getComment(tokenContext);
            string = string == null ? null : string.trim();
            return ModelUtil.hasLength((String)string);
        }

        @Override
        public Collection<String> getPropertiesProcessed(String string, DBObjectProvider dBObjectProvider) {
            return Arrays.asList("Comment");
        }
    }

    public static final class NameGenerator
    extends TokenGenerator {
        public static final String TOKEN = "schema.name";

        @Override
        public void generateToken(TokenContext tokenContext) {
            Object object = tokenContext.getObject();
            DBObjectProvider dBObjectProvider = tokenContext.getProvider();
            if (dBObjectProvider != null && object instanceof PlSqlSourceObject && object instanceof DBObjectPlSqlFragment) {
                CharSequence charSequence;
                Object object2;
                Object object3;
                PlSqlSourceObject plSqlSourceObject = (PlSqlSourceObject)object;
                PlSqlToken plSqlToken = null;
                PlSqlToken plSqlToken2 = null;
                PlSqlToken plSqlToken3 = null;
                try {
                    object3 = PlSqlUtilCore.findOrCreateParser(plSqlSourceObject, dBObjectProvider);
                    plSqlToken = ((PlSqlParser)object3).getNameToken();
                    plSqlToken2 = ((PlSqlParser)object3).getTypeToken();
                    plSqlToken3 = ((PlSqlParser)object3).getSchemaToken();
                }
                catch (CancelledException cancelledException) {
                    DBLog.getLogger(this).warning("Parsing cancelled while building ddl. " + cancelledException.getMessage());
                }
                object3 = null;
                if (plSqlToken != null && dBObjectProvider != null) {
                    object3 = dBObjectProvider.getInternalName(plSqlToken.getSource());
                }
                if (!ModelUtil.hasLength((String)object3)) {
                    object3 = plSqlSourceObject.getName();
                } else {
                    object2 = plSqlToken2;
                    object2 = (PlSqlToken)object2.getNextToken();
                    charSequence = new StringBuilder();
                    while (!object2.isCode()) {
                        charSequence.append(object2.getSource());
                        object2 = (PlSqlToken)object2.getNextToken();
                    }
                    if (" ".equals(charSequence.substring(0, 1))) {
                        tokenContext.append(charSequence.substring(1));
                    } else {
                        tokenContext.append(charSequence.toString());
                    }
                }
                if (ModelUtil.hasLength((String)plSqlSourceObject.getSource()) && (dBObjectProvider instanceof Database || tokenContext.getOptions().isSqlBlankLines()) && (object2 = plSqlSourceObject.getSchema()) != null) {
                    charSequence = null;
                    if (plSqlToken3 != null) {
                        charSequence = plSqlToken3.getSource();
                    }
                    String string = ((AbstractDBObject)object2).getName();
                    if (charSequence != null) {
                        if (string.equals(dBObjectProvider.getInternalName((String)charSequence))) {
                            tokenContext.append(charSequence);
                            tokenContext.append(Character.valueOf('.'));
                        } else {
                            tokenContext.appendSchemaName(string);
                        }
                    } else {
                        tokenContext.appendSchemaName(string);
                    }
                }
                tokenContext.appendName((String)object3);
            } else if (object instanceof DBObject) {
                Schema schema;
                if (object instanceof SchemaObject && (schema = (Schema)tokenContext.getPropertyValue("schema")) != null) {
                    tokenContext.appendSchemaName(schema.getName());
                }
                tokenContext.appendName((String)tokenContext.getPropertyValue("name"));
            } else {
                tokenContext.append(object);
            }
        }

        @Override
        public Object evaluateToken(TokenContext tokenContext) {
            return null;
        }

        @Override
        public Collection<String> getPropertiesProcessed(String string, DBObjectProvider dBObjectProvider) {
            return Arrays.asList("name", "schema");
        }
    }

    public static final class CascadeGenerator
    extends TokenGenerator {
        public static final String TOKEN = "cascade";

        @Override
        public void generateToken(TokenContext tokenContext) {
        }

        @Override
        public Object evaluateToken(TokenContext tokenContext) {
            return tokenContext.getOptions().isCascade();
        }
    }

    public static final class ReplaceGenerator
    extends TokenGenerator {
        public static final String TOKEN = "replace";

        @Override
        public void generateToken(TokenContext tokenContext) {
            if (tokenContext.getOptions().isReplace()) {
                tokenContext.append("OR REPLACE");
            }
        }

        @Override
        public Object evaluateToken(TokenContext tokenContext) {
            return tokenContext.getOptions().isReplace();
        }
    }
}

