/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.dictionary;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectLister;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ddl.DDLDatabase;
import oracle.javatools.db.dictionary.DictionaryQueries;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.execute.StatementWrapper;
import oracle.javatools.db.extension.DBObjectRegistry;
import oracle.javatools.db.ora.DatabaseLink;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public abstract class DictionaryDatabase
extends DDLDatabase {
    private Map<String, DBObjectLister> m_listers;

    protected DictionaryDatabase(String string, String string2, Connection connection) {
        super(string, string2, connection);
    }

    protected DictionaryDatabase(String string, String string2, Connection connection, String string3, int n) {
        super(string, string2, connection, string3, n);
    }

    protected QueryWrapper newQueryWrapper(SystemObject systemObject, String string, Object ... objectArray) {
        return this.newQueryWrapper(systemObject, string, Arrays.asList(objectArray));
    }

    protected QueryWrapper newQueryWrapper(SystemObject systemObject, String string, List list) {
        QueryWrapper queryWrapper = new QueryWrapper((Database)this, string, list);
        queryWrapper.setContextObject(systemObject);
        return queryWrapper;
    }

    protected abstract DictionaryQueries getDictionaryQueries();

    protected boolean isSupportedType(String string) {
        return this.getBuilderForType(string) != null;
    }

    @Override
    public boolean supportsTimestamps(String string) {
        DBObjectLister dBObjectLister;
        boolean bl;
        DictionaryQueries dictionaryQueries = this.getDictionaryQueries();
        boolean bl2 = bl = dictionaryQueries.getTimestampQueryByID(string) != null || dictionaryQueries.getTimestampQueryByName(string) != null;
        if (!bl && (dBObjectLister = this.getLister(string)) != null) {
            bl = dBObjectLister.supportsTimestamps(string);
        }
        return bl;
    }

    protected QueryWrapper[] getListQueries(DBObjectCriteria<? extends SystemObject> dBObjectCriteria) {
        Object object;
        QueryWrapper[] queryWrapperArray;
        String[] stringArray;
        DictionaryQueries dictionaryQueries = this.getDictionaryQueries();
        Collection<String> collection = dBObjectCriteria.getTypes();
        String string = dBObjectCriteria.getName();
        boolean bl = false;
        if (!ModelUtil.hasLength((String)string)) {
            string = dBObjectCriteria.getNameLike();
            bl = DBObjectCriteria.containsWildcard(string);
        }
        Schema schema = null;
        Schema schema2 = null;
        try {
            schema2 = this.getCriteriaSchema(dBObjectCriteria);
            if (dBObjectCriteria.getDatabaseName() == null && schema2 != null) {
                schema = this.getDefaultSchema();
            }
        }
        catch (DBException dBException) {
            this.getLogger().log(Level.WARNING, "Couldn't get schemas : " + dBException.getMessage());
        }
        String string2 = schema2 == null ? null : schema2.getName();
        boolean bl2 = ModelUtil.areEqual((Object)string2, (Object)(schema == null ? null : schema.getName()));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (!bl && collection.size() == 1 && (stringArray = dictionaryQueries.getSingleObjectQuery((String)(queryWrapperArray = collection.iterator().next()), bl2, dBObjectCriteria)) != null) {
            List<String> object22 = this.getParameters(dictionaryQueries.getSingleObjectQueryParams((String)queryWrapperArray, bl2, dBObjectCriteria), schema2, string, new String[]{queryWrapperArray});
            object = this.newQueryWrapper(null, (String)stringArray, object22);
            ((QueryWrapper)object).setDatabaseName(dBObjectCriteria.getDatabaseName());
            ((StatementWrapper)object).setIdentifier((String)queryWrapperArray);
            arrayList.add(object);
        }
        if (arrayList.isEmpty()) {
            Object object2;
            queryWrapperArray = new ArrayList();
            for (String string3 : collection) {
                if (!this.isSupportedType(string3)) continue;
                if (dictionaryQueries.isCustomListQuery(string3, bl2, dBObjectCriteria)) {
                    object = dictionaryQueries.getCustomListQuery(string3, bl2, dBObjectCriteria);
                    if (object == null) continue;
                    object2 = this.getParameters(dictionaryQueries.getCustomListQueryParams(string3, bl2, dBObjectCriteria), schema2, string, string3);
                    QueryWrapper queryWrapper = this.newQueryWrapper(null, (String)object, (List)object2);
                    queryWrapper.setDatabaseName(dBObjectCriteria.getDatabaseName());
                    queryWrapper.setIdentifier(string3);
                    arrayList.add(queryWrapper);
                    continue;
                }
                queryWrapperArray.add(string3);
            }
            if (queryWrapperArray.size() > 0) {
                stringArray = queryWrapperArray.toArray(new String[queryWrapperArray.size()]);
                String string4 = dictionaryQueries.getStandardListQuery(stringArray);
                object = this.getParameters(dictionaryQueries.getStandardListQueryParams(), schema2, string, stringArray);
                object2 = this.newQueryWrapper(null, string4, (List)object);
                ((QueryWrapper)object2).setDatabaseName(dBObjectCriteria.getDatabaseName());
                arrayList.add(0, object2);
            }
        }
        if ((queryWrapperArray = arrayList.toArray(new QueryWrapper[arrayList.size()])).length > 1 && dictionaryQueries.canUnionListQueries()) {
            queryWrapperArray = new QueryWrapper[]{QueryWrapper.union(queryWrapperArray)};
        }
        return queryWrapperArray;
    }

    @Override
    protected <T extends SystemObject> Collection<T> listObjectsImpl(DBObjectCriteria<T> dBObjectCriteria) throws DBException {
        Collection<DBObjectLister.ObjectInfo> collection = this.listObjectInfos(dBObjectCriteria);
        ArrayList<SystemObject> arrayList = new ArrayList<SystemObject>();
        for (DBObjectLister.ObjectInfo objectInfo : collection) {
            SystemObject systemObject = this.findOrCreateObject(objectInfo, dBObjectCriteria);
            if (systemObject == null) continue;
            arrayList.add(systemObject);
        }
        return arrayList;
    }

    private Collection<DBObjectLister.ObjectInfo> listObjectInfos(DBObjectCriteria<? extends SystemObject> dBObjectCriteria) throws DBException {
        Collection<DBObjectLister.ObjectInfo> collection;
        Object object;
        ArrayList<DBObjectLister.ObjectInfo> arrayList = new ArrayList<DBObjectLister.ObjectInfo>();
        Schema schema = this.getCriteriaSchema(dBObjectCriteria);
        QueryWrapper[] queryWrapperArray = this.getListQueries(dBObjectCriteria);
        if (queryWrapperArray != null) {
            object = null;
            try {
                object = Integer.getInteger("oracle.db.MaxFetchCount");
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int n = object == null ? Integer.MAX_VALUE : (Integer)object;
            for (int i = 0; i < queryWrapperArray.length; ++i) {
                collection = queryWrapperArray[i];
                ((QueryWrapper)((Object)collection)).setDatabaseName(dBObjectCriteria.getDatabaseName());
                QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable((QueryWrapper)((Object)collection), arrayList, schema, n){
                    final /* synthetic */ QueryWrapper val$wrap;
                    final /* synthetic */ Collection val$objectInfos;
                    final /* synthetic */ Schema val$schema;
                    final /* synthetic */ int val$maxCount;
                    {
                        this.val$wrap = queryWrapper;
                        this.val$objectInfos = collection;
                        this.val$schema = schema;
                        this.val$maxCount = n;
                    }

                    @Override
                    public void processResultSet(ResultSet resultSet) throws DBException {
                        try {
                            int n = 0;
                            while (resultSet.next()) {
                                String string;
                                CancelledException.checkInterrupt();
                                int n2 = resultSet.getMetaData().getColumnCount();
                                String string2 = resultSet.getString(1);
                                String string3 = string = n2 < 2 ? this.val$wrap.getIdentifier() : resultSet.getString(2).trim();
                                if (!ModelUtil.hasLength((String)string)) {
                                    throw new DBException(null, "Query is listing objects with an unknown type.");
                                }
                                if (!DictionaryDatabase.this.supportsObjectType(string = string.toUpperCase())) {
                                    DictionaryDatabase.this.getLogger().log(Level.WARNING, "Unsupported object type: " + string);
                                } else {
                                    Object object;
                                    Object object2 = object = n2 < 3 ? null : resultSet.getObject(3);
                                    if (resultSet.wasNull() || object instanceof String && ((String)object).equalsIgnoreCase("null") || object instanceof Number && ((Number)object).intValue() == 0) {
                                        object = null;
                                    }
                                    Timestamp timestamp = n2 < 4 ? null : resultSet.getTimestamp(4);
                                    Long l = timestamp == null ? null : Long.valueOf(timestamp.getTime());
                                    this.val$objectInfos.add(new DBObjectLister.ObjectInfo(string, this.val$schema, string2, object, l));
                                    if (++n < this.val$maxCount) continue;
                                }
                                break;
                            }
                        }
                        catch (SQLException sQLException) {
                            this.val$wrap.throwDBException(sQLException);
                        }
                    }
                };
                queryWrapperArray[i].executeQuery(500, queryRunnable);
            }
        }
        if ((object = this.getListers(dBObjectCriteria.getTypeArray())) != null) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                DBObjectLister dBObjectLister = (DBObjectLister)iterator.next();
                collection = dBObjectLister.listObjects(dBObjectCriteria);
                if (collection == null) continue;
                arrayList.addAll(collection);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Collection<DBObjectLister> getListers(String ... stringArray) {
        HashSet<DBObjectLister> hashSet = null;
        if (stringArray == null || !DBObjectRegistry.isActive()) return hashSet;
        String[] stringArray2 = this;
        synchronized (this) {
            if (this.m_listers == null) {
                this.m_listers = DBObjectRegistry.getInstance().getListers(this.getDatabaseType(), this.getDatabaseVersion(), (DBObjectProvider)this);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            hashSet = new HashSet<DBObjectLister>();
            for (String string : stringArray) {
                DBObjectLister dBObjectLister = this.m_listers.get(string);
                if (dBObjectLister == null) continue;
                hashSet.add(dBObjectLister);
            }
            return hashSet;
        }
    }

    private DBObjectLister getLister(String string) {
        DBObjectLister dBObjectLister = null;
        Collection<DBObjectLister> collection = this.getListers(string);
        if (collection != null && !collection.isEmpty()) {
            dBObjectLister = collection.iterator().next();
        }
        return dBObjectLister;
    }

    protected final List<String> getParameters(DictionaryQueries.Params[] paramsArray, Schema schema, String string, String ... stringArray) {
        return this.getParameters(paramsArray, schema == null ? null : schema.getName(), string, stringArray);
    }

    protected final List<String> getParameters(DictionaryQueries.Params[] paramsArray, String string, String string2, Collection<String> collection) {
        return this.getParameters(paramsArray, string, string2, collection.toArray(new String[collection.size()]));
    }

    protected final List<String> getParameters(DictionaryQueries.Params[] paramsArray, String string, String string2, String ... stringArray) {
        return this.getParameters(paramsArray, (Object)null, string, string2, stringArray);
    }

    protected final List<String> getParameters(DictionaryQueries.Params[] paramsArray, BaseObjectID baseObjectID) {
        return this.getParameters(paramsArray, baseObjectID instanceof IdentifierBasedID ? ((IdentifierBasedID)baseObjectID).getIdentifier() : null, baseObjectID.getSchemaName(), baseObjectID.getName(), baseObjectID.getType());
    }

    protected final List<String> getParameters(DictionaryQueries.Params[] paramsArray, Object object, String string, String string2, String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        block7: for (int i = 0; i < paramsArray.length; ++i) {
            switch (paramsArray[i]) {
                case IDENTIFIER: {
                    arrayList.add(String.valueOf(object));
                    continue block7;
                }
                case SCHEMA: {
                    arrayList.add(string);
                    continue block7;
                }
                case NAMEREF: {
                    arrayList.add(string2);
                    continue block7;
                }
                case TYPES: {
                    String string3 = DictionaryQueries.convertArrayToQuotedList(stringArray);
                    arrayList.add(string3);
                    continue block7;
                }
                case ALL_TYPES: {
                    arrayList.addAll(Arrays.asList(stringArray));
                }
            }
        }
        return arrayList;
    }

    @Override
    protected final Long getExternalTimestampImpl(SystemObject systemObject) throws DBException {
        Long l = null;
        String string = systemObject.getType();
        DictionaryQueries dictionaryQueries = this.getDictionaryQueries();
        if (dictionaryQueries.getTimestampQueryByName(string) != null || dictionaryQueries.getTimestampQueryByID(string) != null) {
            DBObjectID dBObjectID = systemObject.getID();
            Long l2 = l = dBObjectID != null ? this.getExternalTimestampByID(dBObjectID) : this.getExternalTimestampByName(systemObject.getType(), DBUtil.getSchema(systemObject), systemObject.getName());
            if (l != null) {
                l = this.getRefinedTimestamp(systemObject, l);
            }
        } else {
            DBObjectLister dBObjectLister = this.getLister(string);
            if (dBObjectLister != null && dBObjectLister.supportsTimestamps(string)) {
                l = dBObjectLister.getExternalTimestamp(systemObject);
            }
        }
        return l;
    }

    protected Long getRefinedTimestamp(SystemObject systemObject, Long l) throws DBException {
        return l;
    }

    protected final Long getExternalTimestampByID(DBObjectID dBObjectID) throws DBException {
        Long l = null;
        String string = dBObjectID == null ? null : dBObjectID.getType();
        String string2 = dBObjectID instanceof BaseObjectID ? ((BaseObjectID)dBObjectID).getDatabaseName() : null;
        String string3 = this.getDictionaryQueries().getTimestampQueryByID(string);
        if (dBObjectID instanceof IdentifierBasedID && string3 != null) {
            final Holder holder = new Holder();
            final QueryWrapper queryWrapper = this.newQueryWrapper(null, string3, ((IdentifierBasedID)dBObjectID).getIdentifier());
            queryWrapper.setDatabaseName(string2);
            QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

                @Override
                public void processResultSet(ResultSet resultSet) throws DBException {
                    try {
                        Timestamp timestamp;
                        if (resultSet.next() && (timestamp = resultSet.getTimestamp(1)) != null) {
                            holder.set((Object)new Long(timestamp.getTime()));
                        }
                    }
                    catch (SQLException sQLException) {
                        queryWrapper.throwDBException(sQLException);
                    }
                }
            };
            queryWrapper.executeQuery(queryRunnable);
            l = (Long)holder.get();
        } else if (dBObjectID instanceof BaseObjectID) {
            BaseObjectID baseObjectID = (BaseObjectID)dBObjectID;
            Schema schema = this.findSchema(baseObjectID.getSchemaName());
            l = this.getExternalTimestampByName(baseObjectID.getType(), schema, baseObjectID.getName());
        }
        return l;
    }

    protected final Long getExternalTimestampByName(String string, Schema schema, String string2) {
        Long l = null;
        String string3 = this.getDictionaryQueries().getTimestampQueryByName(string);
        if (string3 != null) {
            final Holder holder = new Holder();
            final QueryWrapper queryWrapper = this.newQueryWrapper(null, string3, schema, string2, string);
            QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

                @Override
                public void processResultSet(ResultSet resultSet) throws DBException {
                    try {
                        Timestamp timestamp;
                        if (resultSet.next() && (timestamp = resultSet.getTimestamp(1)) != null) {
                            holder.set((Object)new Long(timestamp.getTime()));
                        }
                    }
                    catch (SQLException sQLException) {
                        queryWrapper.throwDBException(sQLException);
                    }
                }
            };
            try {
                queryWrapper.executeQuery(queryRunnable);
            }
            catch (DBException dBException) {
                // empty catch block
            }
            l = (Long)holder.get();
        }
        return l;
    }

    @Override
    public final boolean exists(String string, String string2, String string3) {
        DictionaryQueries dictionaryQueries = this.getDictionaryQueries();
        String string4 = dictionaryQueries.getExistsQuery(string);
        if (string4 == null) {
            return super.exists(string, string2, string3);
        }
        final Holder holder = new Holder((Object)false);
        List<String> list = this.getParameters(dictionaryQueries.getExistsQueryParams(string), string2, string3, string);
        final QueryWrapper queryWrapper = this.newQueryWrapper(null, string4, list);
        QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

            @Override
            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    holder.set((Object)resultSet.next());
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException(sQLException);
                }
            }
        };
        try {
            queryWrapper.executeQuery(queryRunnable);
        }
        catch (DBException dBException) {
            this.getLogger().log(Level.WARNING, APIBundle.format("EXISTS_CHECK_ERR", string, string3, dBException.getMessage()));
        }
        return (Boolean)holder.get();
    }

    @Override
    public final boolean isObjectValid(String string, String string2, String string3) {
        boolean bl;
        DictionaryQueries dictionaryQueries = this.getDictionaryQueries();
        String string4 = dictionaryQueries.getObjectStatusQuery(string);
        if (string4 == null) {
            bl = super.isObjectValid(string, string2, string3);
        } else {
            List<String> list = this.getParameters(dictionaryQueries.getObjectStatusQueryParams(string), string2, string3, string);
            final QueryWrapper queryWrapper = this.newQueryWrapper(null, string4, list);
            final Holder holder = new Holder((Object)false);
            QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

                @Override
                public void processResultSet(ResultSet resultSet) throws DBException {
                    try {
                        if (resultSet.next()) {
                            String string = resultSet.getString(1);
                            holder.set((Object)"VALID".equalsIgnoreCase(string));
                        }
                    }
                    catch (SQLException sQLException) {
                        queryWrapper.throwDBException(sQLException);
                    }
                }
            };
            try {
                queryWrapper.executeQuery(queryRunnable);
            }
            catch (DBException dBException) {
                this.getLogger().log(Level.WARNING, APIBundle.format("VALID_CHECK_ERR", dBException.getMessage()));
            }
            bl = (Boolean)holder.get();
        }
        return bl;
    }

    @Override
    protected SystemObject loadObjectImpl(BaseObjectID baseObjectID) throws DBException {
        DBObjectCriteria<SystemObject> dBObjectCriteria;
        Object object;
        DBObjectLister.ObjectInfo objectInfo = null;
        final String string = baseObjectID.getType();
        DBObjectBuilder dBObjectBuilder = this.getBuilderForType(string);
        if (dBObjectBuilder != null) {
            if (baseObjectID instanceof IdentifierBasedID) {
                if (dBObjectBuilder != null && (object = ((DictionaryQueries)((Object)(dBObjectCriteria = this.getDictionaryQueries()))).getObjectQueryByID(string)) != null) {
                    final Holder holder = new Holder();
                    List<String> list = this.getParameters(((DictionaryQueries)((Object)dBObjectCriteria)).getObjectQueryByIDParams(string), (IdentifierBasedID)baseObjectID);
                    final QueryWrapper queryWrapper = this.newQueryWrapper(null, (String)object, list);
                    queryWrapper.setDatabaseName(baseObjectID.getDatabaseName());
                    QueryWrapper.QueryRunnable queryRunnable = new QueryWrapper.QueryRunnable(){

                        @Override
                        public void processResultSet(ResultSet resultSet) throws DBException {
                            try {
                                if (resultSet.next()) {
                                    Timestamp timestamp;
                                    Schema schema = DictionaryDatabase.this.findSchema(resultSet.getString(1));
                                    String string2 = resultSet.getString(2);
                                    Long l = null;
                                    if (resultSet.getMetaData().getColumnCount() > 2 && (timestamp = resultSet.getTimestamp(3)) != null) {
                                        l = timestamp.getTime();
                                    }
                                    holder.set((Object)new DBObjectLister.ObjectInfo(string, schema, string2, null, l));
                                }
                            }
                            catch (SQLException sQLException) {
                                queryWrapper.throwDBException(null, sQLException);
                            }
                        }
                    };
                    queryWrapper.executeQuery(queryRunnable);
                    objectInfo = (DBObjectLister.ObjectInfo)holder.get();
                }
            } else if (baseObjectID instanceof NameBasedID && (object = this.listObjectInfos(dBObjectCriteria = DBObjectCriteria.createSingleObjectCriteria(string, baseObjectID.getDatabaseName(), baseObjectID.getSchemaName(), baseObjectID.getName()))) != null && object.size() == 1) {
                objectInfo = (DBObjectLister.ObjectInfo)object.iterator().next();
            }
        }
        dBObjectCriteria = null;
        if (objectInfo != null) {
            dBObjectCriteria = (SystemObject)dBObjectBuilder.createObject(objectInfo.getName(), objectInfo.getSchema(), baseObjectID);
            dBObjectCriteria.setID(baseObjectID);
            if (dBObjectCriteria instanceof AbstractBuildableObject) {
                this.markForLazyInit((AbstractBuildableObject)((Object)dBObjectCriteria));
            }
            if ((object = objectInfo.getTimestamp()) != null) {
                dBObjectCriteria.setProperty("Timestamp", object);
                this.putCachedTimestampKey(baseObjectID, object);
            }
            this.cacheObject((SystemObject)((Object)dBObjectCriteria), true);
        }
        return dBObjectCriteria;
    }

    @Override
    protected final String getAliveTestStatement() {
        DictionaryQueries dictionaryQueries = this.getDictionaryQueries();
        return dictionaryQueries == null ? null : dictionaryQueries.getAliveTestStatement();
    }

    @Override
    protected String queryCurrentUserName() throws DBException {
        String string;
        DictionaryQueries dictionaryQueries = this.getDictionaryQueries();
        String string2 = dictionaryQueries.getUserNameQuery();
        if (string2 == null) {
            string = super.queryCurrentUserName();
        } else {
            QueryWrapper queryWrapper = this.newQueryWrapper(null, string2, new Object[0]);
            string = queryWrapper.executeSingleCellQuery();
        }
        return string;
    }

    private Schema getCriteriaSchema(DBObjectCriteria dBObjectCriteria) throws DBException {
        Schema schema;
        if (dBObjectCriteria.getDatabaseName() == null) {
            schema = this.findSchema(dBObjectCriteria.getSchemaName());
        } else {
            String string;
            if (dBObjectCriteria.getSchemaName() != null) {
                string = dBObjectCriteria.getSchemaName();
            } else {
                String string2;
                DatabaseLink databaseLink = (DatabaseLink)this.getObject("DATABASE LINK", this.findSchema(this.getCurrentSchemaName()), dBObjectCriteria.getDatabaseName());
                if (databaseLink == null && (string2 = this.getDescriptor().getPublicSchemaName()) != null) {
                    databaseLink = (DatabaseLink)this.getObject("DATABASE LINK", this.findSchema(string2), dBObjectCriteria.getDatabaseName());
                }
                string = databaseLink != null ? this.getDefaultSchemaName(databaseLink) : null;
            }
            schema = string == null ? null : new Schema(string);
        }
        return schema;
    }
}

