/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.DifferenceFilter;
import oracle.javatools.db.diff.ResultSet;

public class DefaultResultSetFilter
implements DifferenceFilter {
    private Collection<String> m_filteredProps = new ArrayList<String>();

    public void addFilteredProps(String string) {
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        this.addFilteredProps(stringArray);
    }

    public void addFilteredProps(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.m_filteredProps.add(stringArray[i].replaceAll("//", "/[^/]*/"));
        }
    }

    @Deprecated
    public boolean isFilteredProperty(ResultSet resultSet, String string) {
        return this.isFilteredProperty((Difference)resultSet, string);
    }

    @Override
    public boolean isFilteredProperty(Difference difference, String string) {
        if (string != null) {
            for (String string2 : this.m_filteredProps) {
                if (string.equals(string2)) {
                    return true;
                }
                if (Pattern.matches(string2, string)) {
                    return true;
                }
                if (!Pattern.matches(string2 + "/.*", string + "/")) continue;
                return true;
            }
        }
        return false;
    }
}

