/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.Differ;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.property.PropertyCriteria;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;

public class GenericBeanDiffer
implements Differ {
    @Override
    public boolean diff(Object object, Object object2, ResultSet resultSet, DiffContext diffContext) {
        Object object3;
        boolean bl = true;
        Object object4 = object == null ? object2 : object;
        PropertyCriteria propertyCriteria = PropertyCriteria.createEmptyCriteria();
        propertyCriteria.setIncludeExtra(false);
        Map<String, PropertyInfo> map = PropertyHelper.getPropertyInfos(object4.getClass(), null, propertyCriteria);
        if (map.size() == 0) {
            return false;
        }
        boolean bl2 = diffContext.isTreeRequired();
        if (!bl2 && (object3 = resultSet.getParent()) != null) {
            bl2 = ((ResultSet)object3).isMap();
        }
        if (!(bl2 || object != null && object2 != null)) {
            bl = false;
        } else if (bl2 || !ModelUtil.areEqual((Object)object, (Object)object2)) {
            if (object != null && object2 != null && object.getClass() != object2.getClass()) {
                bl = false;
            } else {
                ResultSet resultSet2;
                object3 = new ArrayList();
                for (PropertyInfo propertyInfo : map.values()) {
                    if (this.ignoreProperty(propertyInfo)) continue;
                    if (propertyInfo.isDerived()) {
                        object3.add(propertyInfo);
                        continue;
                    }
                    resultSet2 = this.diffProperty(object, object2, resultSet, diffContext, propertyInfo, map);
                    if (resultSet2 == null) continue;
                    bl &= resultSet2.isSame();
                }
                Iterator<PropertyInfo> iterator = object3.iterator();
                while (iterator.hasNext()) {
                    PropertyInfo propertyInfo;
                    propertyInfo = iterator.next();
                    resultSet2 = this.diffProperty(object, object2, resultSet, diffContext, propertyInfo, map);
                    if (resultSet2 == null) continue;
                    bl &= resultSet2.isSame();
                }
            }
        }
        resultSet.setSame(bl);
        return true;
    }

    protected ResultSet diffProperty(Object object, Object object2, ResultSet resultSet, DiffContext diffContext, PropertyInfo propertyInfo, Map<String, PropertyInfo> map) {
        String string = propertyInfo.getPropertyName();
        Object object3 = object == null ? null : propertyInfo.getPropertyValue(object);
        Object object4 = object2 == null ? null : propertyInfo.getPropertyValue(object2);
        ResultSet resultSet2 = new ResultSet(resultSet, object3, object4, string, "MAP");
        if (object3 != null && object4 != null && !this.canDiffClasses(object3.getClass(), object4.getClass(), diffContext)) {
            resultSet2.setSame(false);
        } else if (object3 == null && object4 == null) {
            resultSet2.setSame(object3 == object4);
        } else {
            diffContext.getEngine().diff(object3, object4, resultSet2, diffContext);
        }
        return resultSet2;
    }

    private boolean canDiffClasses(Class clazz, Class clazz2, DiffContext diffContext) {
        boolean bl = false;
        if (clazz == clazz2) {
            bl = true;
        } else if (SQLFragment.class.isAssignableFrom(clazz) && SQLFragment.class.isAssignableFrom(clazz2) && diffContext.getEngine().hasRegisteredDiffer(SQLFragment.class)) {
            bl = true;
        } else if (DBObjectID.class.isAssignableFrom(clazz) && DBObjectID.class.isAssignableFrom(clazz2)) {
            bl = true;
        }
        return bl;
    }

    protected boolean ignoreProperty(PropertyInfo propertyInfo) {
        return propertyInfo.getPropertyName().equals("ID") || propertyInfo.isDeprecated() || propertyInfo.isInternal();
    }
}

