/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.DifferenceFilter;
import oracle.javatools.util.ModelUtil;

public class ResultSet
extends Difference {
    public static final String LIST = "LIST";
    public static final String MAP = "MAP";
    public static final String LEAF = "LEAF";
    public static String ORIGINAL = "ORIGINAL";
    public static String UPDATED = "UPDATED";
    private String m_updateContributor;
    private Object m_a;
    private Object m_b;
    private String m_propertyName;
    private int m_indexOfA = -1;
    private int m_indexOfB = -1;
    private boolean m_listReordered;
    private List<ResultSet> m_list;
    private Map<String, ResultSet> m_map;

    protected ResultSet() {
    }

    public ResultSet(ResultSet resultSet, Object object, Object object2, int n, int n2, String string, String string2) {
        this.setUpdateContributor(UPDATED);
        if (n >= 0 || n2 >= 0) assert (resultSet.getType().equals(LIST));
        this.setParent(resultSet);
        this.m_a = object;
        this.m_b = object2;
        this.m_propertyName = string;
        if (MAP.equals(string2) && string != null && string.contains("/")) {
            this.m_propertyName = string.replaceAll("/", "_");
        }
        this.setType(string2);
        if (resultSet != null) {
            if (LIST.equals(resultSet.getType())) {
                resultSet.addToList(this);
                this.m_indexOfA = n;
                this.m_indexOfB = n2;
            }
            if (MAP.equals(resultSet.getType())) {
                resultSet.addToMap(string, this);
            }
        }
    }

    public ResultSet(ResultSet resultSet, Object object, Object object2, String string, String string2) {
        this(resultSet, object, object2, -1, -1, string, string2);
    }

    public ResultSet(ResultSet resultSet, boolean bl, Object object, Object object2, String string) {
        this(resultSet, object, object2, string, LEAF);
        this.setSame(bl);
    }

    protected void setType(String string) {
        this.m_list = string.equals(LIST) ? new ArrayList() : null;
        this.m_map = string.equals(MAP) ? new HashMap() : null;
    }

    @Override
    public ResultSet getParent() {
        return (ResultSet)super.getParent();
    }

    public String getType() {
        String string = LEAF;
        if (null != this.m_list) {
            string = LIST;
        } else if (null != this.m_map) {
            string = MAP;
        }
        return string;
    }

    public void addToList(ResultSet resultSet) {
        resultSet.setParent(this);
        this.m_list.add(resultSet);
    }

    public void addToMap(String string, ResultSet resultSet) {
        resultSet.setParent(this);
        this.m_map.put(string, resultSet);
    }

    @Override
    public boolean isModified() {
        return !this.isSame() && this.a() != null && this.b() != null;
    }

    public Object a() {
        return this.m_a;
    }

    public void setA(Object object) {
        this.m_a = object;
    }

    public Object b() {
        return this.m_b;
    }

    public void setB(Object object) {
        this.m_b = object;
    }

    public void setName(String string) {
        this.m_propertyName = string;
    }

    @Override
    public String getPropertyName() {
        return this.m_propertyName;
    }

    public String getName() {
        String string = this.m_propertyName;
        if (MAP.equals(this.getType())) {
            if (this.m_b == null && this.m_a instanceof DBObject) {
                string = ((DBObject)this.m_a).getName();
            } else if (this.m_b != null && this.m_b instanceof DBObject) {
                string = ((DBObject)this.m_b).getName();
            }
        }
        return ModelUtil.hasLength((String)string) ? string : this.m_propertyName;
    }

    public boolean isChildListReorder() {
        return this.m_listReordered;
    }

    public void setListReordered(boolean bl) {
        this.m_listReordered = bl;
    }

    public List<ResultSet> getModifiedObjectList() {
        ArrayList<ResultSet> arrayList = new ArrayList<ResultSet>();
        if (this.m_list != null) {
            for (Difference difference : this.m_list) {
                ResultSet resultSet = (ResultSet)difference;
                if (resultSet.a() == null || resultSet.b() == null || resultSet.isSame()) continue;
                arrayList.add(resultSet);
            }
        }
        return arrayList;
    }

    public List<ResultSet> getNotSameObjectList() {
        ArrayList<ResultSet> arrayList = new ArrayList<ResultSet>();
        if (this.m_list != null) {
            for (Difference difference : this.m_list) {
                if (difference.isSame()) continue;
                arrayList.add((ResultSet)difference);
            }
        }
        return arrayList;
    }

    public boolean inBbutNotA() {
        return !this.isSame() && this.a() == null && this.b() != null;
    }

    public int getIndexOfA() {
        return this.m_indexOfA;
    }

    public int getIndexOfB() {
        return this.m_indexOfB;
    }

    @Override
    public int getIndexOf(String string) {
        if (UPDATED.equals(string)) {
            return this.m_indexOfB;
        }
        return this.m_indexOfA;
    }

    public List<ResultSet> getAList() {
        ArrayList<ResultSet> arrayList = new ArrayList<ResultSet>();
        if (this.m_list != null) {
            for (Difference difference : this.m_list) {
                ResultSet resultSet = (ResultSet)difference;
                if (!resultSet.inA()) continue;
                arrayList.add(resultSet);
            }
        }
        return arrayList;
    }

    public List<ResultSet> getBList() {
        ArrayList<ResultSet> arrayList = new ArrayList<ResultSet>();
        if (this.m_list != null) {
            for (Difference difference : this.m_list) {
                ResultSet resultSet = (ResultSet)difference;
                if (!resultSet.inB()) continue;
                arrayList.add(resultSet);
            }
        }
        return arrayList;
    }

    public List<ResultSet> getBonlyList() {
        ArrayList<ResultSet> arrayList = new ArrayList<ResultSet>();
        if (this.m_list != null) {
            for (Difference difference : this.m_list) {
                ResultSet resultSet = (ResultSet)difference;
                if (!resultSet.inBbutNotA()) continue;
                arrayList.add(resultSet);
            }
        }
        return arrayList;
    }

    public boolean inA() {
        return this.a() != null;
    }

    public boolean inB() {
        return this.b() != null;
    }

    public boolean inAbutNotB() {
        return !this.isSame() && this.a() != null && this.b() == null;
    }

    public List<ResultSet> getAonlyList() {
        ArrayList<ResultSet> arrayList = new ArrayList<ResultSet>();
        if (this.m_list != null) {
            for (Difference difference : this.m_list) {
                ResultSet resultSet = (ResultSet)difference;
                if (!resultSet.inAbutNotB()) continue;
                arrayList.add(resultSet);
            }
        }
        return arrayList;
    }

    public List<ResultSet> getAllObjectsList() {
        return this.m_list == null ? null : new ArrayList<ResultSet>(this.m_list);
    }

    public Map<String, ResultSet> getModifiedObjectMap() {
        HashMap<String, ResultSet> hashMap = new HashMap<String, ResultSet>();
        if (this.m_map != null) {
            for (String string : this.m_map.keySet()) {
                ResultSet resultSet = this.m_map.get(string);
                if (resultSet.a() == null || resultSet.b() == null || resultSet.isSame()) continue;
                hashMap.put(string, resultSet);
            }
        }
        return hashMap;
    }

    public Map<String, ResultSet> getNotSameObjectMap() {
        HashMap<String, ResultSet> hashMap = new HashMap<String, ResultSet>();
        if (this.m_map != null) {
            for (String string : this.m_map.keySet()) {
                ResultSet resultSet = this.m_map.get(string);
                if (resultSet.isSame()) continue;
                hashMap.put(string, resultSet);
            }
        }
        return hashMap;
    }

    public Map<String, ResultSet> getBonlyMap() {
        HashMap<String, ResultSet> hashMap = new HashMap<String, ResultSet>();
        if (this.m_map != null) {
            for (String string : this.m_map.keySet()) {
                ResultSet resultSet = this.m_map.get(string);
                if (resultSet.a() != null || resultSet.b() == null) continue;
                hashMap.put(string, resultSet);
            }
        }
        return hashMap;
    }

    public Map getAonlyMap() {
        HashMap<String, ResultSet> hashMap = new HashMap<String, ResultSet>();
        if (this.m_map != null) {
            for (String string : this.m_map.keySet()) {
                ResultSet resultSet = this.m_map.get(string);
                if (resultSet.a() == null || resultSet.b() != null) continue;
                hashMap.put(string, resultSet);
            }
        }
        return hashMap;
    }

    public Map<String, ResultSet> getAllObjectsMap() {
        return this.m_map == null ? null : new HashMap<String, ResultSet>(this.m_map);
    }

    public Class getResultSetClass() {
        Object object = this.getResultSetObject();
        return object == null ? null : object.getClass();
    }

    public Object getResultSetObject() {
        Object object = this.a();
        return object == null ? this.b() : object;
    }

    public Collection<ResultSet> getChildren() {
        Collection<ResultSet> collection = null != this.m_map ? this.m_map.values() : (null != this.m_list ? this.m_list : Collections.emptyList());
        return collection;
    }

    @Deprecated
    public Iterator<ResultSet> getChildIterator() {
        Iterator<ResultSet> iterator = null != this.m_map ? this.m_map.values().iterator() : (null != this.m_list ? this.m_list.iterator() : Collections.emptyList().iterator());
        return iterator;
    }

    public ResultSet copyTo(Object object) {
        ResultSet resultSet = object == null ? new ResultSet() : (ResultSet)object;
        this.copyToImpl(resultSet);
        return resultSet;
    }

    protected void copyToImpl(ResultSet resultSet) {
        ResultSet resultSet2;
        super.copyToImpl(resultSet);
        resultSet.m_updateContributor = this.m_updateContributor;
        resultSet.m_a = this.m_a;
        resultSet.m_b = this.m_b;
        resultSet.m_propertyName = this.m_propertyName;
        resultSet.m_indexOfA = this.m_indexOfA;
        resultSet.m_indexOfB = this.m_indexOfB;
        resultSet.m_listReordered = this.m_listReordered;
        if (this.m_list != null) {
            resultSet.m_list = new ArrayList<ResultSet>();
            for (Difference object : this.m_list) {
                resultSet2 = (ResultSet)object;
                ResultSet resultSet3 = resultSet2.copyTo(null);
                resultSet.addToList(resultSet3);
            }
        }
        if (this.m_map != null) {
            resultSet.m_map = new HashMap<String, ResultSet>();
            for (String string : this.m_map.keySet()) {
                resultSet2 = this.m_map.get(string).copyTo(null);
                resultSet.addToMap(string, resultSet2);
            }
        }
    }

    @Deprecated
    public ResultSet getFilteredResultSet(DifferenceFilter differenceFilter) {
        return (ResultSet)this.getFilteredDifference(differenceFilter);
    }

    protected boolean hasChildren() {
        return this.m_map != null && !this.m_map.isEmpty() || this.m_list != null && !this.m_list.isEmpty();
    }

    @Override
    public boolean isLeaf() {
        String string = this.getType();
        return LEAF.equals(string) || MAP.equals(string) && !this.hasChildren();
    }

    @Override
    public boolean isMap() {
        return MAP.equals(this.getType()) && this.hasChildren();
    }

    @Override
    public boolean isList() {
        return LIST.equals(this.getType());
    }

    @Override
    public Object getObject(String string) {
        if (UPDATED.equals(string)) {
            return this.b();
        }
        return this.a();
    }

    @Override
    public void setObject(String string, Object object) {
        if (UPDATED.equals(string)) {
            this.setB(object);
        } else {
            this.setA(object);
        }
    }

    public List<Difference> getList(String string) {
        if (UPDATED.equals(string)) {
            return new ArrayList<Difference>(this.getBList());
        }
        return new ArrayList<Difference>(this.getAList());
    }

    @Override
    public String getOriginalContributor() {
        return ORIGINAL;
    }

    public Class getDifferenceClass() {
        return this.getResultSetClass();
    }

    @Override
    public void setUpdateContributor(String string) {
        this.m_updateContributor = string;
    }

    @Override
    public String getUpdateContributor() {
        return this.m_updateContributor;
    }
}

