/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.event;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.util.ModelUtil;

public class DBObjectChange {
    public static final String NAME_PROPERTY = "name";
    private final DBObject m_obj;
    private DBObjectProvider m_pro;
    private static final String ADD_KEY = "ADDED";
    private static final String KID_KEY = "CHILDREN";
    private static final String PROP_KEY = "PROPERTIES";
    private static final String DEL_KEY = "REMOVED";
    private static final String ORD_KEY = "ORDERED";

    protected DBObjectChange(DBObject dBObject, DBObjectProvider dBObjectProvider) {
        this.m_obj = dBObject;
        this.m_pro = dBObjectProvider;
    }

    public final DBObjectProvider getProvider() {
        return this.m_pro;
    }

    public final void ensureProvider(DBObjectProvider dBObjectProvider) {
        if (this.m_pro == null) {
            this.m_pro = dBObjectProvider;
        }
    }

    public final DBObject getDBObject() {
        return this.m_obj;
    }

    public List<DBObject> getOwnedObjectsAdded() {
        return Collections.emptyList();
    }

    public List<DBObject> getOwnedObjectsRemoved() {
        return Collections.emptyList();
    }

    public Map<String, PropertyChangeEvent> getPropertiesChanged() {
        return Collections.emptyMap();
    }

    public PropertyChangeEvent getPropertyChange(String string) {
        return this.getPropertiesChanged().get(string);
    }

    public Map<DBObject, DBObjectChange> getOwnedObjectsUpdated() {
        return Collections.emptyMap();
    }

    public DBObjectChange getOwnedObjectUpdate(DBObject dBObject) {
        return this.getOwnedObjectsUpdated().get(dBObject);
    }

    public Collection<DBObjectChange> getOwnedObjectsUpdated(String string) {
        ArrayList<DBObjectChange> arrayList = null;
        if (ModelUtil.hasLength((String)string)) {
            for (Map.Entry<DBObject, DBObjectChange> entry : this.getOwnedObjectsUpdated().entrySet()) {
                DBObject dBObject = entry.getKey();
                String string2 = DBUtil.getParentProperty(dBObject);
                if (!string.equals(string2)) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<DBObjectChange>();
                }
                arrayList.add(entry.getValue());
            }
        }
        return arrayList == null ? Collections.emptyList() : arrayList;
    }

    public Collection<String> getAllChangedProperties() {
        Collection<String> collection;
        Set<DBObject> set = this.getOwnedObjectsUpdated().keySet();
        if (set.isEmpty()) {
            collection = this.getPropertiesChanged().keySet();
        } else {
            collection = new ArrayList();
            collection.addAll(this.getPropertiesChanged().keySet());
            for (DBObject dBObject : set) {
                String string = DBUtil.getParentProperty(dBObject);
                if (string == null) continue;
                collection.add(string);
            }
        }
        return collection;
    }

    public boolean hasNameChanged() {
        PropertyChangeEvent propertyChangeEvent = this.getPropertyChange(NAME_PROPERTY);
        return propertyChangeEvent != null;
    }

    public static DBObjectChange merge(DBObjectChange ... dBObjectChangeArray) {
        Object object;
        if (!ModelUtil.hasNonNullElement((Object[])dBObjectChangeArray)) {
            throw new IllegalArgumentException("Missing changes to merge");
        }
        if (dBObjectChangeArray.length == 1) {
            object = dBObjectChangeArray[0];
        } else {
            DBObject dBObject = dBObjectChangeArray[0].m_obj;
            DBObjectProvider dBObjectProvider = null;
            for (DBObjectChange dBObjectChange : dBObjectChangeArray) {
                if (dBObjectChange == null || dBObjectChange.m_pro == null) continue;
                dBObjectProvider = dBObjectChange.m_pro;
                break;
            }
            Object object2 = null;
            int n = 0;
            if (dBObjectChangeArray[0] instanceof CompoundChange) {
                object2 = (CompoundChange)dBObjectChangeArray[0];
                n = 1;
                if (dBObjectChangeArray[0].m_pro == null && dBObjectProvider != null) {
                    dBObjectChangeArray[0].m_pro = dBObjectProvider;
                }
            }
            for (int i = n; i < dBObjectChangeArray.length; ++i) {
                DBObjectChange dBObjectChange;
                dBObjectChange = dBObjectChangeArray[i];
                if (dBObjectChange == null) continue;
                if (object2 == null) {
                    object2 = new CompoundChange(dBObject, dBObjectProvider);
                } else {
                    if (dBObjectChange.m_obj != dBObject) {
                        throw new IllegalArgumentException("Cannot merge changes for difference objects");
                    }
                    if (dBObjectChange.m_pro != null && dBObjectChange.m_pro != dBObjectProvider) {
                        throw new IllegalArgumentException("Cannot merge changes for objects from different providers");
                    }
                }
                ((CompoundChange)object2).merge(dBObjectChange);
            }
            object = object2;
        }
        return object;
    }

    public static void fireObjectUpdated(DBObject dBObject) {
        DBObjectChange.fireObjectUpdated(dBObject, null, null, null);
    }

    public static void fireChildrenAdded(DBObject dBObject, List list) {
        DBObjectChange.fireObjectUpdated(dBObject, list, null, null);
    }

    public static void fireChildrenRemoved(DBObject dBObject, List list) {
        DBObjectChange.fireObjectUpdated(dBObject, null, list, null);
    }

    public static void firePropertyChanged(DBObject dBObject, PropertyChangeEvent ... propertyChangeEventArray) {
        if (propertyChangeEventArray != null) {
            HashMap<String, PropertyChangeEvent> hashMap = new HashMap<String, PropertyChangeEvent>(propertyChangeEventArray.length);
            for (PropertyChangeEvent propertyChangeEvent : propertyChangeEventArray) {
                hashMap.put(propertyChangeEvent.getPropertyName(), propertyChangeEvent);
            }
            DBObjectChange.fireObjectUpdated(dBObject, null, null, hashMap);
        }
    }

    public static void firePropertiesChanged(DBObject dBObject, Map<String, PropertyChangeEvent> map) {
        DBObjectChange.fireObjectUpdated(dBObject, null, null, map);
    }

    public static void fireObjectUpdated(DBObject dBObject, List<DBObject> list, List<DBObject> list2, Map<String, PropertyChangeEvent> map) {
        Impl impl = new Impl(dBObject);
        impl.put(ADD_KEY, list);
        impl.put(DEL_KEY, list2);
        impl.put(PROP_KEY, map);
        if (!(dBObject instanceof AbstractDBObject)) {
            throw new IllegalArgumentException("obj must be an AbstractDBObject");
        }
        ((AbstractDBObject)dBObject).fireObjectUpdated(impl);
    }

    private static class CompoundChange
    extends DBObjectChange {
        private Collection<DBObjectChange> m_changes = new ArrayList<DBObjectChange>();

        CompoundChange(DBObject dBObject, DBObjectProvider dBObjectProvider) {
            super(dBObject, dBObjectProvider);
        }

        public void merge(DBObjectChange dBObjectChange) {
            if (dBObjectChange instanceof CompoundChange) {
                this.m_changes.addAll(((CompoundChange)dBObjectChange).m_changes);
            } else if (dBObjectChange != null) {
                this.m_changes.add(dBObjectChange);
            }
        }

        @Override
        public List<DBObject> getOwnedObjectsAdded() {
            ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
            for (DBObjectChange dBObjectChange : this.m_changes) {
                arrayList.addAll(dBObjectChange.getOwnedObjectsAdded());
            }
            return arrayList;
        }

        @Override
        public List<DBObject> getOwnedObjectsRemoved() {
            ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
            for (DBObjectChange dBObjectChange : this.m_changes) {
                arrayList.addAll(dBObjectChange.getOwnedObjectsRemoved());
            }
            return arrayList;
        }

        @Override
        public Map<DBObject, DBObjectChange> getOwnedObjectsUpdated() {
            IdentityHashMap<DBObject, DBObjectChange> identityHashMap = new IdentityHashMap<DBObject, DBObjectChange>();
            for (DBObjectChange dBObjectChange : this.m_changes) {
                identityHashMap.putAll(dBObjectChange.getOwnedObjectsUpdated());
            }
            return identityHashMap;
        }

        @Override
        public Collection<String> getAllChangedProperties() {
            HashSet<String> hashSet = new HashSet<String>();
            for (DBObjectChange dBObjectChange : this.m_changes) {
                hashSet.addAll(dBObjectChange.getAllChangedProperties());
            }
            return hashSet;
        }

        @Override
        public Map<String, PropertyChangeEvent> getPropertiesChanged() {
            HashMap<String, PropertyChangeEvent> hashMap = new HashMap<String, PropertyChangeEvent>();
            for (DBObjectChange dBObjectChange : this.m_changes) {
                hashMap.putAll(dBObjectChange.getPropertiesChanged());
            }
            return hashMap;
        }
    }

    static class Impl
    extends oracle.javatools.db.DBObjectChange {
        private Map<String, Object> m_changes = new HashMap<String, Object>();

        private Impl(DBObject dBObject) {
            super(dBObject, null);
        }

        void put(String string, Object object) {
            if (object != null) {
                this.m_changes.put(string, object);
            }
        }

        private List getChangeList(String string) {
            if (this.m_changes.containsKey(string)) {
                return (List)this.m_changes.get(string);
            }
            return Collections.emptyList();
        }

        private Map getChangeMap(String string) {
            if (this.m_changes.containsKey(string)) {
                return (Map)this.m_changes.get(string);
            }
            return Collections.emptyMap();
        }

        @Override
        public List<DBObject> getOwnedObjectsAdded() {
            return this.getChangeList(DBObjectChange.ADD_KEY);
        }

        @Override
        public Map<DBObject, DBObjectChange> getOwnedObjectsUpdated() {
            return this.getChangeMap(DBObjectChange.KID_KEY);
        }

        @Override
        public List<DBObject> getOwnedObjectsRemoved() {
            return this.getChangeList(DBObjectChange.DEL_KEY);
        }

        public Map<DBObject, PropertyChangeEvent> getOwnedObjectsReordered() {
            return this.getChangeMap(DBObjectChange.ORD_KEY);
        }

        @Override
        public Map<String, PropertyChangeEvent> getPropertiesChanged() {
            return this.getChangeMap(DBObjectChange.PROP_KEY);
        }
    }
}

