/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.hive;

import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.hive.HiveDatabase;
import oracle.javatools.db.property.PropertyKey;
import oracle.javatools.db.sql.AbstractSQLFragment;

public class TblProperty
extends AbstractSQLFragment {
    @PropertyKey(value=TblProperty[].class, childOf={Table.class}, provider=HiveDatabase.class)
    public static final String LIST_PROPERTY = "TBLPROPERTIES";
    public static final String TYPE = "TblProperty";

    public TblProperty() {
    }

    public TblProperty(String string, String string2) {
        this.setName(string);
        this.setTablePropertyValue(string2);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getName() {
        return super.getName();
    }

    public String getTablePropertyValue() {
        return (String)this.getProperty("tablePropertyValue");
    }

    public void setTablePropertyValue(String string) {
        this.setProperty("tablePropertyValue", string);
    }

    @Override
    public String getSQLText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendWithQuotes(stringBuilder, this.getName());
        stringBuilder.append("=");
        this.appendWithQuotes(stringBuilder, this.getTablePropertyValue());
        return stringBuilder.toString();
    }

    private void appendWithQuotes(StringBuilder stringBuilder, String string) {
        stringBuilder.append("'");
        if (string != null) {
            stringBuilder.append(String.valueOf(string).replace("'", "\\'"));
        }
        stringBuilder.append("'");
    }

    public static final void setTblProperty(AbstractDBObject abstractDBObject, String string, String string2) {
        AbstractDBObject.ChildSupport childSupport = TblProperty.getChildSupport(abstractDBObject, LIST_PROPERTY);
        TblProperty tblProperty = (TblProperty)childSupport.findChild(string);
        if (tblProperty == null && string2 != null) {
            childSupport.addChild(new TblProperty(string, string2));
        } else if (string2 == null) {
            childSupport.removeChild(tblProperty);
        } else {
            tblProperty.setTablePropertyValue(string2);
        }
    }
}

