/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.marshal;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.marshal.PartialParseUnsupportedException;
import oracle.javatools.db.plsql.PlSqlSchemaObjectBody;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.db.property.PropertyCriteria;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.util.DBObjectIDSet;
import oracle.javatools.util.ModelUtil;

public abstract class DBObjectHandler {
    protected String getEncoding() {
        return "UTF-8";
    }

    public final void write(DBObject dBObject, OutputStream outputStream) throws IOException {
        this.write(Collections.singletonList(dBObject), outputStream);
    }

    public final void write(DBObject dBObject, Writer writer) throws IOException {
        this.write(Collections.singletonList(dBObject), writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(List<? extends DBObject> list, URL uRL) throws IOException {
        OutputStream outputStream = URLFileSystem.openOutputStream((URL)uRL);
        try {
            this.write(list, outputStream);
        }
        finally {
            this.close(outputStream);
        }
    }

    public final void write(List<? extends DBObject> list, OutputStream outputStream) throws IOException {
        this.write(list, (Writer)new OutputStreamWriter(outputStream, this.getEncoding()));
    }

    public abstract void write(List<? extends DBObject> var1, Writer var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean canRead(URL uRL, DBObjectProvider dBObjectProvider) throws IOException {
        boolean bl = false;
        InputStream inputStream = URLFileSystem.openInputStream((URL)uRL);
        try {
            bl = this.canRead(inputStream, dBObjectProvider);
        }
        finally {
            this.close(inputStream);
        }
        return bl;
    }

    public final boolean canRead(InputStream inputStream, DBObjectProvider dBObjectProvider) throws IOException {
        return this.canRead(new InputStreamReader(inputStream, this.getEncoding()), dBObjectProvider);
    }

    public abstract boolean canRead(Reader var1, DBObjectProvider var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<DBObject> read(URL uRL, DBObjectProvider dBObjectProvider, Schema schema) throws IOException {
        List<DBObject> list = null;
        schema = this.checkSchema(uRL, schema);
        InputStream inputStream = URLFileSystem.openInputStream((URL)uRL);
        try {
            list = this.read(inputStream, dBObjectProvider, schema);
        }
        finally {
            this.close(inputStream);
        }
        return list;
    }

    private Schema checkSchema(URL uRL, Schema schema) {
        String string;
        if (schema == null && ModelUtil.hasLength((String)(string = this.getSchemaName(uRL)))) {
            schema = new Schema(string);
        }
        return schema;
    }

    protected String getSchemaName(URL uRL) {
        return URLFileSystem.getName((URL)URLFileSystem.getParent((URL)uRL));
    }

    public final List<DBObject> read(InputStream inputStream, DBObjectProvider dBObjectProvider, Schema schema) throws IOException {
        return this.read(new InputStreamReader(inputStream, this.getEncoding()), dBObjectProvider, schema);
    }

    public final List<DBObject> read(Reader reader, DBObjectProvider dBObjectProvider, Schema schema) throws IOException {
        return this.read(reader, dBObjectProvider, schema, true);
    }

    public final List<DBObject> read(Reader reader, DBObjectProvider dBObjectProvider, Schema schema, boolean bl) throws IOException {
        List<DBObject> list = this.readImpl(reader, dBObjectProvider, schema);
        if (list != null) {
            for (DBObject dBObject : list) {
                Schema schema2;
                Schema schema3 = schema;
                if (!bl && dBObject instanceof SchemaObject && (schema2 = ((SchemaObject)dBObject).getSchema()) != null) {
                    schema3 = schema2;
                }
                this.ensureDetails(dBObject, dBObjectProvider, schema3, false);
            }
        }
        return list;
    }

    protected void ensureDetails(DBObject dBObject, DBObjectProvider dBObjectProvider, Schema schema, boolean bl) {
        if (dBObject instanceof SchemaObject) {
            ((SchemaObject)dBObject).setSchema(schema);
        }
        if (dBObject != null && dBObjectProvider != null) {
            dBObjectProvider.getObjectFactory().ensureID(dBObject, !bl, bl);
        }
    }

    protected abstract List<DBObject> readImpl(Reader var1, DBObjectProvider var2, Schema var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<DBObject> readInfo(URL uRL, DBObjectProvider dBObjectProvider, Schema schema) throws IOException, PartialParseUnsupportedException {
        List<DBObject> list = null;
        schema = this.checkSchema(uRL, schema);
        InputStream inputStream = URLFileSystem.openInputStream((URL)uRL);
        try {
            list = this.readInfo(inputStream, dBObjectProvider, schema);
        }
        finally {
            this.close(inputStream);
        }
        return list;
    }

    public final List<DBObject> readInfo(InputStream inputStream, DBObjectProvider dBObjectProvider, Schema schema) throws IOException, PartialParseUnsupportedException {
        return this.readInfo(new InputStreamReader(inputStream, this.getEncoding()), dBObjectProvider, schema);
    }

    public final List<DBObject> readInfo(Reader reader, DBObjectProvider dBObjectProvider, Schema schema) throws IOException, PartialParseUnsupportedException {
        List<DBObject> list = this.readInfoImpl(reader, dBObjectProvider, schema);
        if (list != null) {
            for (DBObject dBObject : list) {
                this.ensureDetails(dBObject, dBObjectProvider, schema, true);
            }
        }
        return list;
    }

    protected List<DBObject> readInfoImpl(Reader reader, DBObjectProvider dBObjectProvider, Schema schema) throws IOException, PartialParseUnsupportedException {
        throw new PartialParseUnsupportedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final UnmarshalledIDs readIDs(URL uRL, DBObjectProvider dBObjectProvider, Schema schema) throws IOException, PartialParseUnsupportedException {
        UnmarshalledIDs unmarshalledIDs = null;
        schema = this.checkSchema(uRL, schema);
        InputStream inputStream = URLFileSystem.openInputStream((URL)uRL);
        try {
            unmarshalledIDs = this.readIDs(inputStream, dBObjectProvider, schema);
        }
        finally {
            this.close(inputStream);
        }
        return unmarshalledIDs;
    }

    public final UnmarshalledIDs readIDs(InputStream inputStream, DBObjectProvider dBObjectProvider, Schema schema) throws IOException, PartialParseUnsupportedException {
        return this.readIDs(new InputStreamReader(inputStream, this.getEncoding()), dBObjectProvider, schema);
    }

    public final UnmarshalledIDs readIDs(Reader reader, DBObjectProvider dBObjectProvider, Schema schema) throws IOException, PartialParseUnsupportedException {
        UnmarshalledIDs unmarshalledIDs = new UnmarshalledIDs(dBObjectProvider);
        this.readIDsImpl(unmarshalledIDs, reader, dBObjectProvider, schema);
        return unmarshalledIDs;
    }

    protected void readIDsImpl(UnmarshalledIDs unmarshalledIDs, Reader reader, DBObjectProvider dBObjectProvider, Schema schema) throws IOException, PartialParseUnsupportedException {
        HashSet<String> hashSet = new HashSet<String>();
        List<DBObject> list = this.readImpl(reader, dBObjectProvider, schema);
        if (list != null) {
            DatabaseDescriptor databaseDescriptor = dBObjectProvider.getDescriptor();
            for (DBObject dBObject : list) {
                this.getIDsAndTokens(dBObject, databaseDescriptor, unmarshalledIDs, hashSet);
            }
        }
        for (String string : hashSet) {
            unmarshalledIDs.addReferenceID(new ReferenceID("UNSPECIFIED_TYPE", (String)null, string));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void getIDsAndTokens(DBObject dBObject, DatabaseDescriptor databaseDescriptor, UnmarshalledIDs unmarshalledIDs, Set<String> set) {
        String string;
        unmarshalledIDs.addObjectID(dBObject.getID());
        for (DBObjectID dBObjectID : dBObject.getReferenceIDs()) {
            unmarshalledIDs.addReferenceID(dBObjectID);
        }
        PropertyCriteria propertyCriteria = new PropertyCriteria();
        Map<String, PropertyInfo> map = PropertyHelper.getPropertyInfos(dBObject.getClass(), null, propertyCriteria);
        HashSet<String> hashSet = new HashSet<String>();
        for (Map.Entry<String, PropertyInfo> entry : map.entrySet()) {
            PropertyInfo propertyInfo;
            string = entry.getValue().getDerivedSourceProperty();
            if (string == null || (propertyInfo = map.get(string)) == null || propertyInfo.getPropertyClass() != String.class) continue;
            hashSet.add(string);
        }
        for (String string2 : hashSet) {
            void var11_26;
            PlSqlSearch plSqlSearch;
            string = (String)dBObject.getProperty(string2);
            if (!ModelUtil.hasLength((String)string)) continue;
            PlSqlToken plSqlToken = PlSqlTokenizer.tokenize((String)string, (String[])new String[0]);
            Object object = null;
            if ("source".equals(string2) && dBObject instanceof PlSqlSourceObject && !(dBObject instanceof PlSqlSchemaObjectBody) && (plSqlSearch = new PlSqlSearch("[create [or replace]] ? ?.")).matches(plSqlToken)) {
                PlSqlToken plSqlToken2 = plSqlSearch.getEndToken();
                String string3 = plSqlToken2.getSource();
                PlSqlToken plSqlToken3 = (PlSqlToken)plSqlToken2.getNextCodeToken();
                object = (PlSqlToken)plSqlToken3.getTokenAt(string.length() - 1);
                if (!object.isCode()) {
                    object = (PlSqlToken)object.getPrevCodeToken();
                }
                if (object.matches(";")) {
                    object = (PlSqlToken)object.getPrevCodeToken();
                }
                object = object.matches(string3) ? (PlSqlToken)object.getPrevCodeToken() : null;
            }
            while (var11_26 != object && !var11_26.isEndMarker()) {
                if (var11_26.isCode(true)) {
                    set.add(databaseDescriptor.getInternalName(var11_26.getSource(), dBObject.getType()));
                }
                PlSqlToken plSqlToken4 = (PlSqlToken)var11_26.getNextCodeToken();
            }
        }
        for (DBObject dBObject2 : dBObject.getOwnedObjects()) {
            this.getIDsAndTokens(dBObject2, databaseDescriptor, unmarshalledIDs, set);
        }
    }

    private void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public class UnmarshalledIDs {
        private final List<DBObjectID> m_ids = new ArrayList<DBObjectID>();
        private final Set<DBObjectID> m_refs = new DBObjectIDSet(true);
        private final DBObjectProvider m_pro;

        private UnmarshalledIDs(DBObjectProvider dBObjectProvider) {
            this.m_pro = dBObjectProvider;
        }

        private void ensureProvider(DBObjectID dBObjectID) {
            if (this.m_pro != null) {
                this.m_pro.getObjectFactory().ensureProvider(dBObjectID);
            }
        }

        public void addObjectID(DBObjectID dBObjectID) {
            if (dBObjectID != null) {
                this.ensureProvider(dBObjectID);
                this.m_ids.add(dBObjectID);
            }
        }

        public void addReferenceID(DBObjectID dBObjectID) {
            if (dBObjectID != null) {
                this.ensureProvider(dBObjectID);
                this.m_refs.add(dBObjectID);
            }
        }

        public Collection<DBObjectID> getReferences() {
            return this.m_refs;
        }

        public List<DBObjectID> getObjectIDs() {
            return this.m_ids;
        }
    }
}

