/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.ArrayList;
import oracle.javatools.db.AbstractChildBuildableObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Index;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.property.Derived;
import oracle.javatools.db.property.Internal;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.PropertyKey;
import oracle.javatools.db.property.References;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.IndexObject;

public class OracleIndexPartitions
extends AbstractChildBuildableObject {
    @PropertyKey(value=OracleIndexPartitions.class, childOf={Index.class}, provider=OracleDatabase.class)
    @Nullable(value=Nullable.NullBehaviour.NULLABLE)
    public static final String KEY = "OracleIndexPartitions";
    public static final String TYPE = "INDEX PARTITION MODEL";

    public OracleIndexPartitions() {
    }

    public OracleIndexPartitions(PartitionType partitionType) {
        this.setPartitionType(partitionType);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Nullable(value=Nullable.NullBehaviour.NOT_NULLABLE)
    public PartitionType getPartitionType() {
        return (PartitionType)((Object)this.getProperty("partitionType"));
    }

    public IndexPartition[] getPartitions() {
        return this.getChildSupport("partitions").getChildArray(IndexPartition.class);
    }

    public DBObjectID[] getGlobalPartitionColumns() {
        return this.getChildSupport("globalPartitionColumns").getChildArray(DBObjectID.class);
    }

    @Deprecated
    public String[] getTablespaces() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DBObjectID dBObjectID : this.getHashQuantityTablespaceIds()) {
            Tablespace tablespace = null;
            try {
                tablespace = (Tablespace)dBObjectID.resolveID();
                if (tablespace == null) continue;
                arrayList.add(tablespace.getName());
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @References(value=Tablespace.class)
    public DBObjectID[] getHashQuantityTablespaceIds() {
        return this.getChildSupport("hashQuantityTablespaceIds").getChildArray(DBObjectID.class);
    }

    public Integer getGlobalHashQuantity() {
        return (Integer)this.getProperty("globalHashQuantity");
    }

    public void setPartitionType(PartitionType partitionType) {
        if (partitionType == PartitionType.DOMAIN) {
            partitionType = PartitionType.LOCAL_OTHER;
        }
        this.setProperty("partitionType", (Object)partitionType);
    }

    public void setGlobalPartitionColumns(DBObjectID[] dBObjectIDArray) {
        this.getChildSupport("globalPartitionColumns").setChildArray(dBObjectIDArray);
    }

    public void addGlobalPartitionColumn(DBObjectID dBObjectID) {
        if (dBObjectID != null) {
            this.getChildSupport("globalPartitionColumns").addChild(dBObjectID);
        }
    }

    public void removeGlobalPartitionColumn(DBObjectID dBObjectID) {
        this.getChildSupport("globalPartitionColumns").removeChild(dBObjectID);
    }

    public void setPartitions(IndexPartition[] indexPartitionArray) {
        this.getChildSupport("partitions").setChildArray(indexPartitionArray);
    }

    public void addPartition(IndexPartition indexPartition) {
        this.getChildSupport("partitions").addChild(indexPartition);
    }

    public void addPartition(int n, IndexPartition indexPartition) {
        this.getChildSupport("partitions").addChild(n, indexPartition);
    }

    public void removePartition(IndexPartition indexPartition) {
        this.getChildSupport("partitions").removeChild(indexPartition);
    }

    @Transient
    @Deprecated
    public void setTablespaces(String[] stringArray) {
        this.setHashQuantityTablespaceIds(new DBObjectID[0]);
        if (stringArray != null) {
            for (String string : stringArray) {
                this.addTablespace(string);
            }
        }
    }

    public void setHashQuantityTablespaceIds(DBObjectID[] dBObjectIDArray) {
        this.getChildSupport("hashQuantityTablespaceIds").setChildArray(dBObjectIDArray);
    }

    @Deprecated
    public void addTablespace(String string) {
        if (string != null) {
            ReferenceID referenceID = new ReferenceID("TABLESPACE", (Schema)null, string);
            this.setHashQuantityTablespaceIds(new DBObjectID[]{referenceID});
        }
    }

    public void setGlobalHashQuantity(Integer n) {
        this.setProperty("globalHashQuantity", n);
    }

    public static Column[] getValidGlobalPartitionColumns(Index index) {
        IndexObject indexObject;
        String string;
        ArrayList<Column> arrayList = new ArrayList<Column>();
        Table table = index.getTable();
        IndexObject[] indexObjectArray = index.getColumnExpressions();
        int n = indexObjectArray.length;
        for (int i = 0; i < n && table.getColumn(string = (indexObject = indexObjectArray[i]).getExpressionSource()) != null && !IndexObject.OrderType.DESC.equals((Object)indexObject.getOrderType()); ++i) {
            arrayList.add(table.getColumn(string));
        }
        return arrayList.toArray(new Column[arrayList.size()]);
    }

    public void setLocalTablePartitionModelID(DBObjectID dBObjectID) {
        this.setProperty("localTablePartitionModelID", dBObjectID);
    }

    @Derived(value="partitionType")
    @References(value=OracleTablePartitions.class, internal=true)
    @Internal
    public DBObjectID getLocalTablePartitionModelID() {
        return (DBObjectID)this.getProperty("localTablePartitionModelID");
    }

    public static enum PartitionType {
        GLOBAL_RANGE,
        GLOBAL_HASH,
        LOCAL_HASH,
        LOCAL_COMP,
        LOCAL_OTHER,
        DOMAIN,
        SUBPARTITION;

    }
}

