/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.util.function.Predicate;
import oracle.javatools.db.property.PropertyDefinition;
import oracle.javatools.db.property.PropertyInfo;

public final class PropertyCriteria
implements Predicate<PropertyInfo> {
    private Boolean m_derived;
    private Boolean m_deprecated = Boolean.FALSE;
    private Boolean m_internal = Boolean.FALSE;
    private boolean m_includeBean = true;
    private boolean m_includeExtra = true;
    private Predicate<PropertyInfo> m_predicate;

    public void setDerived(Boolean bl) {
        this.m_derived = bl;
    }

    public void setDeprecated(Boolean bl) {
        this.m_deprecated = bl;
    }

    public void setInternal(Boolean bl) {
        this.m_internal = bl;
    }

    public void setIncludeBean(boolean bl) {
        this.m_includeBean = bl;
    }

    boolean isIncludeBean() {
        return this.m_includeBean;
    }

    public void setIncludeExtra(boolean bl) {
        this.m_includeExtra = bl;
    }

    boolean isIncludeExtra() {
        return this.m_includeExtra;
    }

    public void addPredicate(Predicate<PropertyInfo> predicate) {
        this.m_predicate = this.m_predicate == null ? predicate : this.m_predicate.and(predicate);
    }

    @Override
    public boolean test(PropertyInfo propertyInfo) {
        boolean bl = propertyInfo instanceof PropertyDefinition;
        return (bl ? this.m_includeExtra : this.m_includeBean) && this.testImpl(propertyInfo);
    }

    boolean testImpl(PropertyInfo propertyInfo) {
        boolean bl = true;
        if (bl && this.m_derived != null) {
            boolean bl2 = bl = this.m_derived.booleanValue() == propertyInfo.isDerived();
        }
        if (bl && this.m_deprecated != null) {
            boolean bl3 = bl = this.m_deprecated.booleanValue() == propertyInfo.isDeprecated();
        }
        if (bl && this.m_internal != null) {
            boolean bl4 = bl = this.m_internal.booleanValue() == propertyInfo.isInternal();
        }
        if (bl && this.m_predicate != null) {
            bl = this.m_predicate.test(propertyInfo);
        }
        return bl;
    }

    public static PropertyCriteria createEmptyCriteria() {
        PropertyCriteria propertyCriteria = new PropertyCriteria();
        propertyCriteria.setDeprecated(null);
        propertyCriteria.setInternal(null);
        return propertyCriteria;
    }
}

