/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.DifferenceApplier;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.refactoring.UpdateProcessor;
import oracle.javatools.db.util.DBObjectIDMap;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;

public final class DBObjectTransaction {
    private final DBObjectProvider m_pro;
    private boolean m_replace;
    private boolean m_cascade;
    private boolean m_refactorUpdated;
    private Map<String, Object> m_parameters;
    private final Map<DBObjectID, Difference> m_creates;
    private final Map<DBObjectID, Difference> m_updates;
    private final Map<DBObjectID, Difference> m_deletes;
    private boolean m_processing;
    private List<UpdateProcessor> m_processors;
    private UpdateProcessor m_currentProcessor;
    private final List<Difference> m_pendingProcess;
    private final List<Difference> m_processed;
    private final Map<DBObjectID, Difference> m_originalDiffs;
    private DBException m_exception;
    private Difference m_currentDiff;

    public DBObjectTransaction(DBObjectProvider dBObjectProvider) {
        this.m_pro = dBObjectProvider;
        this.m_pendingProcess = new ArrayList<Difference>();
        this.m_processed = new ArrayList<Difference>();
        this.m_creates = this.newIDMap();
        this.m_updates = this.newIDMap();
        this.m_deletes = this.newIDMap();
        this.m_originalDiffs = this.newIDMap();
    }

    private Logger getLogger() {
        return DBLog.getLogger(this);
    }

    private Map<DBObjectID, Difference> newIDMap() {
        return new DBObjectIDMap<Difference>(true);
    }

    public boolean isReplace() {
        return this.m_replace;
    }

    public void setReplace(boolean bl) {
        this.m_replace = bl;
    }

    public boolean isCascade() {
        return this.m_cascade;
    }

    public void setCascade(boolean bl) {
        this.m_cascade = bl;
    }

    public void setRefactorUpdatedObject(boolean bl) {
        this.m_refactorUpdated = bl;
    }

    public void addParameter(Object object) {
        if (object != null) {
            if (this.m_parameters == null) {
                this.m_parameters = new HashMap<String, Object>();
            }
            this.m_parameters.put(object.getClass().getName(), object);
        }
    }

    public <T> T getParameter(Class<T> clazz) {
        return (T)(this.m_parameters == null ? null : this.m_parameters.get(clazz.getName()));
    }

    public DBObjectProvider getProvider() {
        return this.m_pro;
    }

    public void commit() throws DBException {
        this.m_pro.commitTransaction(this);
    }

    public void addException(DBException dBException) {
        if (this.m_exception == null) {
            this.m_exception = dBException;
        } else {
            this.m_exception.setNextException(dBException);
        }
    }

    private void checkException() throws DBException {
        if (this.m_exception != null) {
            throw this.m_exception;
        }
    }

    public boolean isCurrentObject(DBObjectID dBObjectID) {
        SystemObject systemObject;
        boolean bl = false;
        if (this.m_currentDiff != null && (systemObject = (SystemObject)this.m_currentDiff.getOriginalObject()) != null) {
            bl = ModelUtil.areEqual((Object)dBObjectID, (Object)systemObject.getID());
        }
        return bl;
    }

    public SystemObject getDiffUpdatedObject(Difference difference) {
        return this.getDiffUpdatedObject(difference, false);
    }

    private SystemObject getDiffUpdatedObject(Difference difference, boolean bl) {
        SystemObject systemObject = null;
        if (bl || difference.isFiltered()) {
            systemObject = this.getCopyOfOrigWithDiffApplied(difference);
        }
        if (systemObject == null) {
            systemObject = (SystemObject)difference.getUpdatedObject();
        }
        return systemObject;
    }

    private SystemObject getCopyOfOrigWithDiffApplied(Difference difference) {
        SystemObject systemObject = null;
        try {
            DifferenceApplier differenceApplier = new DifferenceApplier(this.m_pro);
            systemObject = differenceApplier.getCopyOfOrigWithDiffApplied(difference);
        }
        catch (Exception exception) {
            this.getLogger().log(DBLog.getExceptionLogLevel(), "Failed to create copy of original object", exception);
        }
        return systemObject;
    }

    public void includeListDifference(Difference difference) {
        if (!difference.isList()) {
            throw new IllegalStateException("listDiff must be a Difference of type LIST");
        }
        for (Difference difference2 : difference.getChildren()) {
            this.includeObjectDifference(difference2);
        }
    }

    public void includeUpdate(SystemObject systemObject) {
        Difference difference = this.findExistingUpdate(systemObject);
        SystemObject systemObject2 = null;
        if (difference == null) {
            try {
                DBObject dBObject;
                SystemObject systemObject3 = systemObject;
                DBObjectID dBObjectID = systemObject.getID();
                if (dBObjectID instanceof TemporaryObjectID && (dBObject = TemporaryObjectID.findOriginalObject((TemporaryObjectID)dBObjectID)) instanceof SystemObject) {
                    systemObject3 = (SystemObject)dBObject;
                }
                systemObject2 = DBUtil.getProviderDefinition(systemObject3, this.getProvider());
            }
            catch (DBException dBException) {
                this.getLogger().warning("Couldn't get object definition: " + dBException.getMessage());
            }
        } else {
            systemObject2 = (SystemObject)difference.getOriginalObject();
        }
        this.includeUpdate(systemObject2, systemObject);
    }

    public void includeUpdate(SystemObject systemObject, SystemObject systemObject2) {
        Object object;
        if (systemObject2 == null && (object = systemObject.getID()) instanceof TemporaryObjectID) {
            systemObject = (SystemObject)TemporaryObjectID.findOriginalObject((TemporaryObjectID)object);
        }
        object = this.difference(systemObject, systemObject2);
        this.includeObjectDifference((Difference)object);
    }

    public Difference difference(SystemObject systemObject, SystemObject systemObject2) {
        return this.m_pro.getDiffEngine().difference(systemObject, systemObject2);
    }

    public Difference findExistingUpdate(Difference difference) {
        DBObjectID dBObjectID;
        SystemObject systemObject;
        Difference difference2 = null;
        if (difference != null && (systemObject = (SystemObject)difference.getOriginalObject()) != null && (dBObjectID = systemObject.getID()) != null) {
            difference2 = this.m_updates.get(dBObjectID);
        }
        return difference2;
    }

    public void includeObjectDifference(Difference difference) {
        SystemObject systemObject = (SystemObject)difference.getOriginalObject();
        Difference difference2 = null;
        boolean bl = false;
        DBObjectID dBObjectID = this.getMapKey(difference);
        if (difference.isSame() && !this.isReplace()) {
            if (systemObject != null && this.findExistingUpdate(systemObject) != null) {
                this.getLogger().warning("Overridding update included for " + systemObject + " but there are no differences - ignoring.");
            }
        } else if (systemObject == null) {
            SystemObject systemObject2 = (SystemObject)difference.getUpdatedObject();
            difference2 = this.m_creates.put(dBObjectID, difference);
            bl = true;
        } else if (difference.getUpdatedObject() == null) {
            boolean bl2 = this.m_deletes.containsKey(dBObjectID);
            this.m_deletes.put(dBObjectID, difference);
            if (!bl2) {
                if (this.isCurrentObject(dBObjectID)) {
                    this.getLogger().severe("Deleting the current object is not allowed");
                } else {
                    bl = true;
                    if (this.m_updates.remove(dBObjectID) != null) {
                        this.getLogger().fine("Deleting existing update for " + dBObjectID);
                    }
                }
            }
        } else {
            bl = true;
            difference2 = this.m_updates.put(dBObjectID, difference);
            if (difference2 != null && difference2.getUpdatedObject() != difference.getUpdatedObject() && this.m_processing) {
                bl = false;
                SystemObject systemObject3 = this.getDiffUpdatedObject(difference2, true);
                IdentityHashMap<DBObject, DBObject> identityHashMap = new IdentityHashMap<DBObject, DBObject>();
                IdentityHashMap<DBObject, DBObject> identityHashMap2 = new IdentityHashMap<DBObject, DBObject>();
                this.pretendIsOriginal(systemObject3, identityHashMap, identityHashMap2);
                SystemObject systemObject4 = this.getDiffUpdatedObject(difference);
                this.resetOriginalObjects(systemObject4, identityHashMap);
                Difference difference3 = this.difference(systemObject3, systemObject4);
                this.resetOriginalObjects(systemObject4, identityHashMap2);
                if (!difference3.isSame()) {
                    this.processObjectDifference(difference, difference3);
                }
            }
        }
        if (difference2 != null) {
            if (difference2 == this.m_currentDiff) {
                this.m_currentDiff = difference;
                bl = false;
            } else {
                this.m_processed.remove(difference2);
            }
        }
        if (bl) {
            if (this.m_processing) {
                this.processObjectDifference(difference, null);
            } else {
                this.m_pendingProcess.add(difference);
                this.m_originalDiffs.put(dBObjectID, difference);
            }
        }
    }

    private void resetOriginalObjects(DBObject dBObject, Map<DBObject, DBObject> map) {
        DBObject object;
        DBObjectID dBObjectID = dBObject.getID();
        if (dBObjectID instanceof TemporaryObjectID && (object = map.get(((TemporaryObjectID)dBObjectID).getOriginalObject())) != null) {
            dBObject.setID(TemporaryObjectID.createID(dBObject, object));
        }
        for (DBObject dBObject2 : dBObject.getOwnedObjects()) {
            this.resetOriginalObjects(dBObject2, map);
        }
    }

    public boolean containsUpdate(String string, String string2, String string3) {
        NameBasedID nameBasedID = new NameBasedID(string, string2, string3);
        return this.m_creates.containsKey(nameBasedID) || this.m_updates.containsKey(nameBasedID);
    }

    private List<UpdateProcessor> getUpdateProcessors() {
        if (this.m_processors == null) {
            this.m_processors = this.getProvider().getDescriptor().getUpdateProcessors();
        }
        return this.m_processors;
    }

    public void setUpdateProcessors(List<UpdateProcessor> list) {
        this.m_processors = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processObjectDifference(Difference difference, Difference difference2) {
        if (!this.m_processing) throw new IllegalStateException("Cannot process a diff when we're not processing");
        UpdateProcessor updateProcessor = this.m_currentProcessor;
        Difference difference3 = this.m_currentDiff;
        DBObjectID dBObjectID = difference3 == null ? null : this.getMapKey(difference3);
        DBObjectID dBObjectID2 = this.getMapKey(difference);
        boolean bl = dBObjectID2.equals(dBObjectID, true);
        try {
            this.m_currentDiff = difference;
            Object object = this.getUpdateProcessors().iterator();
            while (object.hasNext()) {
                UpdateProcessor updateProcessor2;
                this.m_currentProcessor = updateProcessor2 = object.next();
                if (this.m_currentDiff == null) continue;
                if (difference2 == null) {
                    updateProcessor2.processUpdate(this, this.m_currentDiff);
                    continue;
                }
                if (updateProcessor2.onlyProcessesPrimaryUpdates()) continue;
                updateProcessor2.processUpdate(this, difference2);
            }
            if (this.m_currentDiff == null) return;
            object = null;
            for (int i = 0; i < this.m_processed.size(); ++i) {
                Difference difference4 = this.m_processed.get(i);
                if (!this.getMapKey(difference4).equals(dBObjectID2)) continue;
                object = i;
                break;
            }
            if (object == null) {
                this.m_processed.add(this.m_currentDiff);
                return;
            } else {
                this.m_processed.set((Integer)object, this.m_currentDiff);
            }
            return;
        }
        catch (DBException dBException) {
            this.addException(dBException);
            return;
        }
        finally {
            this.m_currentDiff = bl ? null : difference3;
            this.m_currentProcessor = updateProcessor;
        }
    }

    private void pretendIsOriginal(DBObject dBObject, Map<DBObject, DBObject> map, Map<DBObject, DBObject> map2) {
        DBObjectID dBObjectID;
        DBObject dBObject2 = TemporaryObjectID.findOriginalObject(dBObject);
        DBObjectID dBObjectID2 = dBObjectID = dBObject2 == null ? null : dBObject2.getID();
        if (dBObjectID != null) {
            String object;
            if (dBObjectID instanceof NameBasedID && ModelUtil.areDifferent((Object)(object = dBObject.getName()), (Object)((NameBasedID)dBObjectID).getName())) {
                NameBasedID nameBasedID = (NameBasedID)dBObjectID.copyTo(null);
                nameBasedID.setName(object);
                map.put(dBObject2, dBObject);
                map2.put(dBObject, dBObject2);
            }
            dBObject.setID(dBObjectID);
        }
        for (DBObject dBObject3 : dBObject.getOwnedObjects()) {
            this.pretendIsOriginal(dBObject3, map, map2);
        }
    }

    public void removeUpdate(Difference difference) {
        DBObjectID dBObjectID = this.getMapKey(difference);
        this.removeFromProcess(this.m_creates.remove(dBObjectID));
        this.removeFromProcess(this.m_deletes.remove(dBObjectID));
        this.removeFromProcess(this.m_updates.remove(dBObjectID));
        this.removeFromProcess(this.m_originalDiffs.remove(dBObjectID));
    }

    private void removeFromProcess(Difference difference) {
        if (difference != null) {
            this.m_pendingProcess.remove(difference);
            this.m_processed.remove(difference);
            if (difference == this.m_currentDiff) {
                this.m_currentDiff = null;
            }
        }
    }

    public Collection<DBObjectID> getDeleteIDs() {
        return Collections.unmodifiableCollection(this.m_deletes.keySet());
    }

    public Collection<DBObjectID> getCreateIDs() {
        return Collections.unmodifiableCollection(this.m_creates.keySet());
    }

    public Collection<DBObjectID> getUpdateIDs() {
        return Collections.unmodifiableCollection(this.m_updates.keySet());
    }

    public Difference findExistingUpdate(SystemObject systemObject) {
        DBObjectID dBObjectID;
        DBObjectID dBObjectID2 = dBObjectID = systemObject == null ? null : systemObject.getID();
        if (dBObjectID instanceof TemporaryObjectID) {
            dBObjectID = TemporaryObjectID.findOriginalID((TemporaryObjectID)dBObjectID);
        }
        return this.m_updates.get(dBObjectID);
    }

    public SystemObject getCopyForUpdate(SystemObject systemObject) {
        SystemObject systemObject2;
        if (systemObject == null) {
            systemObject2 = null;
        } else {
            Difference difference = this.findExistingUpdate(systemObject);
            if (difference == null) {
                systemObject2 = DBUtil.makeTemporaryCopy(systemObject);
            } else {
                boolean bl = this.isTempCopy(difference);
                systemObject2 = this.getDiffUpdatedObject(difference, bl);
            }
        }
        return systemObject2;
    }

    private boolean isTempCopy(Difference difference) {
        SystemObject systemObject = (SystemObject)difference.getOriginalObject();
        SystemObject systemObject2 = (SystemObject)difference.getUpdatedObject();
        DBObjectID dBObjectID = systemObject2.getID();
        return dBObjectID instanceof TemporaryObjectID && TemporaryObjectID.findOriginalObject((TemporaryObjectID)dBObjectID) == systemObject;
    }

    private DBObjectID getMapKey(Difference difference) {
        SystemObject systemObject = (SystemObject)difference.getOriginalObject();
        DBObjectID dBObjectID = systemObject == null ? new NameBasedID((DBObject)((SystemObject)difference.getUpdatedObject()), (AbstractDBObjectProvider)this.getProvider()) : systemObject.getID();
        return dBObjectID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Difference getTransactionDifference() throws DBException {
        this.checkException();
        try {
            this.m_processing = true;
            ArrayList<Difference> arrayList = new ArrayList<Difference>(this.m_pendingProcess);
            this.m_pendingProcess.clear();
            for (Difference systemObjectArray2 : arrayList) {
                this.processObjectDifference(systemObjectArray2, null);
            }
        }
        finally {
            this.m_processing = false;
        }
        this.checkException();
        int n = this.m_processed.size();
        SystemObject[] systemObjectArray3 = new SystemObject[n];
        SystemObject[] systemObjectArray = new SystemObject[n];
        ResultSet resultSet = new ResultSet(null, systemObjectArray3, (Object)systemObjectArray, null, "LIST");
        boolean bl = true;
        int n2 = 0;
        for (Difference difference : this.m_processed) {
            SystemObject systemObject;
            Difference difference2;
            Copyable copyable;
            ResultSet resultSet2;
            systemObjectArray3[n2] = (SystemObject)difference.getOriginalObject();
            if (difference instanceof ResultSet) {
                resultSet2 = (ResultSet)difference;
            } else {
                copyable = this.getDiffUpdatedObject(difference);
                resultSet2 = (ResultSet)this.difference(systemObjectArray3[n2], (SystemObject)copyable);
            }
            systemObjectArray[n2] = (SystemObject)resultSet2.getUpdatedObject();
            resultSet.addToList(resultSet2);
            bl &= resultSet2.isSame();
            if (this.m_refactorUpdated && (difference2 = this.m_originalDiffs.get(copyable = this.getMapKey(resultSet2))) != null && (systemObject = (SystemObject)difference2.getUpdatedObject()) != null && systemObject != systemObjectArray[n2]) {
                systemObjectArray[n2].copyTo((DBObject)systemObject, false);
            }
            ++n2;
        }
        resultSet.setSame(bl);
        return resultSet;
    }
}

