/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.core.plugin;

import oracle.diagram.core.plugin.Plugin;
import oracle.diagram.core.plugin.PluginManager;

public abstract class RefCountedPlugin
implements Plugin {
    private int _refCount = 0;

    protected RefCountedPlugin() {
    }

    public final void attach(PluginManager pluginManager, Class pluginType) {
        ++this._refCount;
        this.attachImpl(pluginManager, pluginType);
    }

    public final void detach(PluginManager pluginManager, Class pluginType) {
        this.detachImpl(pluginManager, pluginType);
        --this._refCount;
        if (this._refCount == 0) {
            this.cleanup();
        } else if (this._refCount < 0) {
            throw new IllegalStateException("RefCountedPlugin with refCount < 0");
        }
    }

    protected void attachImpl(PluginManager pluginManager, Class pluginType) {
    }

    protected void detachImpl(PluginManager pluginManager, Class pluginType) {
    }

    protected abstract void cleanup();
}

