/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.accessibility;

import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import ilog.views.util.collections.IlvSelectiveIterator;
import ilog.views.util.collections.IlvUnaryPredicate;
import java.util.Iterator;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleRole;
import oracle.diagram.core.util.AccessibilityPredicate;
import oracle.diagram.framework.accessibility.AccessibleManagedGraphic;
import oracle.diagram.framework.accessibility.AccessibleManagerView;
import oracle.diagram.framework.manager.VisibleObjectsIterator;

public class AccessibleManager
extends AccessibleManagedGraphic {
    public AccessibleManager(AccessibleManagerView view, IlvManager manager) {
        super(view, (IlvGraphic)manager);
    }

    protected final IlvManager getManager() {
        return (IlvManager)this.getGraphic();
    }

    @Override
    public AccessibleRole getAccessibleRole() {
        return AccessibleRole.LIST;
    }

    @Override
    public int getAccessibleChildrenCount() {
        IlvManager mgr = this.getManager();
        if (mgr.isCollapsed()) {
            return 0;
        }
        int i = 0;
        IlvSelectiveIterator iterator = new IlvSelectiveIterator((Iterator)new VisibleObjectsIterator(mgr), (IlvUnaryPredicate)new AccessibilityPredicate());
        while (iterator.hasNext()) {
            ++i;
        }
        return i;
    }

    @Override
    public Accessible getAccessibleChild(int indexInParent) {
        IlvSelectiveIterator iterator = new IlvSelectiveIterator((Iterator)new VisibleObjectsIterator(this.getManager()), (IlvUnaryPredicate)new AccessibilityPredicate());
        while (iterator.hasNext()) {
            IlvGraphic child = (IlvGraphic)iterator.next();
            if (indexInParent-- != 0) continue;
            return this.getView().getAccessibleGraphic(child);
        }
        return null;
    }
}

