/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.editor;

import ilog.views.IlvManagerView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultFocusTraversalPolicy;
import java.util.EventObject;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.context.DiagramView;
import oracle.diagram.core.context.IdeContextPlugin;
import oracle.diagram.core.editor.Diagram;
import oracle.diagram.core.editor.ScrollManagerView;
import oracle.diagram.core.interaction.SelectionChangeNotificationPlugin;
import oracle.diagram.core.plugin.AbstractPlugin;
import oracle.diagram.core.plugin.PluginUtil;
import oracle.diagram.framework.controller.ControllerChain;
import oracle.diagram.framework.inspector.InspectorPlugin;
import oracle.diagram.framework.menu.DefaultDiagramMainMenuPlugin;
import oracle.diagram.framework.menu.DiagramContextMenuPlugin;
import oracle.diagram.framework.menu.DiagramMainMenuPlugin;
import oracle.diagram.framework.menu.ViewDiagramContextMenuPlugin;
import oracle.diagram.framework.selection.DiagramIdeSelectionPlugin;
import oracle.diagram.framework.toolbar.ToolbarPlugin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.OpenAbortedException;
import oracle.ide.help.HelpInfo;
import oracle.ide.inspector.Inspectable;
import oracle.ide.inspector.InspectableFactory;
import oracle.ide.inspector.InspectorFactory;
import oracle.ide.model.Element;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;

public class IdeDiagramView
extends View
implements DiagramView {
    private final Diagram _diagram;
    private Component _gui = null;
    private final Controller _controller;
    private final ViewSelectionHack _vsh = new ViewSelectionHack();

    public IdeDiagramView(Diagram diagram) {
        this(diagram, null);
    }

    public IdeDiagramView(Diagram diagram, View owner) {
        this._diagram = diagram;
        if (owner != null) {
            this.setOwner(owner);
        }
        this._controller = new HostController(super.getController());
    }

    public final Diagram getDiagram() {
        return this._diagram;
    }

    protected void setDiagramContext(Diagram diagram, Context srcContext, Context viewContext) {
        Context diagramContext = new Context(viewContext);
        diagram.initContext(srcContext, diagramContext);
        diagram.getDiagramContext().addPlugin(IdeContextPlugin.class, new MyIdeContextPlugin(diagramContext));
    }

    public Component getGUI() {
        if (this._gui == null) {
            JPanel c = new JPanel();
            c.setLayout(new BorderLayout());
            ToolbarPlugin plugin = this.getDiagram().getDiagramContext().getPlugin(ToolbarPlugin.class);
            if (plugin != null) {
                Toolbar tb = plugin.getToolbar();
                if (tb == null) {
                    plugin.createToolbar(this);
                    tb = plugin.getToolbar();
                }
                c.add((Component)tb, "North");
            }
            c.add((Component)new ScrollManagerView(this.getDiagram().getDiagramContext().getManagerView()), "Center");
            this._gui = c;
            c.setFocusTraversalPolicy(new DefaultFocusTraversalPolicy(){

                @Override
                public Component getDefaultComponent(Container container) {
                    return IdeDiagramView.this.getDiagram().getDiagramContext().getManagerView();
                }
            });
            c.setFocusTraversalPolicyProvider(true);
            Ide.getMainWindow().registerView((View)this);
        }
        return this._gui;
    }

    protected boolean canMorphContext() {
        Diagram diagram = this.getDiagram();
        if (diagram != null) {
            return diagram.canMorphContext();
        }
        return true;
    }

    public final synchronized void setContext(Context context) {
        if (this.getContext() != null && !this.canMorphContext()) {
            return;
        }
        Context editorContext = context == null ? Context.newIdeContext((View)this) : (context.getProperty("oracle.diagram.framework.IdeDiagramEditor.initialised") == this ? new Context(context) : new Context((View)this, context.getWorkspace(), context.getProject(), context.getNode()));
        editorContext.setProperty("oracle.diagram.framework.IdeDiagramEditor.initialised", (Object)this);
        this.initContext(context, editorContext);
        this.setDiagramContext(this.getDiagram(), context, editorContext);
    }

    protected void initContext(Context context, Context viewContext) {
        viewContext.setProperty("oracle.diagram.inspector.ActiveInspectedView", (Object)this);
    }

    public synchronized Context getContext(EventObject event) {
        Context context;
        Diagram diagram = this.getDiagram();
        if (diagram != null && (context = diagram.getDiagramContext().getPlugin(IdeContextPlugin.class).getContext()) != null) {
            context.setEvent(event);
            context.setSelection(this.getSelection());
            return context;
        }
        return super.getContext(event);
    }

    @Override
    public IlvManagerView getActiveManagerView() {
        return this.getDiagram().getDiagramContext().getManagerView();
    }

    public void activate() {
        super.activate();
        this.getDiagram().activate();
    }

    public void deactivate() {
        this.getDiagram().deactivate();
        super.deactivate();
    }

    public Controller getController() {
        return this._controller;
    }

    public void open() throws OpenAbortedException {
        this.installViewPlugins(this.getDiagram());
        this.getDiagram().open();
    }

    protected Element[] getSelectionFromUI() {
        DiagramIdeSelectionPlugin esp = this.getDiagram().getDiagramContext().getPlugin(DiagramIdeSelectionPlugin.class);
        if (esp != null) {
            esp.fetchSelectionFromUI();
            return esp.getSelection();
        }
        return super.getSelectionFromUI();
    }

    public Toolbar getToolbar() {
        ToolbarPlugin plugin = this.getDiagram().getDiagramContext().getPlugin(ToolbarPlugin.class);
        if (plugin != null) {
            Toolbar tb = plugin.getToolbar();
            return tb;
        }
        return super.getToolbar();
    }

    public void loadLayout(PropertyAccess p) {
        super.loadLayout(p);
    }

    public void saveLayout(PropertyAccess p) {
        super.saveLayout(p);
    }

    public HelpInfo getHelpInfo() {
        return this.getDiagram().getHelpInfo();
    }

    protected void installViewPlugins(Diagram diagram) {
        DiagramContext dc = diagram.getDiagramContext();
        dc.addPlugin(DiagramMainMenuPlugin.class, DefaultDiagramMainMenuPlugin.getInstance());
        dc.addPlugin(DiagramContextMenuPlugin.class, new ViewDiagramContextMenuPlugin(dc, this));
        dc.addPlugin(SelectionChangeNotificationPlugin.class, new SelectionPlugin());
    }

    static {
        InspectorFactory.getInstance().addInspectableFactory(new InspectableFactory(){

            public Inspectable getInspectable(Context originalContext) {
                View view = (View)originalContext.getProperty("oracle.diagram.inspector.ActiveInspectedView");
                if (view instanceof IdeDiagramView) {
                    IdeDiagramView editor = (IdeDiagramView)view;
                    InspectorPlugin ip = PluginUtil.getPlugin(editor.getActiveManagerView(), InspectorPlugin.class);
                    DiagramIdeSelectionPlugin isp = PluginUtil.getPlugin(editor.getActiveManagerView(), DiagramIdeSelectionPlugin.class);
                    if (ip != null && isp != null) {
                        Context context = new Context(originalContext);
                        Element[] inspectorSelection = isp.getInspectorSelection();
                        if (inspectorSelection != null && inspectorSelection.length != 0) {
                            context.setProperty("oracle.diagram.inspector.InspectorSelectionProperty", (Object)inspectorSelection);
                            originalContext.setProperty("oracle.diagram.inspector.InspectorSelectionProperty", (Object)inspectorSelection);
                        }
                        return ip.getInspectable(context);
                    }
                }
                return null;
            }
        });
    }

    private class HostController
    extends ControllerChain {
        public HostController(Controller ... delegates) {
            super(delegates);
        }

        @Override
        public boolean handleEvent(IdeAction action, Context context) {
            if (!IdeDiagramView.this.getDiagram().getController().handleEvent(action, context)) {
                return super.handleEvent(action, context);
            }
            return true;
        }

        @Override
        public boolean update(IdeAction action, Context context) {
            if (!IdeDiagramView.this.getDiagram().getController().update(action, context)) {
                return super.update(action, context);
            }
            return true;
        }
    }

    private static class ViewSelectionHack
    implements ViewSelectionListener {
        private boolean m_triggered = false;

        private ViewSelectionHack() {
        }

        public void viewSelectionChanged(ViewSelectionEvent e) {
            this.m_triggered = true;
        }

        public void reset() {
            this.m_triggered = false;
        }

        public boolean isTriggered() {
            return this.m_triggered;
        }
    }

    private class SelectionPlugin
    extends AbstractPlugin
    implements SelectionChangeNotificationPlugin {
        private int _disabled = 0;

        private SelectionPlugin() {
        }

        @Override
        public void selectionChanged(DiagramContext context) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ViewSelectionHack vsh = new ViewSelectionHack();
                        IdeDiagramView.this.addViewSelectionListener(vsh);
                        try {
                            vsh.reset();
                            IdeDiagramView.this.updateSelection();
                        }
                        finally {
                            IdeDiagramView.this.removeViewSelectionListener(vsh);
                            if (!vsh.isTriggered()) {
                                IdeDiagramView.this.fireViewSelectionChanged(new ViewSelectionEvent((View)IdeDiagramView.this));
                            }
                        }
                    }
                });
            } else {
                IdeDiagramView.this.addViewSelectionListener(IdeDiagramView.this._vsh);
                try {
                    IdeDiagramView.this._vsh.reset();
                    IdeDiagramView.this.updateSelection();
                }
                finally {
                    IdeDiagramView.this.removeViewSelectionListener(IdeDiagramView.this._vsh);
                    if (!IdeDiagramView.this._vsh.isTriggered()) {
                        IdeDiagramView.this.fireViewSelectionChanged(new ViewSelectionEvent((View)IdeDiagramView.this));
                    }
                }
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            if (!enabled) {
                ++this._disabled;
            } else if (this._disabled > 0) {
                --this._disabled;
            } else {
                throw new IllegalStateException("error: Mismatch between setEnabled(true) and setEnabled(false) calls");
            }
        }

        @Override
        public boolean isEnabled() {
            return this._disabled == 0;
        }
    }

    private class MyIdeContextPlugin
    extends AbstractPlugin
    implements IdeContextPlugin {
        private final Context _context;

        public MyIdeContextPlugin(Context context) {
            this._context = context;
        }

        @Override
        public Context getContext() {
            return this._context;
        }
    }
}

