/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.interaction;

import ilog.views.IlvGraphic;
import ilog.views.IlvLabelInterface;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyListener;
import javax.swing.JComboBox;
import oracle.diagram.framework.interaction.ComponentInPlaceEditor;
import oracle.diagram.framework.interaction.EditInteractor;
import oracle.diagram.framework.interaction.InPlaceEditContext;

public abstract class EnumeratedListInPlaceEditor
extends ComponentInPlaceEditor {
    private ComponentInPlaceEditor.EditingInputVerifier _inputVerifier;
    private CommitListener _commitListener = new CommitListener();
    private final KeyListener _keyListener = new ComponentInPlaceEditor.MyKeyListener();

    public EnumeratedListInPlaceEditor(EditInteractor editInteractor, InPlaceEditContext initialContext) {
        super(editInteractor, initialContext);
    }

    private final JComboBox getCombo() {
        return (JComboBox)this.getComponent();
    }

    protected void recalculateDimensions() {
        IlvTransformer transformer = this.getDrawingTransformer();
        IlvRect r = this.getLabelBBox(this.getEditedObject(), transformer);
        r.x -= 3.0f;
        r.y += -5.0f;
        Dimension d = this.getCombo().getPreferredSize();
        r.width = Math.max(r.width, (float)d.width);
        r.height = Math.max(r.height, (float)d.height);
        this.setComponentBounds(Math.round(r.x), Math.round(r.y), (int)Math.ceil(r.width), (int)Math.ceil(r.height));
    }

    @Override
    protected void cleanUpComponent() {
        if (this.getCombo() != null && this.getManagerView() != null) {
            this._inputVerifier.setEnabled(false);
            this._inputVerifier = null;
            this.getCombo().setInputVerifier(null);
            this.getCombo().removeKeyListener(this._keyListener);
            this.getCombo().removeActionListener(this._commitListener);
        }
    }

    @Override
    public void editImpl(Font font) {
        this._inputVerifier = new ComponentInPlaceEditor.EditingInputVerifier();
        InPlaceEditContext context = this.getContext();
        final JComboBox<Object> combo = new JComboBox<Object>(this.getDroplistOptions(context, this.getEditedObject()));
        this.setComponent(combo);
        combo.setName(this.getComboBoxName(this.getEditedObject()));
        String label = ((IlvLabelInterface)this.getEditedObject()).getLabel();
        combo.setVisible(false);
        combo.setSelectedItem(label);
        combo.setFont(font);
        this.getManagerView().add((Component)this.getCombo());
        this.recalculateDimensions();
        combo.addActionListener(this._commitListener);
        combo.setInputVerifier(this._inputVerifier);
        combo.setVerifyInputWhenFocusTarget(false);
        combo.addKeyListener(this._keyListener);
        combo.setVisible(true);
        combo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                combo.showPopup();
            }
        });
        combo.requestFocusInWindow();
    }

    @Override
    protected Rectangle getEditComponentBounds() {
        return null;
    }

    @Override
    protected boolean setObjectLabel(IlvGraphic obj, String str) {
        this.getCombo().setSelectedItem(str);
        return true;
    }

    @Override
    protected void setObjectLabelWithUndo(IlvGraphic obj, String label) {
        EditInteractor.Status status = this.setObjectLabel(obj, label) ? EditInteractor.Status.COMMIT : EditInteractor.Status.ABORT;
        this.getEditInteractor().setExitStatus(status);
    }

    @Override
    protected final void revertImpl() {
    }

    @Override
    protected Object getComponentValue() {
        return this.getCombo().getSelectedItem();
    }

    protected abstract Object[] getDroplistOptions(InPlaceEditContext var1, IlvGraphic var2);

    protected abstract String getComboBoxName(IlvGraphic var1);

    private final class CommitListener
    implements ActionListener {
        private CommitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            EnumeratedListInPlaceEditor.this.commit(0);
        }
    }
}

