/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.preference;

import java.awt.Color;
import java.awt.Font;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.PropertyGroup;
import oracle.diagram.framework.preference.FactoryDefaultsPreferenceStore;
import oracle.diagram.framework.preference.PreferenceDefinition;
import oracle.diagram.framework.preference.PreferenceStore;
import oracle.diagram.framework.preference.ValueMarshaller;
import oracle.diagram.framework.util.FontUtil;
import oracle.ide.net.URLFileSystem;

public final class PreferenceUtil {
    private static final String NLS_ERROR_PREFIX = "!NLS:";
    private static final String NAME_KEY = ".name.text";
    private static final String DESCRIPTION_KEY = ".description.text";
    private static final String HELPID_KEY = ".helpId";
    public static final ValueMarshaller DEFAULT_MARSHALLER = new StandardValueMarshaller();

    private PreferenceUtil() {
    }

    public static PreferenceDefinition[] addPreferenceDefinitions(PreferenceDefinition[] basePreferences, PreferenceDefinition ... newPreferences) {
        LinkedHashMap<PreferenceDefinition, PreferenceDefinition> preferences = new LinkedHashMap<PreferenceDefinition, PreferenceDefinition>();
        for (PreferenceDefinition preference : basePreferences) {
            preferences.put(preference.getRootDefinition(), preference);
        }
        for (PreferenceDefinition preference : newPreferences) {
            preferences.put(preference.getRootDefinition(), preference);
        }
        Collection values = preferences.values();
        return values.toArray(new PreferenceDefinition[values.size()]);
    }

    public static PreferenceDefinition[] removePreferenceDefinitions(PreferenceDefinition[] basePreferences, PreferenceDefinition ... unwantedPreferences) {
        HashSet<PreferenceDefinition> preferences = new HashSet<PreferenceDefinition>();
        for (PreferenceDefinition preference : unwantedPreferences) {
            preferences.add(preference.getRootDefinition());
        }
        ArrayList<PreferenceDefinition> result = new ArrayList<PreferenceDefinition>(basePreferences.length);
        for (PreferenceDefinition preference : basePreferences) {
            if (preferences.contains(preference.getRootDefinition())) continue;
            result.add(preference);
        }
        return result.toArray(new PreferenceDefinition[result.size()]);
    }

    public static void initializePreferenceStoreFromDefaults(PreferenceDefinition[] preferences, PreferenceStore store) {
        PreferenceUtil.initializePreferenceStoreFromDefaults(preferences, store, true);
    }

    public static void initializePreferenceStoreFromDefaults(PreferenceDefinition[] preferences, PreferenceStore store, boolean overwrite) {
        PreferenceUtil.copyPreferences(preferences, new FactoryDefaultsPreferenceStore(preferences), store, overwrite);
    }

    public static void copyPreferences(PreferenceDefinition[] preferences, PreferenceStore src, PreferenceStore dst) {
        PreferenceUtil.copyPreferences(preferences, src, dst, true);
    }

    public static void copyPreferences(PreferenceDefinition[] preferences, PreferenceStore src, PreferenceStore dst, boolean overwrite) {
        PreferenceDefinition[] validPrefs = new PreferenceDefinition[preferences.length];
        int validCount = 0;
        for (PreferenceDefinition pd : preferences) {
            if (!src.hasPreferenceValue(pd)) continue;
            validPrefs[validCount++] = pd;
        }
        preferences = new PreferenceDefinition[validCount];
        System.arraycopy(validPrefs, 0, preferences, 0, validCount);
        if (overwrite) {
            Object[] values = new Object[preferences.length];
            for (int i = 0; i < preferences.length; ++i) {
                values[i] = src.getPreferenceValue(preferences[i]);
            }
            dst.setPreferenceValues(preferences, values);
        } else {
            ArrayList<PreferenceDefinition> prefs = new ArrayList<PreferenceDefinition>(preferences.length);
            ArrayList<Object> values = new ArrayList<Object>(preferences.length);
            for (PreferenceDefinition pd : preferences) {
                if (dst.hasPreferenceValue(pd)) continue;
                prefs.add(pd);
                values.add(src.getPreferenceValue(pd));
            }
            dst.setPreferenceValues(prefs.toArray(new PreferenceDefinition[prefs.size()]), values.toArray(new Object[values.size()]));
        }
    }

    public static <T extends PropertyEditorFactory> PreferenceDefinition createPreferenceDefinition(String storageKey, ResourceBundle resBundle, String resBaseKey, PropertyGroup category, Class<T> propertyEditorFactoryClass, Object factoryDefaultValue, Class valueType) {
        return PreferenceUtil.createPreferenceDefinition(storageKey, resBundle, resBaseKey, category, propertyEditorFactoryClass, factoryDefaultValue, valueType, DEFAULT_MARSHALLER);
    }

    public static <T extends PropertyEditorFactory> PreferenceDefinition createPreferenceDefinition(String storageKey, ResourceBundle resBundle, String resBaseKey, PropertyGroup category, Class<T> propertyEditorFactoryClass, Object factoryDefaultValue, Class valueType, ValueMarshaller marshaller) {
        return new LazyPreferenceDefinition(null, storageKey, resBundle, resBaseKey, category, propertyEditorFactoryClass, factoryDefaultValue, valueType, marshaller);
    }

    public static PreferenceDefinition createPreferenceDefinitionAs(PreferenceDefinition base, Object factoryDefaultValue) {
        return new ProxyPreferenceDefinition(base, factoryDefaultValue);
    }

    public static PreferenceDefinition createPreferenceDefinitionAs(final PreferenceDefinition base, ResourceBundle resBundle, String resBaseKey, Object factoryDefaultValue) {
        return new LazyPreferenceDefinition(base.getId(), base.getStorageKey(), resBundle, resBaseKey, base.getPropertyGroup(), base.getPropertyEditorFactoryClass(), factoryDefaultValue, base.getType(), base.getValueMarshaller()){

            @Override
            public PreferenceDefinition getRootDefinition() {
                return base.getRootDefinition();
            }
        };
    }

    public static void mergeMaps(Map src, Map target) {
        for (Object srcKey : src.keySet()) {
            if (!target.containsKey(srcKey)) {
                target.put(srcKey, src.get(srcKey));
                continue;
            }
            Object targetValue = target.get(srcKey);
            if (!(targetValue instanceof Map)) continue;
            PreferenceUtil.mergeMaps((Map)src.get(srcKey), (Map)targetValue);
        }
    }

    private static class StandardValueMarshaller
    implements ValueMarshaller {
        private StandardValueMarshaller() {
        }

        @Override
        public String encodeValue(Object value) {
            if (value == null) {
                return "";
            }
            Class<?> clazz = value.getClass();
            if (String.class.isAssignableFrom(clazz)) {
                return (String)value;
            }
            if (Color.class.isAssignableFrom(clazz)) {
                Color c = (Color)value;
                return "#" + Integer.toHexString(c.getRed() << 16 | c.getGreen() << 8 | c.getBlue());
            }
            if (Font.class.isAssignableFrom(clazz)) {
                Font font = (Font)value;
                return FontUtil.encodeFont(font);
            }
            if (URL.class.isAssignableFrom(clazz)) {
                URL url = (URL)value;
                return URLFileSystem.toEncodedString((URL)url);
            }
            return value.toString();
        }

        @Override
        public Object decodeValue(Class type, String value) {
            if (String.class.isAssignableFrom(type)) {
                return value;
            }
            if ("".equals(value)) {
                return null;
            }
            if (Integer.class.isAssignableFrom(type)) {
                return Integer.valueOf(value);
            }
            if (Long.class.isAssignableFrom(type)) {
                return Long.valueOf(value);
            }
            if (Boolean.class.isAssignableFrom(type)) {
                return Boolean.valueOf(value);
            }
            if (Float.class.isAssignableFrom(type)) {
                return Float.valueOf(value);
            }
            if (Double.class.isAssignableFrom(type)) {
                return Double.valueOf(value);
            }
            if (Color.class.isAssignableFrom(type)) {
                return Color.decode(value);
            }
            if (Font.class.isAssignableFrom(type)) {
                return FontUtil.decodeFont(value);
            }
            if (URL.class.isAssignableFrom(type)) {
                try {
                    return new URL(value);
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
            }
            return null;
        }
    }

    private static class ProxyPreferenceDefinition
    implements PreferenceDefinition {
        private final PreferenceDefinition _base;
        private final Object _defaultValue;

        private ProxyPreferenceDefinition(PreferenceDefinition pd) {
            this(pd, null);
        }

        private ProxyPreferenceDefinition(PreferenceDefinition pd, Object defaultValue) {
            this._base = pd;
            this._defaultValue = defaultValue;
        }

        @Override
        public String getNLSName() {
            return this._base.getNLSName();
        }

        @Override
        public String getNLSDescription() {
            return this._base.getNLSDescription();
        }

        @Override
        public String getHelpId() {
            return this._base.getHelpId();
        }

        @Override
        public Object getId() {
            return this._base.getId();
        }

        @Override
        public PropertyGroup getPropertyGroup() {
            return this._base.getPropertyGroup();
        }

        @Override
        public Class<? extends PropertyEditorFactory> getPropertyEditorFactoryClass() {
            return this._base.getPropertyEditorFactoryClass();
        }

        @Override
        public String getStorageKey() {
            return this._base.getStorageKey();
        }

        @Override
        public Object getFactoryDefaultValue() {
            return this._defaultValue == null ? this._base.getFactoryDefaultValue() : this._defaultValue;
        }

        @Override
        public Class getType() {
            return this._base.getType();
        }

        @Override
        public PreferenceDefinition getRootDefinition() {
            return this._base.getRootDefinition();
        }

        @Override
        public ValueMarshaller getValueMarshaller() {
            return this._base.getValueMarshaller();
        }

        public int hashCode() {
            return this._base.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof ProxyPreferenceDefinition) {
                return ((ProxyPreferenceDefinition)o)._base.equals(this._base);
            }
            return this._base.equals(o);
        }
    }

    private static class LazyPreferenceDefinition
    implements PreferenceDefinition {
        private final Object _internalId;
        private final String _storageKey;
        private final ResourceBundle _bundle;
        private String _resBaseKey;
        private final PropertyGroup _category;
        private final Class<? extends PropertyEditorFactory> _factoryClass;
        private final Object _factoryDefaultValue;
        private final Class _valueType;
        private final ValueMarshaller _marshaller;
        private boolean _initialized = false;
        private String _nlsName = null;
        private String _nlsDesc = null;
        private String _helpId = null;

        private <T extends PropertyEditorFactory> LazyPreferenceDefinition(Object internalId, String storageKey, ResourceBundle rb, String resBaseKey, PropertyGroup category, Class<T> propertyEditorFactoryClass, Object factoryDefaultValue, Class valueType, ValueMarshaller marshaller) {
            this._internalId = internalId;
            this._storageKey = storageKey;
            this._bundle = rb;
            this._resBaseKey = resBaseKey;
            this._category = category;
            this._factoryClass = propertyEditorFactoryClass;
            this._factoryDefaultValue = factoryDefaultValue;
            this._valueType = valueType;
            this._marshaller = marshaller;
        }

        @Override
        public String getNLSName() {
            this.initialize();
            return this._nlsName;
        }

        @Override
        public PreferenceDefinition getRootDefinition() {
            return this;
        }

        @Override
        public String getNLSDescription() {
            this.initialize();
            return this._nlsDesc;
        }

        @Override
        public String getHelpId() {
            this.initialize();
            return this._helpId;
        }

        @Override
        public PropertyGroup getPropertyGroup() {
            return this._category;
        }

        @Override
        public Class<? extends PropertyEditorFactory> getPropertyEditorFactoryClass() {
            return this._factoryClass;
        }

        @Override
        public String getStorageKey() {
            return this._storageKey;
        }

        @Override
        public Object getFactoryDefaultValue() {
            return this._factoryDefaultValue;
        }

        @Override
        public Object getId() {
            if (this._internalId != null) {
                return this._internalId;
            }
            return this;
        }

        @Override
        public Class getType() {
            return this._valueType;
        }

        @Override
        public ValueMarshaller getValueMarshaller() {
            return this._marshaller;
        }

        protected void initialize() {
            if (!this._initialized) {
                this._initialized = true;
                try {
                    this._nlsName = this._bundle.getString(this._resBaseKey + PreferenceUtil.NAME_KEY);
                }
                catch (MissingResourceException mrex) {
                    this._nlsName = PreferenceUtil.NLS_ERROR_PREFIX + this._resBaseKey + PreferenceUtil.NAME_KEY;
                }
                try {
                    this._nlsDesc = this._bundle.getString(this._resBaseKey + PreferenceUtil.DESCRIPTION_KEY);
                }
                catch (MissingResourceException mrex) {
                    this._nlsDesc = PreferenceUtil.NLS_ERROR_PREFIX + this._resBaseKey + PreferenceUtil.DESCRIPTION_KEY;
                }
                try {
                    this._helpId = this._bundle.getString(this._resBaseKey + PreferenceUtil.HELPID_KEY);
                }
                catch (MissingResourceException mrex) {
                    this._helpId = null;
                }
                this._resBaseKey = null;
            }
        }

        public int hashCode() {
            PreferenceDefinition root = this.getRootDefinition();
            if (root == this) {
                return super.hashCode();
            }
            return root.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof PreferenceDefinition) {
                return ((PreferenceDefinition)o).getRootDefinition() == this.getRootDefinition();
            }
            return false;
        }
    }
}

