/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.swimlanes.graphic;

import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvLine;
import java.util.List;
import oracle.diagram.core.interaction.CompositeObjectInteractor;
import oracle.diagram.framework.geom.DimensionFloat;
import oracle.diagram.framework.graphic.ExtendedGraphic;
import oracle.diagram.framework.graphic.layout.row.ReorderRowInteractor;
import oracle.diagram.framework.graphic.layout.row.ResizeRowInteractor;
import oracle.diagram.framework.graphic.layout.row.ResizeRowUndoableStep;
import oracle.diagram.framework.graphic.layout.row.RowContainer;
import oracle.diagram.framework.graphic.layout.row.RowLayout;
import oracle.diagram.framework.swimlanes.SwimlanesPermissions;
import oracle.diagram.framework.swimlanes.graphic.PoolGraphic;
import oracle.diagram.framework.swimlanes.graphic.SwimlaneGraphic;
import oracle.diagram.framework.undo.UndoableStep;

public class HorizontalPoolGraphic
extends PoolGraphic
implements RowContainer {
    public HorizontalPoolGraphic(IlvRect rect, List<SwimlaneGraphic> laneGraphics) {
        super(rect, new RowLayout(), laneGraphics);
        ((RowLayout)this.getLayout()).setMargins(0.0f, 0.0f, 0.0f, 0.0f);
        this.setObjectInteractor(new CompositeObjectInteractor(new ResizeRowInteractor(), new ReorderRowInteractor()));
    }

    @Override
    public DimensionFloat getMinimumSwimlaneSize(DimensionFloat minimum) {
        DimensionFloat dim = super.getMinimumSwimlaneSize(minimum);
        if (!this._lanes.isEmpty()) {
            IlvRect poolBBox = this.boundingBox(null);
            SwimlaneGraphic lastLane = (SwimlaneGraphic)this._lanes.get(this._lanes.size() - 1);
            IlvRect lastLaneBBox = lastLane.boundingBox(null);
            DimensionFloat lastLaneMinSize = lastLane.getMinimumSwimlaneSize(new DimensionFloat());
            dim.height = poolBBox.height - lastLaneBBox.height + lastLaneMinSize.height;
        }
        return dim;
    }

    @Override
    public DimensionFloat getMinimumSize(DimensionFloat minimum) {
        DimensionFloat d = super.getMinimumSize(minimum);
        if (!this._lanes.isEmpty()) {
            IlvRect poolBBox = this.boundingBox(null);
            SwimlaneGraphic lastLane = (SwimlaneGraphic)this._lanes.get(this._lanes.size() - 1);
            IlvRect lastLaneBBox = lastLane.boundingBox(null);
            DimensionFloat lastLaneMinSize = lastLane.getMinimumSize(new DimensionFloat());
            d.height = poolBBox.height - lastLaneBBox.height + lastLaneMinSize.height;
        }
        RowLayout layout = (RowLayout)this.getLayout();
        d.height = d.height + layout.getTopMargin() + layout.getBottomMargin();
        d.width = d.width + layout.getLeftMargin() + layout.getRightMargin();
        return minimum;
    }

    @Override
    public DimensionFloat getPreferedSize(DimensionFloat prefered) {
        for (SwimlaneGraphic g : this._lanes) {
            DimensionFloat d = g.getPreferedSize(new DimensionFloat());
            prefered.height += d.height;
            prefered.width = Math.max(prefered.width, d.width);
        }
        for (IlvLine divider : this._dividers) {
            prefered.height += divider.getLineWidth();
        }
        RowLayout layout = (RowLayout)this.getLayout();
        prefered.height = prefered.height + layout.getTopMargin() + layout.getBottomMargin();
        prefered.width = prefered.width + layout.getLeftMargin() + layout.getRightMargin();
        return prefered;
    }

    @Override
    public int getRowIndex(IlvLine divider) {
        return divider instanceof PoolGraphic.DividerLine ? this._dividers.indexOf((PoolGraphic.DividerLine)divider) : -1;
    }

    @Override
    public ExtendedGraphic getRowGraphic(int index) {
        return (ExtendedGraphic)this._lanes.get(index);
    }

    @Override
    public void deleteLane(SwimlaneGraphic lane) {
        this.deleteLaneImpl(lane, new DimensionFloat(0.0f, lane.boundingBox(null).height * -1.0f));
    }

    @Override
    public void insertLane(SwimlaneGraphic lane, int index) {
        this.insertLaneImpl(lane, index, new DimensionFloat(0.0f, lane.boundingBox(null).height));
    }

    @Override
    public void resizeRow(int index, float newHeight) {
        SwimlaneGraphic lane = (SwimlaneGraphic)this._lanes.get(index);
        DimensionFloat preferredSize = lane.getPreferedSize(new DimensionFloat());
        preferredSize.height = newHeight;
        this.resizeLaneImpl(lane, preferredSize);
    }

    @Override
    public DimensionFloat getMinimumRowSize(int index, DimensionFloat dim) {
        return ((SwimlaneGraphic)this._lanes.get(index)).getMinimumSwimlaneSize(dim);
    }

    @Override
    public int getRowGraphicIndex(ExtendedGraphic g) {
        return g instanceof SwimlaneGraphic ? this._lanes.indexOf((SwimlaneGraphic)g) : -1;
    }

    @Override
    public void moveRow(int fromIndex, int toIndex) {
        this.moveLaneImpl(fromIndex, toIndex);
    }

    @Override
    public UndoableStep createLaneGraphicUndoableStep(SwimlaneGraphic lane) {
        return this.createLaneIndexUndoableStep(this.getRowGraphicIndex(lane));
    }

    @Override
    public UndoableStep createLaneIndexUndoableStep(int index) {
        return new ResizeRowUndoableStep(this, index){

            @Override
            protected void redoImpl() {
                SwimlaneGraphic topSwimlane = HorizontalPoolGraphic.this.getTopSwimlane();
                boolean isEnabled = topSwimlane.getLayoutEventsEnabled();
                topSwimlane.setLayoutEventsEnabled(false);
                super.redoImpl();
                topSwimlane.setLayoutEventsEnabled(isEnabled);
            }
        };
    }

    @Override
    public boolean canResizeRows() {
        SwimlanesPermissions permissions = this.getPermissions();
        return permissions == null ? false : permissions.canResizeSwimlanes(this);
    }

    @Override
    public boolean canMoveRow(int index) {
        SwimlanesPermissions permissions = this.getPermissions();
        return permissions == null ? false : permissions.canMoveSwimlane(this, index);
    }

    @Override
    public boolean canMoveRow(int fromIndex, int toIndex) {
        SwimlanesPermissions permissions = this.getPermissions();
        return permissions == null ? false : permissions.canMoveSwimlane(this, fromIndex, toIndex);
    }

    @Override
    public ExtendedGraphic getRowGraphic(IlvPoint pt, IlvTransformer t) {
        return this.getSwimlaneSubShape(pt, t);
    }
}

