/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.swimlanes.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.composite.layout.IlvLayoutManager;
import ilog.views.graphlayout.hierarchical.IlvNodeGroup;
import ilog.views.linkconnector.IlvShapePath;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import oracle.diagram.framework.geom.DimensionFloat;
import oracle.diagram.framework.graphic.ContainerGraphic;
import oracle.diagram.framework.graphic.FakeNode;
import oracle.diagram.framework.graphic.RectangleOutline;
import oracle.diagram.framework.graphic.layout.ListLayout;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.framework.preference.VisualProperty;
import oracle.diagram.framework.selection.SubSelectionManager;
import oracle.diagram.framework.swimlanes.SwimlanesContentsProvider;
import oracle.diagram.framework.swimlanes.SwimlanesPermissions;
import oracle.diagram.framework.swimlanes.graphic.AbstractHeaderGraphic;
import oracle.diagram.framework.swimlanes.graphic.SwimlaneGraphicConstraint;
import oracle.diagram.framework.swimlanes.graphic.SwimlaneLayoutListener;

public class SwimlaneGraphic
extends ContainerGraphic
implements IlvShapePath,
VisualProperty {
    private RectangleOutline m_outline;
    private boolean m_isAutoExpand;
    private SwimlanesPermissions _permissions;
    private SwimlanesContentsProvider _contentsProvider;
    private Color m_fillColor = null;
    private Color m_lineColor = null;
    private Color m_fontColor = null;
    private Font m_font = null;
    private HashSet<SwimlaneLayoutListener> _listeners;
    private boolean _layoutEventsEnabled = true;

    public SwimlaneGraphic(IlvRect rect) {
        this(rect, new ListLayout(0.0f, 0.0f, 0.0f, 0.0f));
    }

    public SwimlaneGraphic(IlvRect rect, IlvLayoutManager layoutManager) {
        this.setLayout(layoutManager);
        this.setTopLevel(false);
        this.m_outline = new RectangleOutline(rect);
        this.m_outline.setFillOn(true);
        this.m_outline.setGradientFillOn(false);
        this.m_outline.setThickness(1.0f);
        this.addContent(this.m_outline);
        SubSelectionManager.setSelectable(this.m_outline, false);
        this.m_outline.setThickness(4.0f);
        this.setShapeFillColor(Color.pink);
        this.setShapeLineColor(Color.green);
        this.setProperty("NonEllipsisShape", Boolean.TRUE);
    }

    public final void setPermissions(SwimlanesPermissions permissions) {
        this._permissions = permissions;
    }

    protected final SwimlanesPermissions getPermissions() {
        if (this._permissions != null || this == this.getTopSwimlane()) {
            return this._permissions;
        }
        return this.getTopSwimlane().getPermissions();
    }

    public final void setContentsProvider(SwimlanesContentsProvider provider) {
        this._contentsProvider = provider;
    }

    protected final SwimlanesContentsProvider getContentsProvider() {
        if (this._contentsProvider != null || this == this.getTopSwimlane()) {
            return this._contentsProvider;
        }
        return this.getTopSwimlane().getContentsProvider();
    }

    public List<SwimlaneGraphicConstraint> getSwimlaneGraphicConstraints() {
        LinkedList<SwimlaneGraphicConstraint> constraints = new LinkedList<SwimlaneGraphicConstraint>();
        this.getSwimlaneGraphicConstraintsImpl(constraints, 0);
        if (this.getFlowDirection() == 2 && !constraints.isEmpty()) {
            int size = constraints.size();
            for (int i = 0; i < size; ++i) {
                constraints.get(size - 1 - i).setSpecPositionIndex(i);
            }
        }
        return constraints;
    }

    protected int getSwimlaneGraphicConstraintsImpl(LinkedList<SwimlaneGraphicConstraint> constraints, int startIndex) {
        Collection<IlvGraphic> graphics;
        int nextIndex = startIndex;
        SwimlanesContentsProvider provider = this.getContentsProvider();
        if (provider != null && (graphics = provider.getGraphicsInSwimlane(this)) != null && !graphics.isEmpty()) {
            Vector<IlvGraphic> graphicsVector = new Vector<IlvGraphic>();
            for (IlvGraphic g : graphics) {
                if (g instanceof IlvLinkImage || g instanceof FakeNode) continue;
                graphicsVector.add(g);
            }
            if (!graphicsVector.isEmpty()) {
                IlvRect bbox = this.getInteriorBoundingBox(null);
                float relativeSize = this.getFlowDirection() == 2 ? bbox.height : bbox.width;
                SwimlaneGraphicConstraint constraint = new SwimlaneGraphicConstraint(this, new IlvNodeGroup(graphicsVector), 0.0f, nextIndex++);
                constraints.add(constraint);
            }
        }
        return nextIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addLayoutListener(SwimlaneLayoutListener listener) {
        if (this._listeners == null) {
            this._listeners = new HashSet();
        }
        HashSet<SwimlaneLayoutListener> hashSet = this._listeners;
        synchronized (hashSet) {
            this._listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeLayoutListener(SwimlaneLayoutListener listener) {
        if (this._listeners != null) {
            HashSet<SwimlaneLayoutListener> hashSet = this._listeners;
            synchronized (hashSet) {
                this._listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fireLayoutChanged() {
        if (this._listeners != null && this._layoutEventsEnabled) {
            HashSet<SwimlaneLayoutListener> hashSet = this._listeners;
            synchronized (hashSet) {
                for (SwimlaneLayoutListener l : this._listeners) {
                    l.layoutChanged(this);
                }
            }
        }
    }

    public final boolean getLayoutEventsEnabled() {
        return this._layoutEventsEnabled;
    }

    public final void setLayoutEventsEnabled(boolean enable) {
        this._layoutEventsEnabled = enable;
    }

    protected IlvManager getTopManager() {
        return ManagerUtil.getTopManager((IlvGraphic)this.getTopSwimlane());
    }

    public int getFlowDirection() {
        return 2;
    }

    public final boolean isAutoExpand() {
        return this.m_isAutoExpand;
    }

    public final void setAutoExpand(boolean isAutoExpand) {
        this.m_isAutoExpand = isAutoExpand;
    }

    public final SwimlaneGraphic getTopSwimlane() {
        SwimlaneGraphic sg = this;
        IlvGraphicBag bag = this.getGraphicBag();
        while (bag != null && bag instanceof SwimlaneGraphic) {
            sg = (SwimlaneGraphic)bag;
            bag = sg.getGraphicBag();
        }
        return sg;
    }

    public IlvRect getInteriorBoundingBox(IlvTransformer t) {
        IlvRect bbox = new IlvRect(this.boundingBox(null));
        if (this.getOutline().isBorderOn()) {
            float thickness = this.getShapeLineThickness().floatValue();
            bbox.x += thickness;
            bbox.y += thickness;
            bbox.width -= 2.0f * thickness;
            bbox.height -= 2.0f * thickness;
        }
        if (t != null) {
            t.apply(bbox);
        }
        return bbox;
    }

    public boolean isLayoutCurrent() {
        DimensionFloat prefSize = this.getPreferedSize(new DimensionFloat());
        IlvRect bbox = this.boundingBox(null);
        return prefSize.width == bbox.width && prefSize.height == bbox.height;
    }

    public DimensionFloat getMinimumSwimlaneSize(DimensionFloat minimum) {
        return this.getMinimumSize(minimum);
    }

    public SwimlaneGraphic getSwimlaneSubShape(IlvPoint point, IlvTransformer t) {
        IlvGraphic g = this.getSubShape(point, t);
        if (g != null) {
            while (!(g instanceof SwimlaneGraphic)) {
                g = (IlvGraphic)g.getGraphicBag();
            }
            return (SwimlaneGraphic)g;
        }
        return null;
    }

    @Override
    protected IlvGraphic getSubShapeImpl(IlvPoint point, IlvTransformer tx) {
        IlvPoint p = new IlvPoint(point);
        if (tx != null) {
            tx.inverse(p);
        }
        boolean skip = this.shouldIgnoreFirstChild(this);
        IlvGraphic[] children = this.getChildren();
        for (int childNumber = children.length - 1; childNumber >= (skip ? 1 : 0); --childNumber) {
            IlvGraphic tmp;
            IlvGraphic child = children[childNumber];
            if (child instanceof AbstractHeaderGraphic) {
                IlvRect r = new IlvRect(child.boundingBox(tx));
                if (!r.contains((Point2D)point)) continue;
                return child;
            }
            if (!child.isVisible() || !child.contains(p, point, tx)) continue;
            if (child instanceof SwimlaneGraphic && (tmp = ((SwimlaneGraphic)child).getSubShape(point, tx)) != null) {
                return tmp;
            }
            return child;
        }
        return this;
    }

    @Override
    protected void drawImpl(Graphics2D g2d, IlvRect clipRect, IlvTransformer tx) {
        Graphics2D g2dcopy = (Graphics2D)g2d.create();
        super.drawImpl(g2dcopy, clipRect, tx);
        g2dcopy.dispose();
        if (this.checkPartiallyDrawable(this.m_outline, clipRect, tx)) {
            this.m_outline.drawBorder(g2d, tx);
        }
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (this == this.getTopSwimlane()) {
            SwimlaneGraphic.fixDoLayout(this);
        }
    }

    protected void fixDoLayoutImpl() {
    }

    private static void fixDoLayout(SwimlaneGraphic sg) {
        IlvGraphic[] children;
        sg.fixDoLayoutImpl();
        for (IlvGraphic child : children = sg.getChildren()) {
            if (!(child instanceof SwimlaneGraphic)) continue;
            SwimlaneGraphic.fixDoLayout((SwimlaneGraphic)child);
        }
    }

    @Override
    public IlvRect boundingBox(IlvTransformer t) {
        return this.m_outline.boundingBox(t);
    }

    public final RectangleOutline getOutline() {
        return this.m_outline;
    }

    @Override
    public PathIterator getShapePath(IlvTransformer t) {
        return this.m_outline.getShapePath(t);
    }

    @Override
    public Color getShapeFillColor() {
        return this.m_fillColor;
    }

    @Override
    public void setShapeFillColor(Color color) {
        this.m_fillColor = color;
        this.m_outline.setBackground(this.m_fillColor);
    }

    @Override
    public Font getShapeFont() {
        return this.m_font;
    }

    @Override
    public void setShapeFont(Font font) {
        this.m_font = font;
    }

    @Override
    public Color getShapeLineColor() {
        return this.m_lineColor;
    }

    @Override
    public void setShapeLineColor(Color color) {
        this.m_lineColor = color;
        this.m_outline.setForeground(color);
    }

    public Float getShapeLineThickness() {
        return Float.valueOf(this.m_outline.isBorderOn() ? this.m_outline.getThickness() : 0.0f);
    }

    public void setShapeLineThickness(float thickness) {
        if (thickness == 0.0f) {
            this.m_outline.setBorderOn(false);
            this.m_outline.setThickness(1.0f);
        } else {
            this.m_outline.setBorderOn(true);
            this.m_outline.setThickness(thickness);
        }
    }

    @Override
    public Color getShapeFontColor() {
        return this.m_fontColor;
    }

    @Override
    public void setShapeFontColor(Color color) {
        this.m_fontColor = color;
    }
}

