/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.swimlanes.interaction;

import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import java.util.Set;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.interaction.CoreSelectInteractorMoveSelection;
import oracle.diagram.core.util.Translator;
import oracle.diagram.framework.interaction.MoveGraphicsHelper;
import oracle.diagram.framework.swimlanes.SwimlanesPlugin;
import oracle.diagram.framework.swimlanes.graphic.SwimlaneGraphic;

public abstract class AbstractSwimlanesMoveGraphicsHelper
implements MoveGraphicsHelper {
    protected DiagramContext _context;
    protected SwimlanesPlugin _plugin;
    protected IlvManager _topManager;
    protected Set<IlvGraphic> _movingGraphics;

    public AbstractSwimlanesMoveGraphicsHelper(DiagramContext context, SwimlanesPlugin plugin, IlvManager topManager, Set<IlvGraphic> movingGraphics) {
        this._context = context;
        this._plugin = plugin;
        this._topManager = topManager;
        this._movingGraphics = movingGraphics;
    }

    @Override
    public void translateGraphics(Translator translator, float cdx, float cdy) {
        for (IlvGraphic g : this._movingGraphics) {
            IlvManager myManager = (IlvManager)g.getGraphicBag();
            myManager.setContentsAdjusting(true, true);
            translator.init(cdx, cdy, myManager.getDrawingTransformer(this._context.getManagerView()));
            translator.translateObj(myManager, g, true);
        }
    }

    @Override
    public CoreSelectInteractorMoveSelection.MoveType validateMoveTarget(IlvGraphic hitObject, IlvGraphic hitSubObject, int modifiers, IlvPoint mgrDragPoint, CoreSelectInteractorMoveSelection.MoveType defaultMoveType) {
        if (defaultMoveType == CoreSelectInteractorMoveSelection.MoveType.MOVE && (hitObject instanceof SwimlaneGraphic ? !(hitSubObject instanceof SwimlaneGraphic) : hitObject == null || hitObject == this._topManager)) {
            return CoreSelectInteractorMoveSelection.MoveType.INVALID;
        }
        return defaultMoveType;
    }

    @Override
    public CoreSelectInteractorMoveSelection.MoveType moveComplete(IlvPoint mgrSourcePoint, IlvPoint mgrDropPoint, IlvGraphic target, IlvGraphic subTarget, CoreSelectInteractorMoveSelection.MoveType targetValidity) {
        if (targetValidity == CoreSelectInteractorMoveSelection.MoveType.MOVE && target instanceof SwimlaneGraphic && subTarget instanceof SwimlaneGraphic) {
            SwimlaneGraphic oldSwimlane;
            SwimlaneGraphic sg = (SwimlaneGraphic)subTarget;
            IlvRect allGraphicsRect = null;
            for (IlvGraphic g : this._movingGraphics) {
                oldSwimlane = this._plugin.getSwimlaneForGraphic(g);
                if (oldSwimlane == null || sg == oldSwimlane) continue;
                if (allGraphicsRect == null) {
                    allGraphicsRect = new IlvRect(g.boundingBox(null));
                    continue;
                }
                allGraphicsRect.add(g.boundingBox(null));
            }
            for (IlvGraphic g : this._movingGraphics) {
                oldSwimlane = this._plugin.getSwimlaneForGraphic(g);
                if (oldSwimlane == null || sg == oldSwimlane) continue;
                IlvRect gBBox = g.boundingBox(null);
                IlvRect sgBBox = sg.getInteriorBoundingBox(null);
                IlvPoint p = new IlvPoint(mgrDropPoint.x + (gBBox.x - allGraphicsRect.x) - (mgrSourcePoint.x - allGraphicsRect.x), mgrDropPoint.y + (gBBox.y - allGraphicsRect.y) - (mgrSourcePoint.y - allGraphicsRect.y));
                if (p.x < sgBBox.x + 1.0f) {
                    p.x = sgBBox.x + 1.0f;
                }
                if (p.y < sgBBox.y + 1.0f) {
                    p.y = sgBBox.y + 1.0f;
                }
                if (p.x + gBBox.width > sgBBox.x + sgBBox.width - 1.0f) {
                    p.x = sgBBox.x + sgBBox.width - 1.0f - gBBox.width;
                }
                if (p.y + gBBox.height > sgBBox.y + sgBBox.height - 1.0f) {
                    p.y = sgBBox.y + sgBBox.height - 1.0f - gBBox.height;
                }
                this.removeGraphicFromSwimlane(g, oldSwimlane);
                this._topManager.moveObject(g, p.x, p.y, true);
                this.addGraphicToSwimlane(g, sg);
            }
        }
        return targetValidity;
    }

    protected abstract void removeGraphicFromSwimlane(IlvGraphic var1, SwimlaneGraphic var2);

    protected abstract void addGraphicToSwimlane(IlvGraphic var1, SwimlaneGraphic var2);

    @Override
    public void cleanUp() {
        this._plugin = null;
        this._topManager = null;
        this._movingGraphics = null;
    }
}

