/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.undo;

import oracle.bm.util.LoggerUtils;
import oracle.diagram.framework.undo.UndoableStep;
import oracle.diagram.framework.undo.UndoableStepCommand;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.feedback.FeedbackManager;

public abstract class UndoableStepManager {
    private int _transactionCount = 0;
    private UndoableStepCommand _cmd = null;
    private Command _predecessor = null;

    protected UndoableStepManager() {
    }

    public final synchronized boolean hasTransaction() {
        return this._transactionCount > 0;
    }

    public final UndoableStepCommand getTransactionCommand() {
        if (this.hasTransaction()) {
            return this._cmd;
        }
        return null;
    }

    public void nonUndoableStepPerformed() {
        this.nonUndoableStepPerformed(true);
    }

    public void nonUndoableStepPerformed(boolean dirty) {
        if (this._transactionCount != 0) {
            throw new IllegalStateException("UndoableStepManager: non-undoable step occurred during a transaction");
        }
        UndoableStepCommand cmd = this.createCommand(2, "", dirty);
        cmd.setContext(this.getIdeContext());
        try {
            CommandProcessor.getInstance().invoke((Command)cmd);
        }
        catch (Exception ex) {
            FeedbackManager.getFeedbackManager();
            FeedbackManager.reportException((String)"UndoableStepManager.nonUndoableStepOccurred()", (Throwable)ex);
        }
    }

    public synchronized void addUndoableSteps(UndoableStep[] steps) {
        this.addUndoableSteps(steps, null);
    }

    public synchronized void addUndoableSteps(UndoableStep[] steps, String description) {
        boolean transactionOpened = false;
        if (this._transactionCount == 0) {
            this.beginTransaction(description);
            transactionOpened = true;
        }
        for (UndoableStep step : steps) {
            this.addUndoableStepImpl(step);
        }
        if (transactionOpened) {
            this.endTransaction();
        }
    }

    public synchronized void addUndoableStep(UndoableStep step) {
        this.addUndoableStep(step, null);
    }

    public synchronized void addUndoableStep(UndoableStep step, String description) {
        boolean transactionOpened = false;
        if (this._transactionCount == 0) {
            this.beginTransaction(description);
            transactionOpened = true;
        }
        this.addUndoableStepImpl(step);
        if (transactionOpened) {
            this.endTransaction();
        }
    }

    public synchronized void beginTransaction(String description) {
        if (this._transactionCount == 0) {
            this._cmd = this.createCommand(0, description == null ? "" : description, true);
            this._predecessor = CommandProcessor.getInstance().getCommand(this.getIdeContext());
        }
        ++this._transactionCount;
    }

    public synchronized int getTransactionCount() {
        return this._transactionCount;
    }

    public synchronized void abortTransaction() {
        if (this.hasTransaction() && --this._transactionCount == 0) {
            this._predecessor = null;
            this._cmd = null;
        }
    }

    public synchronized void endTransaction() {
        if (!this.hasTransaction()) {
            return;
        }
        if (--this._transactionCount == 0) {
            Command currentPredecessor = CommandProcessor.getInstance().getCommand(this.getIdeContext());
            if (currentPredecessor != this._predecessor) {
                LoggerUtils.getLoggerForClass(UndoableStepManager.class).fine("WARNING: New Command instance(s) submitted to the CommandProcessor since the UndoableStepManager transaction was started");
            }
            this._predecessor = null;
            UndoableStepCommand cmd = this._cmd;
            this._cmd = null;
            if (!cmd.isEmpty()) {
                cmd.setContext(this.getIdeContext());
                try {
                    CommandProcessor.getInstance().invoke((Command)cmd);
                }
                catch (Exception ex) {
                    FeedbackManager.getFeedbackManager();
                    FeedbackManager.reportException((String)"UndoableStepManager.endTransaction()", (Throwable)ex);
                }
            }
        }
    }

    public abstract Context getIdeContext();

    protected UndoableStepCommand createCommand(int type, String description, boolean dirty) {
        UndoableStepCommand cmd = new UndoableStepCommand(Ide.findOrCreateCmdID((String)"UndoableStepManager.UndoableStepCommand"), type, description);
        cmd.setDirtyingCommand(dirty);
        return cmd;
    }

    protected void addUndoableStepImpl(UndoableStep step) {
        this._cmd.addUndoableStep(step);
    }
}

