/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.view;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Rectangle2D;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.framework.transformer.TransformerUtil;

public final class ViewUtil {
    public static final int[] ZOOM_PERCENTAGES = new int[]{400, 200, 150, 125, 100, 75, 50, 40, 25, 15, 10, 5};
    public static final double MIMINUM_SCALE = (double)ZOOM_PERCENTAGES[ZOOM_PERCENTAGES.length - 1] / 100.0;

    private ViewUtil() {
    }

    public static void zoomIn(IlvManagerView mgrView, boolean repaint) {
        Dimension dimension = mgrView.getSize();
        mgrView.zoom(new IlvPoint((float)Math.floor(dimension.width / 2), (float)Math.floor(dimension.height / 2)), 2.0, 2.0, repaint);
    }

    public static void zoomOut(IlvManagerView mgrView, boolean repaint) {
        Dimension dimension = mgrView.getSize();
        mgrView.zoom(new IlvPoint((float)Math.floor(dimension.width / 2), (float)Math.floor(dimension.height / 2)), 0.5, 0.5, repaint);
    }

    public static void zoomFitToWindow(IlvManagerView mgrView, boolean repaint) {
        ViewUtil.zoomFitToWindow(mgrView, 0.0, repaint);
    }

    public static IlvTransformer calculateZoomToFitTransformer(IlvRect rSource, IlvRect rTarget, boolean preserveAspectRatio, double maxZoom) {
        double targetWidth = rTarget.getWidth();
        double targetHeight = rTarget.getHeight();
        IlvTransformer t = new IlvTransformer();
        double scaleX = targetWidth / (double)rSource.width;
        if (maxZoom != 0.0) {
            scaleX = Math.min(maxZoom, scaleX);
        }
        double scaleY = targetHeight / (double)rSource.height;
        if (maxZoom != 0.0) {
            scaleY = Math.min(maxZoom, scaleY);
        }
        if (preserveAspectRatio) {
            scaleX = scaleY = Math.min(scaleX, scaleY);
        }
        scaleX = Math.max(scaleX, MIMINUM_SCALE);
        scaleY = Math.max(scaleY, MIMINUM_SCALE);
        double offX = (targetWidth - scaleX * (double)rSource.width) / 2.0 - (double)rSource.x * scaleX + rTarget.getX();
        double offY = (targetHeight - scaleY * (double)rSource.height) / 2.0 - (double)rSource.y * scaleY + rTarget.getY();
        t.setValues(scaleX, 0.0, 0.0, scaleY, offX, offY);
        return t;
    }

    public static void zoomFitToWindow(IlvManagerView mgrView, double maxZoom, boolean repaint) {
        Dimension viewSize = mgrView.getSize();
        IlvRect viewRect = new IlvRect(0.0f, 0.0f, (float)viewSize.getWidth(), (float)viewSize.getHeight());
        IlvRect managerRect = new IlvRect(mgrView.getManager().computeBBox(null));
        IlvTransformer t = ViewUtil.calculateZoomToFitTransformer(managerRect, viewRect, mgrView.isKeepingAspectRatio(), maxZoom);
        mgrView.setTransformer(t);
        if (repaint) {
            mgrView.invalidateView();
            mgrView.reDrawViews();
        }
    }

    public static void zoomActualSize(IlvManagerView mgrView, boolean repaint) {
        if (mgrView.getTransformer().zoomXFactor() == 1.0 && mgrView.getTransformer().zoomYFactor() == 1.0) {
            return;
        }
        Dimension viewSize = mgrView.getSize();
        IlvRect viewRect = new IlvRect();
        ViewUtil.getVisibleBounds(mgrView, viewRect);
        IlvPoint centerPoint = new IlvPoint(viewRect.x + viewRect.width / 2.0f, viewRect.y + viewRect.height / 2.0f);
        IlvTransformer t = new IlvTransformer();
        double offX = (float)(viewSize.width / 2) - centerPoint.x;
        double offY = (float)(viewSize.height / 2) - centerPoint.y;
        t.setValues(1.0, 0.0, 0.0, 1.0, offX, offY);
        mgrView.setTransformer(t);
        if (repaint) {
            mgrView.repaint();
        }
    }

    public static void zoomSelected(IlvManagerView mgrView, boolean repaint) {
        ViewUtil.zoomSelected(mgrView, Double.MAX_VALUE, repaint);
    }

    public static void zoomSelected(IlvManagerView mgrView, double maxScale, boolean repaint) {
        IlvGraphic g;
        IlvRect r = null;
        IlvManager topManager = mgrView.getManager();
        IlvGraphicEnumeration e = mgrView.getManager().getSelectedObjects(true);
        while (e.hasMoreElements()) {
            IlvTransformer t;
            g = e.nextElement();
            IlvManager graphicMgr = ManagerUtil.getManager(g);
            IlvTransformer ilvTransformer = t = graphicMgr == null || graphicMgr == topManager ? TransformerUtil.IDENTITY_TRANSFORMER : ManagerUtil.getConversionTransformer(topManager, graphicMgr);
            if (r == null) {
                r = new IlvRect(g.boundingBox());
                t.apply(r);
                continue;
            }
            IlvRect tmp = g.boundingBox();
            t.apply(tmp);
            r.add(tmp);
        }
        if (r != null) {
            e = mgrView.getManager().getSelections();
            while (e.hasMoreElements()) {
                g = e.nextElement();
                IlvRect tmp = g.boundingBox();
                r.add(tmp);
            }
            ViewUtil.zoomRectangle(mgrView, r, maxScale, repaint);
        }
    }

    public static void zoomRectangle(IlvManagerView mgrView, IlvRect rect, boolean repaint) {
        ViewUtil.zoomRectangle(mgrView, rect, Double.MAX_VALUE, repaint);
    }

    public static void zoomRectangle(IlvManagerView mgrView, IlvRect rect, double maxScale, boolean repaint) {
        IlvRect r = new IlvRect(mgrView.getManager().computeBBox(null));
        Dimension viewSize = mgrView.getSize();
        double scaleX = (double)viewSize.width / (double)rect.width;
        double scaleY = (double)viewSize.height / (double)rect.height;
        if (mgrView.isKeepingAspectRatio()) {
            scaleX = scaleY = Math.min(scaleX, scaleY);
        }
        scaleX = Math.min(scaleX, maxScale);
        scaleY = Math.min(scaleY, maxScale);
        scaleX = Math.max(scaleX, MIMINUM_SCALE);
        scaleY = Math.max(scaleY, MIMINUM_SCALE);
        double offX = ((double)viewSize.width - scaleX * (double)rect.width) / 2.0 - (double)rect.x * scaleX;
        double offY = ((double)viewSize.height - scaleY * (double)rect.height) / 2.0 - (double)rect.y * scaleY;
        IlvTransformer t = new IlvTransformer();
        t.setValues(scaleX, 0.0, 0.0, scaleY, offX, offY);
        mgrView.setTransformer(t);
        if (repaint) {
            mgrView.repaint();
        }
    }

    public static void zoomPercent(IlvManagerView mgrView, float percent, boolean repaint) {
        float scale = percent / 100.0f;
        Dimension viewSize = mgrView.getSize();
        IlvRect viewRect = new IlvRect();
        ViewUtil.getVisibleBounds(mgrView, viewRect);
        IlvPoint viewCenter = new IlvPoint((float)viewRect.getCenterX(), (float)viewRect.getCenterY());
        double offX = (double)viewSize.width / 2.0 - (double)(viewCenter.x * scale);
        double offY = (double)viewSize.height / 2.0 - (double)(viewCenter.y * scale);
        IlvTransformer t = new IlvTransformer();
        t.setValues((double)scale, 0.0, 0.0, (double)scale, offX, offY);
        mgrView.setTransformer(t);
        if (repaint) {
            mgrView.repaint();
        }
    }

    public static boolean canZoomNext(IlvManagerView view, boolean zoomIn) {
        IlvTransformer tx = view.getTransformer();
        int scale = (int)(tx.zoomXFactor() * 100.0);
        if (zoomIn) {
            for (int i = ZOOM_PERCENTAGES.length - 1; i >= 0; --i) {
                if (ZOOM_PERCENTAGES[i] <= scale) continue;
                return true;
            }
        } else {
            for (int i = 0; i < ZOOM_PERCENTAGES.length; ++i) {
                if (ZOOM_PERCENTAGES[i] >= scale) continue;
                return true;
            }
        }
        return false;
    }

    public static int getCurrentPercentageZoom(IlvManagerView view) {
        IlvTransformer tx = view.getTransformer();
        int scale = (int)(tx.zoomXFactor() * 100.0);
        return scale;
    }

    public static void zoomNext(IlvManagerView view, boolean zoomIn, boolean repaint) {
        IlvTransformer tx = view.getTransformer();
        int scale = (int)(tx.zoomXFactor() * 100.0);
        if (zoomIn) {
            for (int i = ZOOM_PERCENTAGES.length - 1; i >= 0; --i) {
                if (ZOOM_PERCENTAGES[i] <= scale) continue;
                ViewUtil.zoomPercent(view, ZOOM_PERCENTAGES[i], repaint);
                break;
            }
        } else {
            for (int i = 0; i < ZOOM_PERCENTAGES.length; ++i) {
                if (ZOOM_PERCENTAGES[i] >= scale) continue;
                ViewUtil.zoomPercent(view, ZOOM_PERCENTAGES[i], repaint);
                break;
            }
        }
    }

    public static void ensureVisible(final IlvManagerView mgrView, final IlvRect rectangle, final boolean forceCentered, final boolean repaint) {
        IlvRect visibleBounds = new IlvRect();
        ViewUtil.getVisibleBounds(mgrView, visibleBounds);
        if (visibleBounds.contains(rectangle) && !forceCentered) {
            return;
        }
        if (visibleBounds.width == 0.0f && visibleBounds.height == 0.0f) {
            mgrView.addComponentListener((ComponentListener)new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    mgrView.removeComponentListener((ComponentListener)this);
                    ViewUtil.ensureVisible(mgrView, rectangle, forceCentered, repaint);
                }
            });
            return;
        }
        if (visibleBounds.width < rectangle.width || visibleBounds.height < rectangle.height) {
            ViewUtil.zoomRectangle(mgrView, rectangle, 1.0, repaint);
            return;
        }
        IlvRect newVisibleBounds = new IlvRect();
        if (rectangle.intersects(visibleBounds) && !forceCentered) {
            newVisibleBounds.setRect((Rectangle2D)visibleBounds);
            if (rectangle.x < visibleBounds.x) {
                newVisibleBounds.x = rectangle.x;
            } else if (rectangle.x + rectangle.width > visibleBounds.x + visibleBounds.width) {
                newVisibleBounds.x += rectangle.x + rectangle.width - (visibleBounds.x + visibleBounds.width);
            }
            if (rectangle.y < visibleBounds.y) {
                newVisibleBounds.y = rectangle.y;
            } else if (rectangle.y + rectangle.height > visibleBounds.y + visibleBounds.height) {
                newVisibleBounds.y += rectangle.y + rectangle.height - (visibleBounds.y + visibleBounds.height);
            }
        } else {
            newVisibleBounds.setRect((Rectangle2D)rectangle);
        }
        IlvPoint viewCenter = new IlvPoint((float)visibleBounds.getCenterX(), (float)visibleBounds.getCenterY());
        IlvPoint pt = new IlvPoint((float)newVisibleBounds.getCenterX(), (float)newVisibleBounds.getCenterY());
        IlvTransformer tx = mgrView.getTransformer();
        tx.apply(viewCenter);
        tx.apply(pt);
        float dx = viewCenter.x - pt.x;
        float dy = viewCenter.y - pt.y;
        mgrView.addTransformer(new IlvTransformer(new IlvPoint(dx, dy)));
        if (repaint) {
            mgrView.repaint();
        }
    }

    public static void ensureVisible(IlvManagerView mgrView, IlvGraphic graphic, boolean repaint) {
        ViewUtil.ensureVisible(mgrView, graphic, false, repaint);
    }

    public static void ensureVisible(IlvManagerView mgrView, IlvGraphic graphic, boolean forceCentered, boolean repaint) {
        IlvManager mgr = ManagerUtil.getTransformingManager(graphic);
        if (mgr == null) {
            IlvRect r = graphic.boundingBox();
            ViewUtil.ensureVisible(mgrView, r, forceCentered, repaint);
        } else {
            IlvRect r = graphic.boundingBox(mgr.getTopLevelTransformer());
            ViewUtil.ensureVisible(mgrView, r, forceCentered, repaint);
        }
    }

    public static void ensureVisible(IlvManagerView mgrView, IlvGraphicEnumeration graphics, boolean repaint) {
        ViewUtil.ensureVisible(mgrView, graphics, false, repaint);
    }

    public static void ensureVisible(IlvManagerView mgrView, IlvGraphicEnumeration graphics, boolean forceCentered, boolean repaint) {
        IlvManager rootManager = mgrView.getManager();
        IlvRect r = null;
        while (graphics.hasMoreElements()) {
            IlvGraphic g = graphics.nextElement();
            IlvManager mgr = ManagerUtil.getTransformingManager(g);
            if (mgr == null) continue;
            IlvTransformer tx = ManagerUtil.getConversionTransformer(rootManager, mgr);
            IlvRect bb = g.boundingBox(tx);
            if (r == null) {
                r = bb;
                continue;
            }
            r.add(bb);
        }
        if (r != null) {
            ViewUtil.ensureVisible(mgrView, r, forceCentered, repaint);
        }
    }

    public static boolean getVisibleBounds(IlvManagerView mgrView, IlvRect result) {
        Dimension viewSize = mgrView.getSize();
        result.setRect(0.0f, 0.0f, (float)viewSize.width, (float)viewSize.height);
        IlvTransformer transformer = mgrView.getTransformer();
        return transformer.inverse(result);
    }

    public static IlvPoint getCenterOfView(IlvManager mgr, IlvManagerView view) {
        Dimension viewSize = view.getSize();
        IlvRect r = new IlvRect(0.0f, 0.0f, (float)viewSize.width, (float)viewSize.height);
        IlvTransformer transformer = mgr.getDrawingTransformer(view);
        transformer.inverse(r);
        return new IlvPoint((float)r.getCenterX(), (float)r.getCenterY());
    }
}

