/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.oppparse;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.diagram.oppparse.OPPConnectionPoint;
import oracle.diagram.oppparse.OPPContainer;
import oracle.diagram.oppparse.OPPDiagramEdge;
import oracle.diagram.oppparse.OPPDiagramElement;
import oracle.diagram.oppparse.OPPDiagramShape;
import oracle.diagram.oppparse.OPPElementReference;
import oracle.diagram.oppparse.OPPParseConstants;
import oracle.diagram.oppparse.OPPParseUtil;
import oracle.diagram.oppparse.OPPShapeState;
import oracle.diagram.oppparse.OPPXMLElementAdapter;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.NodeList;

public final class OPPEdgeRoute
extends OPPXMLElementAdapter
implements OPPParseConstants {
    private final OPPDiagramEdge _parent;
    private final boolean _isSurrogateEntry;
    private final OPPElementReference _srcRef;
    private final OPPElementReference _dstRef;
    private boolean _originalRoute = false;
    private final List<Point2D> _points;
    private long _srcDrUID = -1L;
    private long _dstDrUID = -1L;
    private OPPDiagramShape _src = null;
    private OPPDiagramShape _dst = null;
    private OPPConnectionPoint _srcCP = null;
    private OPPConnectionPoint _dstCP = null;

    OPPEdgeRoute(OPPDiagramEdge parent, XMLElement xmlSource, boolean loadFromSurrogateTable) {
        super(xmlSource);
        this._parent = parent;
        this._isSurrogateEntry = loadFromSurrogateTable;
        XMLElement srcRef = null;
        XMLElement dstRef = null;
        NodeList points = null;
        if (!loadFromSurrogateTable) {
            srcRef = OPPParseUtil.getNamedChild(xmlSource, "elemRef", "sourceShapeRef");
            dstRef = OPPParseUtil.getNamedChild(xmlSource, "elemRef", "destinationShapeRef");
            XMLElement gd = OPPParseUtil.getNamedChild(xmlSource, "infoMap", "graphicalData");
            XMLElement pointContainer = OPPParseUtil.getNamedChild(gd, "array", "elementPoints");
            points = pointContainer.getChildrenByTagName("point");
        } else {
            srcRef = OPPParseUtil.getNamedChild(xmlSource, "elemRef", "surrogateSrcRef");
            dstRef = OPPParseUtil.getNamedChild(xmlSource, "elemRef", "surrogateDstRef");
            XMLElement pointContainer = OPPParseUtil.getNamedChild(xmlSource, "array", "surrogatePoints");
            points = pointContainer.getChildrenByTagName("point");
        }
        this._srcRef = (OPPElementReference)OPPParseUtil.parseTypedProperty(srcRef);
        this._dstRef = (OPPElementReference)OPPParseUtil.parseTypedProperty(dstRef);
        ArrayList<Point2D> pointList = new ArrayList<Point2D>(points.getLength());
        int isize = points.getLength();
        for (int i = 0; i < isize; ++i) {
            XMLElement point = (XMLElement)points.item(i);
            pointList.add((Point2D)OPPParseUtil.parseTypedProperty(point));
        }
        this._points = Collections.unmodifiableList(pointList);
    }

    public final boolean isSurrogateTableEntry() {
        return this._isSurrogateEntry;
    }

    public final OPPElementReference getSourceElementReference() {
        return this._srcRef;
    }

    public final OPPElementReference getDestinationElementReference() {
        return this._dstRef;
    }

    public final List<Point2D> getPoints() {
        return this._points;
    }

    public final boolean isActiveRoute() {
        return !this.isSurrogateTableEntry();
    }

    public final boolean isOriginalRoute() {
        return this._originalRoute;
    }

    public final long getSourceDrUID() {
        return this._srcDrUID;
    }

    public final long getDestinationDrUID() {
        return this._dstDrUID;
    }

    public final OPPDiagramShape getSource() {
        return this._src;
    }

    public final OPPDiagramShape getDestination() {
        return this._dst;
    }

    public final OPPConnectionPoint getSourceConnectionPoint() {
        return this._srcCP;
    }

    public final OPPConnectionPoint getDestinationConnectionPoint() {
        return this._dstCP;
    }

    final void setOriginalRoute(boolean original) {
        this._originalRoute = original;
    }

    final void setSourceDrUID(long druid) {
        this._srcDrUID = druid;
    }

    final void setDestinationDrUID(long druid) {
        this._dstDrUID = druid;
    }

    private void setShapeAndConnectionPointFromDrUID(long druid, boolean isSrc) {
        OPPDiagramElement end = this.getEdge().getContext().resolveDrUID(druid);
        if (end instanceof OPPConnectionPoint) {
            if (isSrc) {
                this._src = (OPPDiagramShape)end.getParent();
                this._srcCP = (OPPConnectionPoint)end;
            } else {
                this._dst = (OPPDiagramShape)end.getParent();
                this._dstCP = (OPPConnectionPoint)end;
            }
        } else if (isSrc) {
            this._src = (OPPDiagramShape)end;
            this._srcCP = null;
        } else {
            this._dst = (OPPDiagramShape)end;
            this._dstCP = null;
        }
    }

    void resolveShapeReferences() {
        if (this.isActiveRoute()) {
            this.setShapeAndConnectionPointFromDrUID(this._srcDrUID, true);
            this.setShapeAndConnectionPointFromDrUID(this._dstDrUID, false);
        } else {
            OPPEdgeRoute activeRoute = this.getEdge().getCurrentRoute();
            this._srcDrUID = this._srcRef.equals(activeRoute.getSourceElementReference()) ? activeRoute.getSourceDrUID() : this.guessDrUID(true);
            this.setShapeAndConnectionPointFromDrUID(this._srcDrUID, true);
            this._dstDrUID = this._dstRef.equals(activeRoute.getDestinationElementReference()) ? activeRoute.getDestinationDrUID() : this.guessDrUID(false);
            this.setShapeAndConnectionPointFromDrUID(this._dstDrUID, false);
        }
    }

    protected final OPPDiagramEdge getEdge() {
        return this._parent;
    }

    private final long guessDrUID(boolean src) {
        OPPDiagramShape s;
        OPPElementReference ref = src ? this.getSourceElementReference() : this.getDestinationElementReference();
        Collection<OPPDiagramElement> possibles = this.getEdge().getContext().getShapesWithReference(ref);
        if (possibles.size() == 1) {
            return possibles.iterator().next().getDrUID();
        }
        OPPEdgeRoute activeRoute = this.getEdge().getCurrentRoute();
        OPPDiagramShape oPPDiagramShape = s = src ? activeRoute.getSource() : activeRoute.getDestination();
        if (!this.isOriginalRoute()) {
            for (OPPContainer check = s.getParent(); check != null && check instanceof OPPDiagramShape; check = check.getParent()) {
                if (!check.getPrimaryElementReference().equals(ref)) continue;
                return ((OPPDiagramShape)check).getDrUID();
            }
        }
        if (s.getPrimaryElementReference().equals(ref)) {
            return s.getDrUID();
        }
        return this.guessDrUID(s, ref);
    }

    private final long guessDrUID(OPPDiagramShape s, OPPElementReference ref) {
        for (OPPDiagramShape i : s.getInternalShapes()) {
            if (!i.getPrimaryElementReference().equals(ref)) continue;
            return i.getDrUID();
        }
        for (OPPShapeState state : s.getAvailableStates()) {
            for (OPPDiagramShape oPPDiagramShape : s.getChildShapes(state)) {
                if (!oPPDiagramShape.getPrimaryElementReference().equals(ref)) continue;
                return oPPDiagramShape.getDrUID();
            }
        }
        for (OPPDiagramShape oPPDiagramShape : s.getInternalShapes()) {
            long result = this.guessDrUID(oPPDiagramShape, ref);
            if (result == -1L) continue;
            return result;
        }
        for (OPPShapeState oPPShapeState : s.getAvailableStates()) {
            for (OPPDiagramShape oPPDiagramShape : s.getChildShapes(oPPShapeState)) {
                long result = this.guessDrUID(oPPDiagramShape, ref);
                if (result == -1L) continue;
                return result;
            }
        }
        return -1L;
    }
}

