/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.palette.interactor;

import ilog.views.IlvGraphic;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.interactor.IlvRectangularObjectFactory;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import java.awt.Dimension;
import oracle.diagram.core.context.IdeContextPlugin;
import oracle.diagram.core.plugin.PluginUtil;
import oracle.diagram.framework.interaction.InPlaceEditPlugin;
import oracle.diagram.framework.palette.PaletteTask;
import oracle.diagram.res.UndoResource;
import oracle.diagram.sdm.context.SDMDiagramContextUtil;
import oracle.diagram.sdm.interaction.DefaultSDMInPlaceEditPlugin;
import oracle.diagram.sdm.model.SplittableSDMLink;
import oracle.diagram.sdm.palette.interactor.MakeSDMNodeInteractor;
import oracle.diagram.sdm.palette.interactor.PropertyInitializer;
import oracle.diagram.sdm.undo.SDMAddObjectCommand;
import oracle.diagram.sdm.undo.SDMEngineAdjustingCommand;
import oracle.diagram.sdm.undo.SDMEngineCommand;
import oracle.diagram.sdm.undo.SDMSetFromCommand;
import oracle.diagram.sdm.undo.SDMSetToCommand;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;

class SDMNodeFactory
implements IlvRectangularObjectFactory {
    private static final Dimension MIN_SIZE = new Dimension(30, 30);
    private static final Dimension PREFERRED_SIZE = new Dimension(120, 120);
    private static final String TASK_NAME = UndoResource.getBundle().getString("create.text");
    private String _undoTaskName;
    private final PaletteTask _task;
    private String _tag = null;
    private PropertyInitializer _initializer = null;
    private boolean _isGridMode;

    public SDMNodeFactory(PaletteTask task, String undoTaskName) {
        this._task = task;
        this._undoTaskName = undoTaskName;
        if (this._undoTaskName == null) {
            this._undoTaskName = TASK_NAME;
        }
        this.setGridMode(false);
    }

    public final String getTag() {
        return this._tag;
    }

    public final void setTag(String tag) {
        this._tag = tag;
    }

    public final void setPropertyInitializer(PropertyInitializer initializer) {
        this._initializer = initializer;
    }

    public final boolean isGridMode() {
        return this._isGridMode;
    }

    public final void setGridMode(boolean isGridMode) {
        this._isGridMode = isGridMode;
    }

    public final IlvSDMEngine getEngine() {
        return SDMDiagramContextUtil.getSDMEngine(this.getManagerView());
    }

    public final IlvManagerView getManagerView() {
        return this._task.getDiagramContext().getManagerView();
    }

    protected PaletteTask getPaletteTask() {
        return this._task;
    }

    public Dimension getMinimumSize() {
        return MIN_SIZE;
    }

    public Dimension getPreferredSize() {
        return PREFERRED_SIZE;
    }

    protected final void invokeCommand(Command cmd) {
        this.invokeCommand(cmd, true);
    }

    protected final void invokeCommand(Command cmd, boolean viaCmdProcessor) {
        Context context = this.getPaletteTask().getDiagramContext().getPlugin(IdeContextPlugin.class).getContext();
        cmd.setContext(context);
        try {
            if (viaCmdProcessor) {
                CommandProcessor.getInstance().invoke(cmd);
            } else {
                cmd.doit();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected boolean requiresModelUndo() {
        return true;
    }

    public IlvGraphic createObject(IlvRect ilvRect) {
        Object obj = this.createNode(ilvRect.x, ilvRect.y);
        return obj != null ? this.getEngine().getGraphic(obj, true) : null;
    }

    protected Object createNode(float x, float y) {
        IlvSDMEngine engine = this.getEngine();
        Object parent = null;
        if (engine.isDropToGroupEnabled()) {
            parent = engine.getParent(this.getManagerView(), x, y, true);
        }
        return this.createNode(x, y, parent, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createNode(float x, float y, Object parent, boolean allowLinkSplitAtPoint) {
        IlvSDMEngine engine = this.getEngine();
        IlvSDMModel model = engine.getModel();
        Object obj = null;
        CommandProcessor.getInstance().beginTrans(this._undoTaskName);
        this.invokeCommand(new SDMEngineAdjustingCommand(engine, true));
        try {
            IlvGraphic newGraphic;
            Object hit;
            obj = model.createNode(this.getTag());
            this.setNodeProperties(model, obj);
            IlvPoint viewPoint = new IlvPoint(x, y);
            this.getManagerView().getTransformer().apply(viewPoint);
            if (allowLinkSplitAtPoint && (hit = engine.getObject(viewPoint, this.getManagerView(), true)) != null && model.isLink(hit) && hit instanceof SplittableSDMLink && ((SplittableSDMLink)hit).canSplitLink(obj)) {
                Object link = model.createLink(model.getTag(hit));
                ((SplittableSDMLink)hit).afterSplit(model, link);
                Object prevTo = model.getTo(hit);
                this.invokeCommand(new SDMSetToCommand(model, hit, prevTo, obj), this.requiresModelUndo());
                this.invokeCommand(new SDMSetFromCommand(model, link, null, obj), this.requiresModelUndo());
                this.invokeCommand(new SDMSetToCommand(model, link, null, prevTo), this.requiresModelUndo());
                this.invokeCommand(new SDMAddObjectCommand(model, link, model.getParent(hit), null), this.requiresModelUndo());
            }
            this.invokeCommand(new SDMAddObjectCommand(model, obj, parent, null), this.requiresModelUndo());
            if (this.isGridMode() && this.getManagerView().getGrid() != null && (newGraphic = engine.getGraphic(obj, true)) != null) {
                IlvTransformer tfx = this.getManagerView().getTransformer();
                IlvRect bbox = newGraphic.boundingBox(tfx);
                viewPoint.translate(-bbox.width / 2.0f, -bbox.height / 2.0f);
                this.getManagerView().snapToGrid(viewPoint);
                viewPoint.translate(bbox.width / 2.0f, bbox.height / 2.0f);
                tfx.inverse(viewPoint);
                x = viewPoint.x;
                y = viewPoint.y;
            }
            final Object modelObj = obj;
            final float tmpX = x;
            final float tmpY = y;
            this.invokeCommand(new SDMEngineCommand(Ide.findOrCreateCmdID((String)(MakeSDMNodeInteractor.class.getName() + ".moveObject")), 0, "", engine){

                @Override
                protected int doitImpl() throws Exception {
                    this.getEngine().moveObject(modelObj, null, tmpX, tmpY, false, 5, true);
                    return 0;
                }

                @Override
                protected int undoImpl() throws Exception {
                    return 0;
                }
            }, this.requiresModelUndo());
        }
        finally {
            this.invokeCommand(new SDMEngineAdjustingCommand(engine, false));
        }
        return obj;
    }

    public void postAddNewNode(Object modelObject, boolean isAutoEditLabel) {
        this.getManagerView().getManager().deSelectAll(false);
        this.getEngine().deselectAllObjects();
        this.getEngine().setSelected(modelObject, true);
        if (isAutoEditLabel) {
            this.performLabelEdit(modelObject);
        } else {
            CommandProcessor.getInstance().endTrans();
        }
    }

    protected void performLabelEdit(Object modelObject) {
        InPlaceEditPlugin plugin = PluginUtil.getPlugin(this.getManagerView(), InPlaceEditPlugin.class);
        if (plugin instanceof DefaultSDMInPlaceEditPlugin) {
            DefaultSDMInPlaceEditPlugin sdmPlugin = (DefaultSDMInPlaceEditPlugin)plugin;
            sdmPlugin.performLabelEditAndEndTransaction(modelObject);
        } else {
            CommandProcessor.getInstance().endTrans();
        }
    }

    protected void setNodeProperties(IlvSDMModel model, Object object) {
        if (this._initializer != null) {
            this._initializer.initializeProperties(this.getPaletteTask().getPaletteItem(), model, object);
        }
    }
}

