/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.preference;

import ilog.views.sdm.IlvSDMModel;
import oracle.diagram.framework.preference.AbstractPreferenceStore;
import oracle.diagram.framework.preference.PreferenceDefinition;

public class SDMModelObjectPreferenceStoreAdapter
extends AbstractPreferenceStore {
    private static final String PREFIX = "sdm:oracle.diagram.";
    private final IlvSDMModel _model;
    private final Object _obj;

    public SDMModelObjectPreferenceStoreAdapter(IlvSDMModel model, Object object) {
        if (model == null) {
            throw new IllegalArgumentException("model must not be null");
        }
        this._model = model;
        if (object == null) {
            throw new IllegalArgumentException("object must not be null");
        }
        this._obj = object;
    }

    public final IlvSDMModel getModel() {
        return this._model;
    }

    public final Object getObject() {
        return this._obj;
    }

    @Override
    public boolean hasPreferenceValue(PreferenceDefinition preference) {
        String toSearch = SDMModelObjectPreferenceStoreAdapter.getStorageKey(preference);
        for (String s : this.getModel().getObjectPropertyNames(this.getObject())) {
            if (!toSearch.equals(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Object setPreferenceValueImpl(PreferenceDefinition preference, Object value) {
        Object old = this.getPreferenceValueImpl(preference);
        this.getModel().setObjectProperty(this.getObject(), SDMModelObjectPreferenceStoreAdapter.getStorageKey(preference), (Object)preference.getValueMarshaller().encodeValue(value));
        return old;
    }

    @Override
    protected Object getPreferenceValueImpl(PreferenceDefinition preference) {
        Object value = this.getModel().getObjectProperty(this.getObject(), SDMModelObjectPreferenceStoreAdapter.getStorageKey(preference));
        if (value != null) {
            return preference.getValueMarshaller().decodeValue(preference.getType(), (String)value);
        }
        return null;
    }

    protected static final String getStorageKey(PreferenceDefinition preference) {
        return PREFIX + preference.getStorageKey();
    }
}

