/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.hcs.HCSArb;
import oracle.hcs.actions.ActionConfirmPanel;
import oracle.hcs.actions.AlterHCSObjectDialog;
import oracle.hcs.actions.AlterHCSObjectHelper;
import oracle.hcs.db.HCSMetadataCache;
import oracle.hcs.db.MetadataChange;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public abstract class AbstractModifyHCSObjectAction
extends AbstractMenuAction {
    private AlterHCSObjectDialog actionDialog;
    protected AlterHCSObjectHelper actionHelper;
    private static final Logger LOG = Logger.getLogger(AbstractModifyHCSObjectAction.class.getName());
    private HCSSchema schema;
    private String schemaName;
    private String connectionName;

    protected abstract AlterHCSObjectHelper getHelper() throws Exception;

    protected abstract String getParentObjectName();

    protected abstract String getParentObjectType();

    protected abstract String getObjectName();

    public abstract String getType();

    protected abstract String getTitle(String var1);

    protected abstract String getProgressMessage();

    protected abstract ActionConfirmPanel getConfirmationPanel();

    protected abstract String getHelpID();

    public void launch() {
        String string = this.getProgressMessage();
        DBObject dBObject = this.getDBObject();
        if (dBObject != null) {
            this.setSchemaName(dBObject.getSchemaName());
            this.setConnectionName(dBObject.getConnectionName());
        }
        this.initSchema();
        if (!this.isDialogActionValid()) {
            return;
        }
        RaptorTask raptorTask = new RaptorTask(string, true, IRaptorTaskRunMode.MODAL){

            protected Object doWork() throws TaskException {
                Boolean bl = Boolean.TRUE;
                try {
                    AbstractModifyHCSObjectAction.this.actionHelper = AbstractModifyHCSObjectAction.this.getHelper();
                    ActionConfirmPanel actionConfirmPanel = AbstractModifyHCSObjectAction.this.getConfirmationPanel();
                    AbstractModifyHCSObjectAction.this.actionDialog = new AlterHCSObjectDialog((Frame)Ide.getMainWindow(), AbstractModifyHCSObjectAction.this.actionHelper.getTitle(), actionConfirmPanel, AbstractModifyHCSObjectAction.this.actionHelper, AbstractModifyHCSObjectAction.this.getHelpID());
                    actionConfirmPanel.setUpdatedObjectChangeListener(AbstractModifyHCSObjectAction.this.actionDialog);
                    AbstractModifyHCSObjectAction.this.actionDialog.setVisibleForceCreateOption(AbstractModifyHCSObjectAction.this.isVisibleForceCreateCheckBox());
                }
                catch (Exception exception) {
                    bl = Boolean.FALSE;
                    throw new TaskException((Throwable)exception);
                }
                return bl;
            }
        };
        raptorTask.setCancellable(false);
        raptorTask.setPausable(false);
        raptorTask.setMessage(string);
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Throwable throwable = raptorTaskEvent.getThrowable();
                        Logger.getLogger(this.getClass().getName()).severe(throwable.toString());
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        AbstractModifyHCSObjectAction.this.actionDialog.setModal(true);
                        AbstractModifyHCSObjectAction.this.actionDialog.setVisible(true);
                        if (AbstractModifyHCSObjectAction.this.actionDialog.getUserSelection() == 1) {
                            AbstractModifyHCSObjectAction.this.actionPostProcess();
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        });
        RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
        raptorTaskManager.addTask(raptorTask);
    }

    public void setSchemaName(String string) {
        this.schemaName = string;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setConnectionName(String string) {
        this.connectionName = string;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    protected void initSchema() {
        try {
            String string = this.getConnectionName();
            String string2 = this.getSchemaName();
            if (string != null && string2 != null) {
                this.schema = HCSMetadataCache.getUpdatedSchema(string, string2);
            }
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, exception.getMessage());
        }
    }

    protected void setSchema(HCSSchema hCSSchema) {
        this.schema = hCSSchema;
    }

    protected HCSSchema getSchema() {
        return this.schema;
    }

    protected boolean isDialogActionValid() {
        return true;
    }

    protected boolean isVisibleForceCreateCheckBox() {
        return false;
    }

    protected abstract void actionPostProcess();

    protected void recordMetadataChanges() {
        DBObject dBObject = this.getDBObject();
        Connection connection = dBObject.getConnection();
        String string = Connections.getInstance().getConnectionName(connection);
        String string2 = dBObject.getSchemaName();
        String string3 = dBObject.getObjectName();
        LinkedList linkedList = new LinkedList();
        String string4 = this.getType();
        HCSSyntaxType hCSSyntaxType = null;
        if (string4.equals("ATTRIBUTE DIMENSION")) {
            hCSSyntaxType = HCSSyntaxType.DIMENSION;
        } else if (string4.equals("HIERARCHY")) {
            hCSSyntaxType = HCSSyntaxType.HIERARCHY;
        } else if (string4.equals("ANALYTIC VIEW")) {
            hCSSyntaxType = HCSSyntaxType.ANALYTIC_VIEW;
        }
    }

    protected LinkedList<MetadataChange> getChanges(String string, HCSSyntaxType hCSSyntaxType) {
        LinkedList<MetadataChange> linkedList = new LinkedList<MetadataChange>();
        return linkedList;
    }

    protected void refreshNavigator(DBObject dBObject, String string) {
        ObjectAction objectAction = new ObjectAction();
        DBObject dBObject2 = null;
        if (string != null) {
            objectAction.setReloadParent(true);
            dBObject2 = this.createDBObjectToRefresh(dBObject, string);
        } else {
            objectAction.setReload(true);
            dBObject2 = dBObject;
        }
        ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback((ObjectAction)objectAction, (DBObject)dBObject2);
        objectActionPostProcess.run();
    }

    protected void refreshObjectsInNavigator(final String string, final DBObject dBObject) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractModifyHCSObjectAction.this.refreshParentObject(dBObject);
                List<DBObject> list = AbstractModifyHCSObjectAction.this.getDependentObjectsUrls(string, dBObject);
                for (DBObject dBObject2 : list) {
                    AbstractModifyHCSObjectAction.this.refreshNavigator(dBObject2, null);
                }
            }
        });
    }

    protected void refreshParentObject(DBObject dBObject) {
        this.refreshNavigator(dBObject, this.getParentObjectName());
    }

    protected List<DBObject> getDependentObjectsUrls(String string, DBObject dBObject) {
        URL uRL;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        String string2 = dBObject.getConnectionName();
        String string3 = dBObject.getSchemaName();
        if (string.equals("ATTRIBUTE DIMENSION")) {
            uRL = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)string2, (String)"", (String)string3, (String)"HIERARCHY");
            arrayList.add(new DBObject(uRL));
        }
        if (string.equals("ATTRIBUTE DIMENSION") || string.equals("HIERARCHY")) {
            uRL = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)string2, (String)"", (String)string3, (String)"ANALYTIC VIEW");
            arrayList.add(new DBObject(uRL));
        }
        return arrayList;
    }

    private DBObject createDBObjectToRefresh(DBObject dBObject, String string) {
        URL uRL = DBURLFormatHelper.getURL((String)dBObject.getURL().getProtocol(), (String)dBObject.getConnectionName(), (String)"", (String)dBObject.getSchemaName(), (String)this.getParentObjectType());
        uRL = DBURLFormatHelper.getURL((URL)uRL, (String)string);
        return new DBObject(uRL);
    }

    protected void showErrorDialog(String string) {
        String string2 = this.getObjectName();
        String string3 = this.getTitle(string2);
        String string4 = null;
        MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)string3, string4);
    }

    protected void showErrorDialog(String string, String string2) {
        String string3 = this.getTitle(string2);
        String string4 = null;
        MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)string3, string4);
    }

    protected void showErrorDialog(Throwable throwable) {
        String string = HCSArb.get("GENERIC_ERROR_TITLE");
        ExceptionHandler.handleException((Throwable)throwable);
    }
}

