/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.hcs.HCSArb;
import oracle.hcs.actions.HCSActionDDLPanel;
import oracle.hcs.table.Queries;
import oracle.hcs.util.JavaXMLBind;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class CompilationResultsPanel
extends JPanel {
    private JDialog compileResultsDialog;
    private String owner;
    private List<DBObject> dbObjectList;
    private ResultSetTable resultSetTable;
    private String resultsTableLabel;
    private static Queries queries;
    private static final String XMLFILE = "/oracle/hcs/actions/actionsQueries.xml";
    private static final String QUERIES_PACKAGE = "oracle.hcs.table";
    private static final String ATTR_DIMS_USER_ERRORS_QUERY = "attr_dims_user_errors_query";
    private static final String HIERS_USER_ERRORS_QUERY = "hiers_user_errors_query";
    private static final String AVS_USER_ERRORS_QUERY = "avs_user_errors_query";
    private static final String ATTR_DIM_USER_ERRORS_QUERY = "attr_dim_user_errors_query";
    private static final String HIER_USER_ERRORS_QUERY = "hier_user_errors_query";
    private static final String AV_USER_ERRORS_QUERY = "av_user_errors_query";
    private String valResultsQuery;
    private String objsType;
    private OracleDatabaseImpl db;
    private Connection conn;
    private String objNamesForQuery;
    private Logger Log = Logger.getLogger(CompilationResultsPanel.class.getName());

    public CompilationResultsPanel(String string, List<DBObject> list) {
        this(string, list, HCSArb.get("COMPILE_RESULTS_LABEL"));
    }

    public CompilationResultsPanel(String string, List<DBObject> list, String string2) {
        this.resultsTableLabel = string2;
        this.owner = string;
        this.dbObjectList = list;
        if (this.dbObjectList.size() > 0) {
            DBObject dBObject = this.dbObjectList.get(0);
            this.objsType = dBObject.getObjectType();
            this.db = (OracleDatabaseImpl)dBObject.getDatabase();
            this.conn = dBObject.getConnection();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (DBObject dBObject2 : list) {
                String string3 = String.format("'%s'", dBObject2.getObjectName());
                arrayList.add(string3);
            }
            this.objNamesForQuery = String.join((CharSequence)",", arrayList);
        }
        this.init();
        this.showValidationTableResults();
    }

    protected void setOwningDialog(JDialog jDialog) {
        this.compileResultsDialog = jDialog;
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = this.createValidationPanel();
        JPanel jPanel2 = this.createValidationSQLPanel();
        jTabbedPane.add((Component)jPanel, this.resultsTableLabel);
        jTabbedPane.add((Component)jPanel2, HCSArb.getString("ALTER_HCS_DIALOG_DDL_TAB_LABEL"));
        this.add((Component)jTabbedPane, gridBagConstraints);
        JButton jButton = new JButton(HCSArb.getString("HIERARCHY_VALIDATION_CLOSE_BUTTON"));
        gridBagConstraints.weighty = 0.0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        this.add((Component)jButton, gridBagConstraints);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CompilationResultsPanel.this.compileResultsDialog.dispose();
            }
        });
    }

    private JPanel createValidationPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 5, 0, 5);
        jPanel.add((Component)new JLabel(HCSArb.get("COMPILE_RESULTS_MSG")), gridBagConstraints);
        this.resultSetTable = new ResultSetTable();
        ++gridBagConstraints.gridy;
        this.resultSetTable.setSelectionMode(0);
        this.resultSetTable.setBackground(Color.WHITE);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView((Component)this.resultSetTable);
        this.resultSetTable.setFillsViewportHeight(true);
        jScrollPane.setBackground(Color.WHITE);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 5, 5);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        return jPanel;
    }

    private JPanel createValidationSQLPanel() {
        HCSActionDDLPanel hCSActionDDLPanel = new HCSActionDDLPanel();
        this.valResultsQuery = this.getValidationResultsQuery(this.objNamesForQuery);
        hCSActionDDLPanel.setDDLText(this.valResultsQuery);
        return hCSActionDDLPanel;
    }

    private String getValidationResultsQuery(String string) {
        String string2 = null;
        if (this.dbObjectList.size() == 1) {
            if (this.objsType.equals("ATTRIBUTE DIMENSION")) {
                string2 = this.getQuery(ATTR_DIM_USER_ERRORS_QUERY);
            } else if (this.objsType.equals("HIERARCHY")) {
                string2 = this.getQuery(HIER_USER_ERRORS_QUERY);
            } else if (this.objsType.equals("ANALYTIC VIEW")) {
                string2 = this.getQuery(AV_USER_ERRORS_QUERY);
            }
        } else if (this.objsType.equals("ATTRIBUTE DIMENSION")) {
            string2 = this.getQuery(ATTR_DIMS_USER_ERRORS_QUERY);
        } else if (this.objsType.equals("HIERARCHY")) {
            string2 = this.getQuery(HIERS_USER_ERRORS_QUERY);
        } else if (this.objsType.equals("ANALYTIC VIEW")) {
            string2 = this.getQuery(AVS_USER_ERRORS_QUERY);
        }
        string2 = String.format(string2, string);
        string2 = string2.replace(":OWNER", "'" + this.owner + "'");
        return string2;
    }

    public void showValidationTableResults() {
        try {
            String string = this.db.getQualifiedName();
            this.resultSetTable.setQuery(string, this.valResultsQuery, null, null);
            this.resultSetTable.refresh();
            this.resultSetTable.allRowsFetched();
        }
        catch (Exception exception) {
            this.Log.log(Level.SEVERE, exception.getMessage());
        }
    }

    private String getQuery(String string) {
        if (queries == null) {
            try {
                String string2 = QUERIES_PACKAGE;
                String string3 = JavaXMLBind.LoadDocument(this.getClass(), XMLFILE);
                JavaXMLBind.BindToJavaStr(string3, string2, this);
            }
            catch (Exception exception) {
                this.Log.log(Level.WARNING, exception.getLocalizedMessage(), exception);
            }
        }
        return queries.getSQL(string);
    }

    public void addQueries(Queries queries) {
        CompilationResultsPanel.queries = queries;
    }
}

