/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.RaptorDBAddin;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.hcs.HCSArb;
import oracle.hcs.actions.BaseRunnable;
import oracle.hcs.av.model.AVDimensionality;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.model.AbstractMappableSchemaObjectWithDesc;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.util.SchemaRunnable;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.javatools.dialogs.MessageDialog;

public class DDLDependenciesContextMenu
implements ContextMenuListener {
    private HCSSchema schema;
    private Connection conn;
    private StringBuilder ddl;
    private String owner;
    private HashSet<String> existingObjects;
    private final String ATTRIBUTE_DIMENSION_TYPE = "ATTRIBUTE_DIMENSION";
    private final String HIERARCHY_TYPE = "HIERARCHY";
    private final String ANALYTIC_VIEW_TYPE = "ANALYTIC_VIEW";
    private final String LINE_SEPARATOR = "\n----------------------------------------------------------------\n";
    private final String HEADER = "-- %s %s DDL";
    private final String SQL_EXTENSION = ".sql";
    private final String SEMICOLON = ";";
    private static final Logger LOG = Logger.getLogger(DDLDependenciesContextMenu.class.getName());

    public void menuWillShow(ContextMenu contextMenu) {
        Element[] elementArray = contextMenu.getContext().getSelection();
        if (elementArray != null && elementArray.length > 0) {
            final ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<DBObject> arrayList2 = new ArrayList<DBObject>();
            boolean bl = false;
            for (Element object2 : elementArray) {
                DBObject dBObject = new DBObject(object2);
                String string = dBObject.getObjectType();
                if (string == null) {
                    return;
                }
                if (string.equals("ATTRIBUTE DIMENSION") || string.equals("ANALYTIC VIEW")) {
                    bl = true;
                    arrayList.add(dBObject);
                    continue;
                }
                if (string.equals("HIERARCHY")) {
                    arrayList2.add(dBObject);
                    continue;
                }
                return;
            }
            if (arrayList2.size() > 0) {
                arrayList.addAll(arrayList2);
            }
            if (bl) {
                Object object;
                this.ddl = new StringBuilder();
                try {
                    object = new SchemaRunnable(((DBObject)arrayList.get(0)).getConnectionName(), ((DBObject)arrayList.get(0)).getSchemaName());
                    ProgressBar progressBar = new ProgressBar((Component)Ide.getMainWindow(), HCSArb.getString("SCHEMA_LOADING_PROGRESS_TITLE"), (Runnable)object, true);
                    progressBar.setCancelable(false);
                    ((BaseRunnable)object).setProgressBar(progressBar);
                    progressBar.start(HCSArb.getString("SCHEMA_LOADING_PROGRESS_MESSAGE"), null);
                    if (((BaseRunnable)object).getException() != null) {
                        throw ((BaseRunnable)object).getException();
                    }
                    this.schema = ((SchemaRunnable)object).getSchema();
                }
                catch (Exception exception) {
                    LOG.log(Level.SEVERE, exception.getMessage());
                }
                this.conn = ((DBObject)arrayList.get(0)).getConnection();
                this.owner = ((DBObject)arrayList.get(0)).getSchemaName();
                this.existingObjects = new HashSet();
                object = new JMenu(HCSArb.get("DDL_DEPENDENCIES_MENU_TITLE"));
                JMenuItem jMenuItem = new JMenuItem(HCSArb.get("DDL_DEPENDENCIES_SAVE_TO_FILE"));
                JMenuItem jMenuItem2 = new JMenuItem(HCSArb.get("DDL_DEPENDENCIES_SAVE_TO_WORKSHEET"));
                JMenuItem jMenuItem3 = new JMenuItem(HCSArb.get("DDL_DEPENDENCIES_SAVE_TO_CLIPBOARD"));
                ((JMenu)object).add(jMenuItem);
                ((JMenu)object).add(jMenuItem2);
                ((JMenu)object).add(jMenuItem3);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DDLDependenciesContextMenu.this.createDependenciesDDL(arrayList);
                        DDLDependenciesContextMenu.this.saveToFile();
                    }
                });
                jMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DDLDependenciesContextMenu.this.createDependenciesDDL(arrayList);
                        RaptorDBAddin.getSqlOpener().openNewEditor(DDLDependenciesContextMenu.this.ddl.toString(), Connections.getInstance().getConnectionName(DDLDependenciesContextMenu.this.conn));
                    }
                });
                jMenuItem3.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DDLDependenciesContextMenu.this.createDependenciesDDL(arrayList);
                        Transferable transferable = new Transferable(){

                            @Override
                            public DataFlavor[] getTransferDataFlavors() {
                                return new DataFlavor[]{DataFlavor.stringFlavor};
                            }

                            @Override
                            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                                return dataFlavor == DataFlavor.stringFlavor || dataFlavor == DataFlavor.plainTextFlavor;
                            }

                            @Override
                            public Object getTransferData(DataFlavor dataFlavor) {
                                return DDLDependenciesContextMenu.this.ddl.toString();
                            }
                        };
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferable, null);
                    }
                });
                contextMenu.add((Component)object);
            }
        }
    }

    private void createDependenciesDDL(List<DBObject> list) {
        for (DBObject dBObject : list) {
            String string;
            AbstractMappableSchemaObjectWithDesc abstractMappableSchemaObjectWithDesc;
            String string2 = dBObject.getObjectType();
            if (string2.equalsIgnoreCase("ATTRIBUTE DIMENSION") && (abstractMappableSchemaObjectWithDesc = this.schema.findDimension(string = dBObject.getObjectName())) != null) {
                this.addObjectDDL(string, "ATTRIBUTE_DIMENSION", "ATTRIBUTE DIMENSION");
                this.createDimensionDependenciesDDL((AttributeDimension)abstractMappableSchemaObjectWithDesc);
            }
            if (string2.equalsIgnoreCase("HIERARCHY")) {
                string = dBObject.getObjectName();
                this.addObjectDDL(string, "HIERARCHY", "HIERARCHY");
            }
            if (!string2.equalsIgnoreCase("ANALYTIC VIEW") || (abstractMappableSchemaObjectWithDesc = this.schema.findAV(string = dBObject.getObjectName())) == null) continue;
            this.createAnalyticViewDependenciesDDL((AnalyticView)abstractMappableSchemaObjectWithDesc);
            this.addHeader(abstractMappableSchemaObjectWithDesc.getName(), "ANALYTIC VIEW");
            this.ddl.append(this.getDDL(dBObject.getObjectName(), this.owner, "ANALYTIC_VIEW"));
        }
    }

    private void createDimensionDependenciesDDL(AttributeDimension attributeDimension) {
        List<Hierarchy> list = this.schema.getHierarchies(attributeDimension);
        for (Hierarchy hierarchy : list) {
            String string = hierarchy.getName();
            this.addObjectDDL(string, "HIERARCHY", "HIERARCHY");
        }
    }

    private void createAnalyticViewDependenciesDDL(AnalyticView analyticView) {
        for (AVDimensionality aVDimensionality : analyticView.getDimensions()) {
            AttributeDimension attributeDimension = aVDimensionality.getDimension();
            if (attributeDimension != null) {
                AVHierarchy[] aVHierarchyArray = attributeDimension.getName();
                this.addObjectDDL((String)aVHierarchyArray, "ATTRIBUTE_DIMENSION", "ATTRIBUTE DIMENSION");
            }
            for (AVHierarchy aVHierarchy : aVDimensionality.getHierarchies()) {
                Hierarchy hierarchy = aVHierarchy.getHierarchy();
                if (hierarchy == null) continue;
                String string = hierarchy.getName();
                this.addObjectDDL(string, "HIERARCHY", "HIERARCHY");
            }
        }
    }

    private void addObjectDDL(String string, String string2, String string3) {
        if (!this.existingObjects.contains(string)) {
            this.addHeader(string, string3);
            this.ddl.append(this.getDDL(string, this.owner, string2));
            this.existingObjects.add(string);
        }
    }

    private void addHeader(String string, String string2) {
        this.ddl.append("\n----------------------------------------------------------------\n");
        this.ddl.append(String.format("-- %s %s DDL", string2, string));
        this.ddl.append("\n----------------------------------------------------------------\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDDL(String string, String string2, String string3) {
        int n;
        Object object;
        String string4 = "";
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)this.conn);
            object = new HashMap<String, String>();
            object.put("owner", string2);
            object.put("objName", string);
            object.put("type", string3);
            String string5 = "select DBMS_METADATA.GET_DDL(:type, :objName, :owner) from dual";
            Connections.getInstance().lock(this.conn);
            string4 = dBUtil.executeReturnOneCol(string5, (Map)object);
            SQLException sQLException = dBUtil.getLastException();
            if (sQLException != null) {
                throw sQLException;
            }
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, sQLException.getLocalizedMessage(), sQLException);
        }
        finally {
            Connections.getInstance().unlock(this.conn);
        }
        if (string4.length() > 0 && !((String)(object = string4.substring(n = string4.length() - 1))).equals(";")) {
            string4 = String.format("%s;", string4);
        }
        return string4;
    }

    private void saveToFile() {
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.setSelectionScope(2);
        uRLFileChooser.setSelectionMode(0);
        DefaultURLFilter defaultURLFilter = new DefaultURLFilter(HCSArb.get("SQL_SCRIPTS_TITLE"), "sql");
        uRLFileChooser.clearChooseableURLFilters();
        uRLFileChooser.setURLFilter((URLFilter)defaultURLFilter);
        int n = uRLFileChooser.showSaveDialog((Component)Ide.getMainWindow());
        if (n == 0) {
            try {
                File file = uRLFileChooser.getSelectedFile();
                String string = file.getCanonicalPath();
                if (this.validateSaveToFile(file) != 0) {
                    return;
                }
                if (string.indexOf(".sql") == -1) {
                    string = String.format("%s%s", string, ".sql");
                }
                BufferedWriter bufferedWriter = Files.newBufferedWriter(Paths.get(string, new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);
                bufferedWriter.write(this.ddl.toString());
                bufferedWriter.close();
                Editor editor = EditorManager.getEditorManager().openDefaultEditorInFrame(URLFactory.newFileURL((String)string));
                editor.open();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private int validateSaveToFile(File file) {
        if (!file.exists()) {
            return 0;
        }
        boolean bl = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)HCSArb.get("DDL_DEPENDENCIES_OVERWRITE_CONFIRM_MSSG"), (String)HCSArb.get("DDL_DEPENDENCIES_OVERWRITE_CONFIRM_TITLE"), null);
        if (!bl) {
            return 1;
        }
        return 0;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }
}

