/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.actions.DDLBasedActionsHelper;
import oracle.hcs.actions.DescriptionParentObjects;
import oracle.hcs.db.MetadataChange;
import oracle.hcs.db.model.AbstractSchemaObjectWithDesc;
import oracle.hcs.db.model.Descriptions;
import oracle.hcs.db.model.NamedObject;
import oracle.hcs.db.panels.HCSCompileDDLGenerator;
import oracle.hcs.db.panels.HCSDDLPanel;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public abstract class ModifyObjectsPropertiesHelper
extends DDLBasedActionsHelper {
    private Map<String, DescriptionParentObjects> descTopParentObjs;
    private HCSSchema schema;
    private Database db;
    private DBObjectProvider prov;
    private String diffProperty;
    private HCSSyntaxType objType;
    private static final String HEADER_COMMENT = "/* - - - - - - - - - - - - - - - %s - - - - - - - - - - - - - - - */";
    private HCSCompileDDLGenerator compileStatementsGenerator;
    private final Logger LOG = Logger.getLogger(ModifyObjectsPropertiesHelper.class.getName());

    public ModifyObjectsPropertiesHelper(HCSSchema hCSSchema, Map<String, DescriptionParentObjects> map, Database database, String string, HCSSyntaxType hCSSyntaxType) {
        super(database);
        this.schema = hCSSchema;
        this.db = database;
        this.prov = database;
        this.descTopParentObjs = map;
        this.diffProperty = string;
        this.objType = hCSSyntaxType;
        this.compileStatementsGenerator = new HCSCompileDDLGenerator();
        this.setOriginalDescParentObjects(map);
    }

    protected void setOriginalDescParentObjects(Map<String, DescriptionParentObjects> map) {
    }

    protected Map<String, DescriptionParentObjects> getDescParentObjects() {
        return this.descTopParentObjs;
    }

    protected DBObjectProvider getProvider() {
        return this.prov;
    }

    @Override
    protected Collection<String> createSqlStatements() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.descTopParentObjs.keySet()) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            DescriptionParentObjects descriptionParentObjects = this.descTopParentObjs.get(string);
            Descriptions descriptions = descriptionParentObjects.getOriginalDescParentObj();
            Descriptions descriptions2 = descriptionParentObjects.getUpdatedDescParentObj();
            SystemObject systemObject = (SystemObject)descriptions;
            SystemObject systemObject2 = (SystemObject)descriptions2;
            String string2 = systemObject2.getName();
            DBEditorConfig dBEditorConfig = DBEditorConfig.newEditConfig((DBObjectProvider)this.db, (DBObject)systemObject);
            dBEditorConfig.setUpdatedObject(systemObject2);
            dBEditorConfig.setOriginalObject(systemObject);
            dBEditorConfig.setReplaceAllowed(true);
            HCSDDLPanel.printDiff(dBEditorConfig, false);
            arrayList2.addAll(HCSDDLPanel.getSQLStatements(dBEditorConfig));
            if (arrayList2.size() <= 0) continue;
            String string3 = String.format(HEADER_COMMENT, string);
            arrayList.add(string3);
            arrayList.addAll(arrayList2);
            this.addAlterCompileSqlStatements(arrayList, dBEditorConfig, string2);
        }
        return arrayList;
    }

    private void addAlterCompileSqlStatements(Collection<String> collection, DBEditorConfig dBEditorConfig, String string) {
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)dBEditorConfig.getProvider();
        String string2 = dBEditorConfig.getSchema().getName();
        List<AbstractSchemaObjectWithDesc> list = this.getCompileDependencies(string2, oracleDatabaseImpl, string);
        this.compileStatementsGenerator.clearCompileStatements();
        List<String> list2 = this.compileStatementsGenerator.generateCompileStatements(list);
        collection.addAll(list2);
    }

    protected List<AbstractSchemaObjectWithDesc> getCompileDependencies(String string, OracleDatabaseImpl oracleDatabaseImpl, String string2) {
        return Collections.EMPTY_LIST;
    }

    @Override
    protected void recordMetadataChanges() {
        if (!this.getStatements().isEmpty()) {
            for (String string : this.descTopParentObjs.keySet()) {
                DescriptionParentObjects descriptionParentObjects = this.descTopParentObjs.get(string);
                Descriptions descriptions = descriptionParentObjects.getOriginalDescParentObj();
                Descriptions descriptions2 = descriptionParentObjects.getUpdatedDescParentObj();
                Difference difference = this.getProvider().getDiffEngine().difference((Object)descriptions, (Object)descriptions2);
                NamedObject namedObject = (NamedObject)((Object)descriptions2);
                Connection connection = this.db.getConnection();
                String string2 = Connections.getInstance().getConnectionName(connection);
                Difference difference2 = difference.getChildDifference(this.diffProperty, false);
                MetadataChange metadataChange = null;
                if (difference2 != null && difference2.getChildren() != null && difference2.getChildren().size() > 0) {
                    for (Difference difference3 : difference2.getChildren()) {
                        if (difference3.isSame()) continue;
                        metadataChange = new MetadataChange(namedObject.getName(), difference3.getPropertyName(), this.objType);
                        this.recordMetadataChange(metadataChange, string2, this.schema.getName());
                    }
                    continue;
                }
                if (difference == null || difference.isSame()) continue;
                metadataChange = new MetadataChange(namedObject.getName(), this.objType);
                this.recordMetadataChange(metadataChange, string2, this.schema.getName());
            }
        }
    }

    protected void recordMetadataChange(MetadataChange metadataChange, String string, String string2) {
        this.LOG.finest(String.format("recording change for %s", metadataChange.getObjectName()));
    }

    @Override
    protected SystemObject getOriginalObject() {
        return null;
    }

    @Override
    protected SystemObject getUpdatedObject() {
        return null;
    }

    @Override
    protected void modifyObjects() {
    }

    @Override
    public void setForceCreate(boolean bl) {
        for (String string : this.getDescParentObjects().keySet()) {
            DescriptionParentObjects descriptionParentObjects = this.getDescParentObjects().get(string);
            AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc = (AbstractSchemaObjectWithDesc)descriptionParentObjects.getUpdatedDescParentObj();
            abstractSchemaObjectWithDesc.setForceCreate(bl);
        }
    }
}

