/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AVCalculatedMeasure;
import oracle.hcs.av.model.AVDimensionality;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.av.model.AVMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.av.model.cache.AVCacheLevelGroup;
import oracle.hcs.av.model.cache.AVCacheLevelGroupDimHierLevel;
import oracle.hcs.av.model.cache.AVCacheMeasureGroup;
import oracle.hcs.av.model.cache.AVCacheMeasureGroupMeasure;
import oracle.hcs.db.model.AbstractAVDBObjectBuilder;
import oracle.hcs.util.FeatureMap;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class AVBuilder
extends AbstractAVDBObjectBuilder<AnalyticView> {
    protected static final String AMERICAN = "AMERICAN";
    private static final String DESCRIPTION = "DESCRIPTION";
    private static final String CAPTION = "CAPTION";
    private boolean supportDistinct;

    public AVBuilder(OracleDatabaseImpl oracleDatabaseImpl) {
        super((AbstractDBObjectProvider)oracleDatabaseImpl, "ANALYTIC VIEW");
    }

    protected boolean canBuildComponents() {
        return true;
    }

    public AnalyticView createObject(String string, Schema schema, DBObjectID dBObjectID) {
        AnalyticView analyticView = new AnalyticView();
        analyticView.setName(string);
        analyticView.setSchema(schema);
        analyticView.setID(dBObjectID);
        return analyticView;
    }

    @AbstractDBObjectBuilder.PropertyBuilder(value={"description", "caption", "measures", "calculatedMeasures", "dimensions", "dimensionNames", "defaultMeasure", "consistentSolveSpec", "sharing"})
    public void build(final AnalyticView analyticView) throws DBException {
        analyticView.removeAllDimensions();
        analyticView.removeAllMeasures();
        analyticView.removeAllCalculatedMeasures();
        analyticView.setForceCreate(true);
        String string = Connections.getInstance().getConnectionName((Database)((OracleDatabaseImpl)this.getProvider()));
        if (FeatureMap.getInstance().isSupported(string, "REFERENCES_DISTINCT")) {
            this.supportDistinct = true;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT dty.dimension_name, dty.dimension_alias, dty.dimension_type, ky.av_key_column, ky.ref_dimension_attr, dty.order_num");
        if (this.supportDistinct) {
            stringBuilder.append(", dty.references_distinct");
        }
        stringBuilder.append("\n FROM all_analytic_view_dimensions dty, all_analytic_view_keys ky \n");
        stringBuilder.append("WHERE dty.analytic_view_name = ? AND dty.owner = ?\n");
        stringBuilder.append(" and dty.owner = ky.owner and dty.analytic_view_name = ky.analytic_view_name and dty.dimension_alias = ky.dimension_alias\n");
        stringBuilder.append(" ORDER BY dty.order_num, ky.order_num");
        final QueryWrapper queryWrapper = new QueryWrapper((Database)this.getProvider(), stringBuilder.toString(), new Object[]{analyticView.getName(), analyticView.getSchema()});
        final QueryWrapper queryWrapper2 = new QueryWrapper((Database)this.getProvider(), "SELECT cd.dimension_alias, hier_name, hier_alias, is_default\nFROM all_analytic_view_hiers ch, all_analytic_view_dimensions cd\nwhere ch.dimension_alias = cd.dimension_alias and ch.owner = cd.owner \nand ch.analytic_view_name = cd.analytic_view_name \nand ch.analytic_view_name = ? AND ch.owner = ? ORDER BY ch.owner, ch.order_num", new Object[]{analyticView.getName(), analyticView.getSchema()});
        final QueryWrapper queryWrapper3 = new QueryWrapper((Database)this.getProvider(), "select meas.measure_name,meas.table_alias, meas.column_name, meas.aggr_function, columns.data_type, meas.order_num from all_analytic_view_base_meas meas left join all_analytic_view_columns columns on meas.owner = columns.owner and meas.analytic_view_name = columns.analytic_view_name and meas.measure_name = columns.column_name and columns.dimension_name is null and columns.hier_name = 'MEASURES' where meas.analytic_view_name = ? and meas.owner = ? order by meas.order_num", new Object[]{analyticView.getName(), analyticView.getSchema()});
        QueryWrapper queryWrapper4 = new QueryWrapper((Database)this.getProvider(), "select measure_name,classification, value, language from all_analytic_view_meas_class  where analytic_view_name = ? and owner = ?  order by measure_name,language,classification", new Object[]{analyticView.getName(), analyticView.getSchema()});
        final QueryWrapper queryWrapper5 = new QueryWrapper((Database)this.getProvider(), "select measure_name, meas_expression from all_analytic_view_calc_meas where analytic_view_name = ? and owner = ? order by order_num", new Object[]{analyticView.getName(), analyticView.getSchema()});
        final QueryWrapper queryWrapper6 = new QueryWrapper((Database)this.getProvider(), "select classification, value, language from all_analytic_view_class  where analytic_view_name = ? and owner = ? order by language,classification", new Object[]{analyticView.getName(), analyticView.getSchema()});
        final QueryWrapper queryWrapper7 = new QueryWrapper((Database)this.getProvider(), "select cache_type, dimension_alias, hier_alias, level_name, measure_name, av_lvlgrp_order from all_analytic_view_lvlgrps where analytic_view_name = ? and owner = ? order by av_lvlgrp_order, level_meas_order", new Object[]{analyticView.getName(), analyticView.getSchema()});
        final QueryWrapper queryWrapper8 = new QueryWrapper((Database)this.getProvider(), "select dimension_alias, classification, value, language from all_analytic_view_dim_class  where analytic_view_name = ? and owner = ? order by language,classification", new Object[]{analyticView.getName(), analyticView.getSchema()});
        final QueryWrapper queryWrapper9 = new QueryWrapper((Database)this.getProvider(), " select sharing from all_objects  where object_type = ? and object_name = ? and owner = ?", new Object[]{analyticView.getType(), analyticView.getName(), analyticView.getSchema()});
        queryWrapper3.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        String string3 = resultSet.getString(3);
                        String string4 = resultSet.getString(4);
                        String string5 = resultSet.getString(5);
                        int n = resultSet.getInt(6);
                        if (string5 == null) {
                            string5 = "NUMBER";
                        }
                        AVMeasure aVMeasure = new AVMeasure(string);
                        aVMeasure.setMapExpression(string3);
                        aVMeasure.setConsistentSolveSpec(string4);
                        aVMeasure.setMeasureOrder(Integer.toString(n));
                        if (string5.equals("NUMBER")) {
                            aVMeasure.setNumeric(true);
                        }
                        analyticView.addMeasure(aVMeasure);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper3.throwDBException((DBObject)analyticView, sQLException);
                }
            }
        });
        queryWrapper5.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        AVCalculatedMeasure aVCalculatedMeasure = new AVCalculatedMeasure(string);
                        analyticView.addCalculatedMeasure(aVCalculatedMeasure);
                        aVCalculatedMeasure.setMeasureExpression(string2);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper5.throwDBException((DBObject)analyticView, sQLException);
                }
            }
        });
        queryWrapper4.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    AbstractAVDBObjectBuilder.LanguageDescriptionsCount languageDescriptionsCount = new AbstractAVDBObjectBuilder.LanguageDescriptionsCount(AVBuilder.this);
                    languageDescriptionsCount.setDescriptionsCount(0);
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        String string3 = resultSet.getString(3);
                        string3 = string3 != null ? string3.trim() : "";
                        String string4 = resultSet.getString(4);
                        AVMeasure aVMeasure = analyticView.findMeasure(string);
                        if (aVMeasure != null) {
                            if (string2.equalsIgnoreCase(AVBuilder.CAPTION) || string2.equalsIgnoreCase(AVBuilder.DESCRIPTION) || string4 != null) {
                                AVBuilder.this.processLanguageDescriptions(languageDescriptionsCount, string4, string2, string3, aVMeasure, aVMeasure);
                                continue;
                            }
                            AVBuilder.this.setClassification(aVMeasure, string2, string3, string4);
                            continue;
                        }
                        AVCalculatedMeasure aVCalculatedMeasure = analyticView.findCalculatedMeasure(string);
                        if (aVCalculatedMeasure == null) continue;
                        if (string2.equalsIgnoreCase(AVBuilder.CAPTION) || string2.equalsIgnoreCase(AVBuilder.DESCRIPTION) || string4 != null) {
                            AVBuilder.this.processLanguageDescriptions(languageDescriptionsCount, string4, string2, string3, aVCalculatedMeasure, aVCalculatedMeasure);
                            continue;
                        }
                        AVBuilder.this.setClassification(aVCalculatedMeasure, string2, string3, string4);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper3.throwDBException((DBObject)analyticView, sQLException);
                }
            }
        });
        queryWrapper.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        String string3 = resultSet.getString(3);
                        String string4 = resultSet.getString(4);
                        String string5 = resultSet.getString(5);
                        int n = resultSet.getInt(6);
                        AVDimensionality aVDimensionality = analyticView.findDimensionalityForAlias(string2);
                        if (aVDimensionality != null) {
                            aVDimensionality.addMapExpression(string4);
                            aVDimensionality.addMappedDimension(string5);
                            continue;
                        }
                        aVDimensionality = new AVDimensionality();
                        aVDimensionality.setName(string);
                        aVDimensionality.setDimensionalityName(string);
                        aVDimensionality.setDimensionAlias(string2);
                        aVDimensionality.setPhysicalOrder(n);
                        String[] stringArray = new String[]{string4};
                        aVDimensionality.setMapExpressions(stringArray);
                        String[] stringArray2 = new String[]{string5};
                        aVDimensionality.setMappedDimensions(stringArray2);
                        if (AVBuilder.this.supportDistinct) {
                            String string6 = resultSet.getString(7);
                            boolean bl = string6.equals("Y");
                            aVDimensionality.setDistinct(bl);
                        }
                        analyticView.addDimensionality(aVDimensionality);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper.throwDBException((DBObject)analyticView, sQLException);
                }
            }
        });
        queryWrapper2.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        String string3 = resultSet.getString(3);
                        String string4 = resultSet.getString(4);
                        AVDimensionality aVDimensionality = analyticView.findDimensionalityForAlias(string);
                        AVHierarchy aVHierarchy = new AVHierarchy();
                        aVHierarchy.setName(string2);
                        aVHierarchy.setHierarchyName(string2);
                        aVHierarchy.setHierarchyAlias(string3);
                        Boolean bl = Boolean.FALSE;
                        if (string4.equalsIgnoreCase("Y")) {
                            bl = Boolean.TRUE;
                        }
                        aVHierarchy.setHierarchyIncluded(Boolean.TRUE);
                        aVHierarchy.setHierarchyDefault(bl);
                        aVDimensionality.addHierarchy(aVHierarchy);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper2.throwDBException((DBObject)analyticView, sQLException);
                }
            }
        });
        queryWrapper6.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    AVBuilder.this.processClassificationsResultSet(analyticView, analyticView, resultSet);
                }
                catch (SQLException sQLException) {
                    queryWrapper6.throwDBException((DBObject)analyticView, sQLException);
                }
            }
        });
        queryWrapper7.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    boolean bl = false;
                    boolean bl2 = false;
                    String string = null;
                    int n = 0;
                    ArrayList<AVCacheMeasureGroup> arrayList = new ArrayList<AVCacheMeasureGroup>();
                    AVCacheMeasureGroup aVCacheMeasureGroup = null;
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    ArrayList<String> arrayList3 = new ArrayList<String>();
                    ArrayList<LevelNameAndState> arrayList4 = new ArrayList<LevelNameAndState>();
                    while (resultSet.next()) {
                        String string2 = resultSet.getString(1);
                        string2 = "MATERIALIZED";
                        AVCacheMeasureGroup[] aVCacheMeasureGroupArray = resultSet.getString(2);
                        String string3 = resultSet.getString(3);
                        String string4 = resultSet.getString(4);
                        String object = resultSet.getString(5);
                        int n2 = resultSet.getInt(6);
                        if (!bl) {
                            bl = true;
                            n = n2;
                            string = string2;
                            aVCacheMeasureGroup = new AVCacheMeasureGroup();
                            arrayList.add(aVCacheMeasureGroup);
                        }
                        if (n == n2) {
                            if (string4 == null || string4.isEmpty()) {
                                arrayList3.add(object);
                                continue;
                            }
                            if (string3 == null || string3.isEmpty()) {
                                arrayList4.add(new LevelNameAndState(string4, 3));
                                continue;
                            }
                            if (aVCacheMeasureGroupArray == null || aVCacheMeasureGroupArray.isEmpty()) {
                                arrayList4.add(new LevelNameAndState(string3 + "." + string4, 2));
                                continue;
                            }
                            arrayList4.add(new LevelNameAndState((String)aVCacheMeasureGroupArray + "." + string3 + "." + string4, 1));
                            continue;
                        }
                        if (!bl2) {
                            bl2 = true;
                            AVBuilder.this.addMeasuresToCacheMeasureGroup(arrayList3, aVCacheMeasureGroup, false);
                        } else {
                            boolean bl3 = false;
                            if (arrayList2.size() != arrayList3.size()) {
                                bl3 = true;
                            } else {
                                for (String string5 : arrayList3) {
                                    if (arrayList2.contains(string5)) continue;
                                    bl3 = true;
                                    break;
                                }
                            }
                            if (bl3) {
                                aVCacheMeasureGroup = new AVCacheMeasureGroup();
                                arrayList.add(aVCacheMeasureGroup);
                                AVBuilder.this.addMeasuresToCacheMeasureGroup(arrayList3, aVCacheMeasureGroup, false);
                            }
                        }
                        arrayList2.clear();
                        for (String string6 : arrayList3) {
                            arrayList2.add(string6);
                        }
                        AVBuilder.this.addLevelsToCacheMeasureGroup(string, arrayList4, aVCacheMeasureGroup);
                        arrayList3.clear();
                        arrayList4.clear();
                        n = n2;
                        string = string2;
                        if (string4 == null || string4.isEmpty()) {
                            arrayList3.add(object);
                            continue;
                        }
                        if (string3 == null || string3.isEmpty()) {
                            arrayList4.add(new LevelNameAndState(string4, 3));
                            continue;
                        }
                        if (aVCacheMeasureGroupArray == null || aVCacheMeasureGroupArray.isEmpty()) {
                            arrayList4.add(new LevelNameAndState(string3 + "." + string4, 2));
                            continue;
                        }
                        arrayList4.add(new LevelNameAndState((String)aVCacheMeasureGroupArray + "." + string3 + "." + string4, 1));
                    }
                    if (bl) {
                        if (!bl2) {
                            bl2 = true;
                            AVBuilder.this.addMeasuresToCacheMeasureGroup(arrayList3, aVCacheMeasureGroup, false);
                        } else {
                            boolean bl4 = false;
                            if (arrayList2.size() != arrayList3.size()) {
                                bl4 = true;
                            } else {
                                for (String string3 : arrayList3) {
                                    if (arrayList2.contains(string3)) continue;
                                    bl4 = true;
                                    break;
                                }
                            }
                            if (bl4) {
                                aVCacheMeasureGroup = new AVCacheMeasureGroup();
                                arrayList.add(aVCacheMeasureGroup);
                                AVBuilder.this.addMeasuresToCacheMeasureGroup(arrayList3, aVCacheMeasureGroup, false);
                            }
                        }
                        AVBuilder.this.addLevelsToCacheMeasureGroup(string, arrayList4, aVCacheMeasureGroup);
                        AVCacheMeasureGroup[] aVCacheMeasureGroupArray = arrayList.toArray(new AVCacheMeasureGroup[0]);
                        analyticView.setCacheMeasureGroups(aVCacheMeasureGroupArray);
                        for (AVCacheMeasureGroup aVCacheMeasureGroup2 : aVCacheMeasureGroupArray) {
                            if (analyticView.getMeasures().length != aVCacheMeasureGroup2.getCacheMeasureGroupMeasures().length) continue;
                            arrayList3.clear();
                            arrayList3.add("ALL");
                            AVBuilder.this.addMeasuresToCacheMeasureGroup(arrayList3, aVCacheMeasureGroup2, true);
                        }
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper7.throwDBException((DBObject)analyticView, sQLException);
                }
            }
        });
        queryWrapper8.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        String string3 = resultSet.getString(3);
                        String string4 = resultSet.getString(4);
                        AVDimensionality aVDimensionality = analyticView.findDimensionalityForAlias(string);
                        if (string2.equalsIgnoreCase(AVBuilder.CAPTION) || string2.equalsIgnoreCase(AVBuilder.DESCRIPTION)) {
                            AVBuilder.this.setDescription(aVDimensionality, string2, string3);
                            continue;
                        }
                        AVBuilder.this.setClassification(aVDimensionality, string2, string3, string4);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper8.throwDBException((DBObject)analyticView, sQLException);
                }
            }
        });
        queryWrapper9.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    while (resultSet.next()) {
                        String string = resultSet.getString(1);
                        analyticView.setSharing(AVBuilder.this.getSharing(string));
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper9.throwDBException((DBObject)analyticView, sQLException);
                }
            }
        });
        String string2 = "select table_owner, table_name, default_measure, default_aggr from all_analytic_views aav join all_objects ao on aav.owner = ao.owner and aav.analytic_view_name = ao.object_name where ao.object_type = 'ANALYTIC VIEW' and analytic_view_name = ? and aav.owner = ?  ";
        final QueryWrapper queryWrapper10 = new QueryWrapper((Database)this.getProvider(), string2, new Object[]{analyticView.getName(), analyticView.getSchema()});
        queryWrapper10.executeQuery(new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet resultSet) throws DBException {
                try {
                    if (resultSet.next()) {
                        String string = resultSet.getString(1);
                        String string2 = resultSet.getString(2);
                        analyticView.setavSourceTableOwner(string);
                        analyticView.setavSourceTable(string2);
                        String string3 = resultSet.getString(3);
                        String string4 = resultSet.getString(4);
                        AVBaseMeasure aVBaseMeasure = analyticView.findBaseMeasure(string3);
                        if (aVBaseMeasure != null) {
                            aVBaseMeasure.setDefaultMeasure(true);
                            analyticView.setDefaultMeasure(aVBaseMeasure.getName());
                        }
                        analyticView.setConsistentSolveSpec(string4);
                    }
                }
                catch (SQLException sQLException) {
                    queryWrapper10.throwDBException((DBObject)analyticView, sQLException);
                }
            }
        });
    }

    private void addMeasuresToCacheMeasureGroup(List<String> list, AVCacheMeasureGroup aVCacheMeasureGroup, boolean bl) {
        ArrayList<AVCacheMeasureGroupMeasure> arrayList = new ArrayList<AVCacheMeasureGroupMeasure>();
        for (String string : list) {
            AVCacheMeasureGroupMeasure aVCacheMeasureGroupMeasure = new AVCacheMeasureGroupMeasure(string);
            if (bl) {
                aVCacheMeasureGroupMeasure.setCacheMeasureGroupAllActive(true);
                aVCacheMeasureGroup.setCacheMeasureGroupAllSelected(true);
            } else {
                aVCacheMeasureGroupMeasure.setCacheMeasureGroupAllActive(false);
                aVCacheMeasureGroup.setCacheMeasureGroupAllSelected(false);
            }
            arrayList.add(aVCacheMeasureGroupMeasure);
        }
        aVCacheMeasureGroup.setCacheMeasureGroupMeasures(arrayList.toArray(new AVCacheMeasureGroupMeasure[0]));
    }

    private void addLevelsToCacheMeasureGroup(String string, List<LevelNameAndState> list, AVCacheMeasureGroup aVCacheMeasureGroup) {
        AVCacheLevelGroup aVCacheLevelGroup = new AVCacheLevelGroup();
        aVCacheLevelGroup.setCacheLevelGroupProcessMode(string);
        ArrayList<AVCacheLevelGroupDimHierLevel> arrayList = new ArrayList<AVCacheLevelGroupDimHierLevel>();
        for (LevelNameAndState levelNameAndState : list) {
            AVCacheLevelGroupDimHierLevel aVCacheLevelGroupDimHierLevel = new AVCacheLevelGroupDimHierLevel(levelNameAndState.name, levelNameAndState.state);
            arrayList.add(aVCacheLevelGroupDimHierLevel);
        }
        aVCacheLevelGroup.setCacheLevelGroupHierLevels(arrayList.toArray(new AVCacheLevelGroupDimHierLevel[0]));
        aVCacheMeasureGroup.addCacheLevelGroup(aVCacheLevelGroup);
    }

    private static class LevelNameAndState {
        public String name;
        public int state;

        public LevelNameAndState(String string, int n) {
            this.name = string;
            this.state = n;
        }
    }
}

