/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.db.source.DatabaseSource;
import oracle.hcs.db.source.SourceMetadata;
import oracle.hcs.table.Queries;
import oracle.hcs.util.JavaXMLBind;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class AVDimensionalityWorker
extends SwingWorker<List<DerivedDimensionality>, Void> {
    private static final Logger LOG = Logger.getLogger(AVDimensionalityWorker.class.getName());
    private OracleDatabaseImpl db;
    private DatabaseSource source;
    private List<DerivedDimensionality> dimensionality;
    private static Queries queries;
    private static final String XMLFILE = "/oracle/hcs/av/avqueries.xml";
    private static final String DIM_NAME = "dimension_name";
    private static final String TABLE_NAME = "table_name";
    private static final String COLUMN_NAME = "column_name";
    private static final String HIERARCHY_COUNT = "hierarchy_count";
    private static final String LEVEL_COUNT = "level_count";
    private static final String DIMENSIONALITY_FROM_FK = "dimensionalityFromFK";
    private static final String SOURCE_PARAM = "source";
    private static final String QUERIES_PACKAGE = "oracle.hcs.table";
    private SourceMetadata sourceMetadata;

    public AVDimensionalityWorker(OracleDatabaseImpl oracleDatabaseImpl, DatabaseSource databaseSource) {
        this.db = oracleDatabaseImpl;
        this.source = databaseSource;
        this.dimensionality = new ArrayList<DerivedDimensionality>();
        this.sourceMetadata = new SourceMetadata("sourcequeries.xml", oracleDatabaseImpl.getConnection());
    }

    @Override
    public List<DerivedDimensionality> doInBackground() {
        String string = this.getQuery(DIMENSIONALITY_FROM_FK);
        Connection connection = this.db.getConnection();
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        Map<Object, Object> map = new HashMap();
        map = this.sourceMetadata.getSourceInformation(this.source);
        Connections.getInstance().lock(connection);
        ResultSet resultSet = dBUtil.executeQuery(string, map);
        if (resultSet != null) {
            try {
                while (resultSet.next()) {
                    String string2 = resultSet.getString(DIM_NAME);
                    String string3 = resultSet.getString(TABLE_NAME);
                    String string4 = resultSet.getString(COLUMN_NAME);
                    int n = resultSet.getInt(HIERARCHY_COUNT);
                    int n2 = resultSet.getInt(LEVEL_COUNT);
                    this.dimensionality.add(new DerivedDimensionality(string2, string3, string4, n, n2));
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        DBUtil.closeResultSet((ResultSet)resultSet);
        Connections.getInstance().unlock(connection);
        this.removeDuplicates();
        return this.dimensionality;
    }

    private void removeDuplicates() {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (DerivedDimensionality object2 : this.dimensionality) {
            object = object2.getTable();
            if (hashSet2.add((String)object)) continue;
            hashSet.add((String)object);
        }
        for (String string : hashSet) {
            object = new ArrayList();
            for (DerivedDimensionality derivedDimensionality : this.dimensionality) {
                if (!derivedDimensionality.getTable().equalsIgnoreCase(string)) continue;
                object.add(derivedDimensionality);
            }
            this.dimensionality.removeAll((Collection<?>)object);
            Object object2 = (DerivedDimensionality)object.get(0);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                DerivedDimensionality derivedDimensionality = (DerivedDimensionality)iterator.next();
                if (derivedDimensionality.getHierarchyCount() < ((DerivedDimensionality)object2).getHierarchyCount()) continue;
                if (derivedDimensionality.getHierarchyCount() == ((DerivedDimensionality)object2).getHierarchyCount()) {
                    if (derivedDimensionality.getLevelCount() <= ((DerivedDimensionality)object2).getLevelCount()) continue;
                    object2 = derivedDimensionality;
                    continue;
                }
                object2 = derivedDimensionality;
            }
            this.dimensionality.add((DerivedDimensionality)object2);
        }
    }

    private String getQuery(String string) {
        if (queries == null) {
            try {
                String string2 = QUERIES_PACKAGE;
                System.out.println(this.getClass().getPackage());
                String string3 = JavaXMLBind.LoadDocument(this.getClass(), XMLFILE);
                JavaXMLBind.BindToJavaStr(string3, string2, this);
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, exception.getLocalizedMessage(), exception);
            }
        }
        return queries.getSQL(string);
    }

    public void addQueries(Queries queries) {
        AVDimensionalityWorker.queries = queries;
    }

    public class DerivedDimensionality {
        private String dimension;
        private String table;
        private String column;
        private int hierarchyCount;
        private int levelCount;

        public DerivedDimensionality(String string, String string2, String string3, int n, int n2) {
            this.dimension = string;
            this.table = string2;
            this.column = string3;
            this.hierarchyCount = n;
            this.levelCount = n2;
        }

        public String getDimension() {
            return this.dimension;
        }

        public String getTable() {
            return this.table;
        }

        public String getColumn() {
            return this.column;
        }

        public int getHierarchyCount() {
            return this.hierarchyCount;
        }

        public int getLevelCount() {
            return this.levelCount;
        }
    }
}

