/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Stack;
import javax.swing.tree.TreeNode;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AVCalculatedMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.templates.syntaxparser.ParseNode;
import oracle.hcs.templates.syntaxparser.SyntaxParser;
import oracle.hcs.util.NameProvider;
import oracle.hcs.util.UIStringUtils;

public class CalcReferences {
    public static final String MEASURE_TYPE = "MEASURE";
    public static final String HIERARCHY_TYPE = "HIERARCHY";

    public static List<AVBaseMeasure> getDependencies(HCSSchema hCSSchema, String string, String string2, SyntaxParser syntaxParser) {
        return CalcReferences.getDependencies(hCSSchema, string, string2, syntaxParser, true);
    }

    public static List<AVBaseMeasure> getDependencies(HCSSchema hCSSchema, String string, String string2, SyntaxParser syntaxParser, boolean bl) {
        ArrayList<AVBaseMeasure> arrayList = new ArrayList<AVBaseMeasure>();
        NameProvider nameProvider = NameProvider.getInstance();
        AnalyticView analyticView = hCSSchema.findAV(string);
        if (analyticView != null) {
            AVBaseMeasure aVBaseMeasure = analyticView.findBaseMeasure(string2);
            Stack<AVBaseMeasure> stack = new Stack<AVBaseMeasure>();
            stack.push(aVBaseMeasure);
            while (!stack.isEmpty()) {
                AVBaseMeasure aVBaseMeasure2 = (AVBaseMeasure)stack.pop();
                if (aVBaseMeasure2 == null) continue;
                String string3 = nameProvider.getExternalName(aVBaseMeasure2.getName());
                String string4 = aVBaseMeasure2.getAV().getName();
                List<AVBaseMeasure> list = analyticView.getStoredAndCalculatedMeasures();
                for (AVBaseMeasure aVBaseMeasure3 : list) {
                    if (!aVBaseMeasure3.isDerived()) continue;
                    ParseNode parseNode = new ParseNode();
                    if (!syntaxParser.parseSyntax(aVBaseMeasure3.getExpression(), parseNode)) continue;
                    Enumeration<TreeNode> enumeration = parseNode.breadthFirstEnumeration();
                    while (enumeration.hasMoreElements()) {
                        String string5;
                        ParseNode parseNode2 = (ParseNode)enumeration.nextElement();
                        if (parseNode2.getType() == null || !parseNode2.getType().equalsIgnoreCase(MEASURE_TYPE)) continue;
                        String string6 = string5 = String.valueOf(parseNode2.getUserObject());
                        String string7 = string;
                        if (!CalcReferences.equals(string3, string6, nameProvider) || !string4.equals(string7)) continue;
                        if (!arrayList.contains(aVBaseMeasure3)) {
                            arrayList.add(aVBaseMeasure3);
                        }
                        if (!bl) continue;
                        stack.push(aVBaseMeasure3);
                    }
                }
            }
        }
        return arrayList;
    }

    static boolean equals(String string, String string2, NameProvider nameProvider) {
        if (string.equals(string2)) {
            return true;
        }
        if (UIStringUtils.isQuotedName(string)) {
            if (!string.equals(string2)) {
                return false;
            }
        } else {
            if (UIStringUtils.isQuotedName(string2)) {
                return string.equals(nameProvider.getInternalName(string2));
            }
            if (string.equalsIgnoreCase(string2)) {
                return true;
            }
        }
        return false;
    }

    public static List<AVBaseMeasure> getDependenciesForHierarchyAlias(AnalyticView analyticView, String string, SyntaxParser syntaxParser) {
        ArrayList<AVBaseMeasure> arrayList = new ArrayList<AVBaseMeasure>();
        if (analyticView != null) {
            List<AVBaseMeasure> list = analyticView.getStoredAndCalculatedMeasures();
            for (AVBaseMeasure aVBaseMeasure : list) {
                if (!aVBaseMeasure.isDerived()) continue;
                ParseNode parseNode = new ParseNode();
                if (!syntaxParser.parseSyntax(aVBaseMeasure.getExpression(), parseNode)) continue;
                Enumeration<TreeNode> enumeration = parseNode.breadthFirstEnumeration();
                while (enumeration.hasMoreElements()) {
                    String string2;
                    String string3;
                    ParseNode parseNode2 = (ParseNode)enumeration.nextElement();
                    if (parseNode2.getType() == null || !parseNode2.getType().equalsIgnoreCase(HIERARCHY_TYPE) || !string.equals(string3 = (string2 = String.valueOf(parseNode2.getUserObject()))) || arrayList.contains(aVBaseMeasure)) continue;
                    arrayList.add(aVBaseMeasure);
                }
            }
        }
        return arrayList;
    }

    public static List<AVBaseMeasure> getReferences(AVCalculatedMeasure aVCalculatedMeasure, SyntaxParser syntaxParser) {
        if (aVCalculatedMeasure == null) {
            return Collections.emptyList();
        }
        ArrayList<AVBaseMeasure> arrayList = new ArrayList<AVBaseMeasure>();
        AnalyticView analyticView = aVCalculatedMeasure.getAV();
        Stack<AVBaseMeasure> stack = new Stack<AVBaseMeasure>();
        stack.push(aVCalculatedMeasure);
        while (!stack.isEmpty()) {
            AVBaseMeasure aVBaseMeasure = (AVBaseMeasure)stack.pop();
            ParseNode parseNode = new ParseNode();
            if (!aVBaseMeasure.isDerived() || !syntaxParser.parseSyntax(aVBaseMeasure.getExpression(), parseNode)) continue;
            Enumeration<TreeNode> enumeration = parseNode.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                ParseNode parseNode2 = (ParseNode)enumeration.nextElement();
                if (parseNode2.getType() == null || !parseNode2.getType().equalsIgnoreCase(MEASURE_TYPE)) continue;
                String string = String.valueOf(parseNode2.getUserObject());
                String string2 = null;
                AVBaseMeasure aVBaseMeasure2 = null;
                string2 = string;
                aVBaseMeasure2 = analyticView.findBaseMeasure(string2);
                if (aVBaseMeasure2 == null) continue;
                arrayList.add(aVBaseMeasure2);
                if (!aVBaseMeasure2.isDerived()) continue;
                stack.push(aVBaseMeasure2);
            }
        }
        return arrayList;
    }
}

