/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.hcs.HCSArb;
import oracle.hcs.av.model.AVMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.av.panels.AVAggregationPanel;
import oracle.hcs.av.panels.aggregation.AggregationSyntaxChecker;
import oracle.ide.Ide;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.dialogs.MessageDialog;

public class AVMeasureAggregationPanel
extends AVAggregationPanel {
    private static final Logger LOG = Logger.getLogger(AVMeasureAggregationPanel.class.getName());
    private JComboBox measureComboBox;
    private DefaultComboBoxModel measureComboBoxModel;
    private JCheckBox useAVAggChkBox;
    private AVMeasure[] measures;
    private Map<String, String> mapMeasureCSS;
    private boolean isPanelEnabled;
    private String currentMeasureName;
    private ItemListener measureComboBoxItemListener;
    private OracleDatabaseImpl oraDb;

    @Override
    protected int getBuilderSetting() {
        return 2;
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        AnalyticView analyticView = (AnalyticView)this.getUpdatedObject();
        String string = analyticView.getConsistentSolveSpec();
        this.oraDb = (OracleDatabaseImpl)this.getProvider();
        this.mapMeasureCSS = new HashMap<String, String>();
        this.measureComboBox.removeItemListener(this.measureComboBoxItemListener);
        this.useAVAggChkBox.setSelected(true);
        this.measureComboBoxModel.removeAllElements();
        this.measures = analyticView.getMeasures();
        if (this.measures.length > 0) {
            for (AVMeasure aVMeasure : this.measures) {
                this.mapMeasureCSS.put(aVMeasure.getName(), aVMeasure.getConsistentSolveSpec());
                this.measureComboBoxModel.addElement(aVMeasure.getName());
            }
            this.measureComboBox.setSelectedIndex(0);
            AVMeasure aVMeasure = this.measures[0];
            String string2 = aVMeasure.getConsistentSolveSpec();
            if (string2 != null && string2.length() > 0) {
                string = string2;
                this.useAVAggChkBox.setSelected(false);
            }
            this.syntaxBuilder.setEnabled(true);
            string = this.extractConsistentSolveExpression(string);
            this.syntaxBuilder.setText(string);
            this.syntaxBuilder.setEnabled(!this.useAVAggChkBox.isSelected());
            this.syntaxBuilder.setEnabled(false);
            this.syntaxBuilder.setBottomMarginEnabled(!this.useAVAggChkBox.isSelected());
            this.currentMeasureName = aVMeasure.getName();
        }
        this.setEnablePanel(this.measures.length > 0);
        this.measureComboBox.addItemListener(this.measureComboBoxItemListener);
    }

    @Override
    protected void commitPanel() throws TraversalException {
        if (this.isPanelEnabled) {
            this.saveMeasureCSS(this.currentMeasureName);
            for (AVMeasure aVMeasure : this.measures) {
                String string = aVMeasure.getName();
                String string2 = this.mapMeasureCSS.get(string);
                aVMeasure.setConsistentSolveSpec(string2);
            }
        }
    }

    private void validateConsistentSolveSpec(String string) throws TraversalException {
        AnalyticView analyticView = (AnalyticView)this.getUpdatedObject();
        AggregationSyntaxChecker aggregationSyntaxChecker = new AggregationSyntaxChecker(analyticView);
        String string2 = null;
        string2 = aggregationSyntaxChecker.isValid(string);
        if (string2 != null) {
            throw new TraversalException(string2);
        }
    }

    @Override
    protected void layoutComponents(int n) {
        JLabel jLabel = new JLabel(HCSArb.get("AGGREGATION_RULES_DESC"));
        jLabel.setName("aggOperatorLabel");
        JLabel jLabel2 = new JLabel(HCSArb.get("MEASURE_AGGREGATION_RULES_HIER_DESC"));
        jLabel2.setName("aggHierarchyLabel");
        JLabel jLabel3 = new JLabel(HCSArb.get("MEASURE_AGGREGATION_RULES_MEASURE_LABEL"));
        jLabel3.setName("measureLabel");
        this.measureComboBoxModel = new DefaultComboBoxModel();
        this.measureComboBox = new JComboBox(this.measureComboBoxModel);
        this.measureComboBox.setName("measureComboBox");
        this.measureComboBoxItemListener = new ItemListener(){
            private boolean resetItem = false;

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (!this.resetItem) {
                    AnalyticView analyticView = (AnalyticView)AVMeasureAggregationPanel.this.getUpdatedObject();
                    String string = (String)AVMeasureAggregationPanel.this.measureComboBox.getSelectedItem();
                    if (AVMeasureAggregationPanel.this.currentMeasureName != null && string != null && !string.equalsIgnoreCase(AVMeasureAggregationPanel.this.currentMeasureName)) {
                        try {
                            AVMeasureAggregationPanel.this.saveMeasureCSS(AVMeasureAggregationPanel.this.currentMeasureName);
                        }
                        catch (Exception exception) {
                            String string2 = exception.getLocalizedMessage();
                            String string3 = HCSArb.get("MEASURE_AGGREGATION_RULES_ERROR_TITLE");
                            if (string2 == null || string2.length() == 0) {
                                string2 = exception.getClass().toString();
                            }
                            LOG.log(Level.SEVERE, exception.getMessage(), exception);
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)string3, null);
                            this.resetItem = true;
                            string = AVMeasureAggregationPanel.this.currentMeasureName;
                            AVMeasureAggregationPanel.this.measureComboBox.getModel().setSelectedItem(string);
                            return;
                        }
                    }
                    String string4 = AVMeasureAggregationPanel.this.mapMeasureCSS.get(string);
                    AVMeasureAggregationPanel.this.syntaxBuilder.setEnabled(true);
                    if (string4 != null && string4.length() > 0) {
                        AVMeasureAggregationPanel.this.useAVAggChkBox.setSelected(false);
                    } else {
                        string4 = analyticView.getConsistentSolveSpec();
                        AVMeasureAggregationPanel.this.useAVAggChkBox.setSelected(true);
                    }
                    string4 = AVMeasureAggregationPanel.this.extractConsistentSolveExpression(string4);
                    AVMeasureAggregationPanel.this.syntaxBuilder.setText(string4);
                    AVMeasureAggregationPanel.this.syntaxBuilder.setEnabled(!AVMeasureAggregationPanel.this.useAVAggChkBox.isSelected());
                    AVMeasureAggregationPanel.this.syntaxBuilder.setEnabled(false);
                    AVMeasureAggregationPanel.this.syntaxBuilder.setBottomMarginEnabled(!AVMeasureAggregationPanel.this.useAVAggChkBox.isSelected());
                    AVMeasureAggregationPanel.this.currentMeasureName = string;
                }
                this.resetItem = false;
            }
        };
        this.measureComboBox.addItemListener(this.measureComboBoxItemListener);
        this.useAVAggChkBox = new JCheckBox(HCSArb.get("MEASURE_AGGREGATION_RULES_USE_AV_AGG"), true);
        this.useAVAggChkBox.setName("useAVAggChkBox");
        this.useAVAggChkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = AVMeasureAggregationPanel.this.useAVAggChkBox.isSelected();
                if (bl) {
                    AnalyticView analyticView = (AnalyticView)AVMeasureAggregationPanel.this.getUpdatedObject();
                    String string = analyticView.getConsistentSolveSpec();
                    string = AVMeasureAggregationPanel.this.extractConsistentSolveExpression(string);
                    AVMeasureAggregationPanel.this.syntaxBuilder.setText(string);
                    String string2 = (String)AVMeasureAggregationPanel.this.measureComboBox.getSelectedItem();
                    try {
                        AVMeasureAggregationPanel.this.saveMeasureCSS(string2);
                    }
                    catch (Exception exception) {
                        String string3 = exception.getLocalizedMessage();
                        String string4 = HCSArb.get("MEASURE_AGGREGATION_RULES_ERROR_TITLE");
                        if (string3 == null || string3.length() == 0) {
                            string3 = exception.getClass().toString();
                        }
                        LOG.log(Level.SEVERE, exception.getMessage(), exception);
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)string3, (String)string4, null);
                    }
                }
                AVMeasureAggregationPanel.this.syntaxBuilder.setEnabled(!bl);
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        jPanel.add((Component)this.measureComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 0, 5), 0, 0));
        jPanel.add((Component)this.useAVAggChkBox, new GridBagConstraints(0, 1, 2, 1, 0.5, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(jPanel, new GridBagConstraints(0, n, 1, 1, 0.5, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        super.layoutComponents(++n);
    }

    private void saveMeasureCSS(String string) throws TraversalException {
        AnalyticView analyticView = (AnalyticView)this.getOriginalObject();
        if (string != null) {
            String string2;
            AVMeasure aVMeasure;
            if (!this.useAVAggChkBox.isSelected()) {
                AVMeasure aVMeasure2;
                String string3 = null;
                String string4 = null;
                if (analyticView != null && (aVMeasure2 = analyticView.findMeasure(string)) != null) {
                    string3 = aVMeasure2.getConsistentSolveSpec();
                }
                string4 = this.getConsistentSolveSpec(string3);
                this.validateConsistentSolveSpec(string4);
                this.mapMeasureCSS.put(string, string4);
            } else if (analyticView != null && (aVMeasure = analyticView.findMeasure(string)) != null && (string2 = aVMeasure.getConsistentSolveSpec()) != null) {
                this.mapMeasureCSS.put(string, null);
            }
        }
    }

    private void setEnablePanel(boolean bl) {
        this.isPanelEnabled = bl;
        this.measureComboBox.setEnabled(bl);
        this.useAVAggChkBox.setEnabled(bl);
    }

    private String extractConsistentSolveExpression(String string) {
        String string2 = null;
        if (string != null) {
            string2 = string;
            string2 = string2.trim();
        }
        return string2;
    }
}

