/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av.panels.aggregation;

import java.awt.Component;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.HCSArb;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.av.panels.aggregation.AggSpecInsertionHandlerHelper;
import oracle.hcs.av.panels.aggregation.AggregationSyntaxChecker;
import oracle.hcs.av.panels.aggregation.HCSAggregationSpec;
import oracle.hcs.db.HCSMetadataCache;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.syntaxbuilder.HCSSyntaxParser;
import oracle.hcs.syntaxbuilder.SyntaxBuilderLauncher;
import oracle.hcs.syntaxbuilder.SyntaxBuilderPanel;
import oracle.hcs.syntaxbuilder.WrappedSyntaxParser;
import oracle.hcs.syntaxbuilder.editor.SyntaxChecker;
import oracle.hcs.templates.templatedialog.TemplateHelperFactoryImpl;
import oracle.hcs.util.HCSErrorDisplay;
import oracle.hcs.util.HCSFetchIcon;
import oracle.hcs.util.HCSResources;
import oracle.ide.Ide;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class AggregationBuilder {
    private static final Logger LOG = Logger.getLogger(AggregationBuilder.class.getName());
    private AnalyticView analyticView;
    private SyntaxBuilderPanel builder;
    private Properties props;
    private TemplateHelperFactoryImpl thf;
    private OracleDatabaseImpl oraDB;
    private HCSSyntaxParser parser;
    private HCSAggregationSpec specParser;
    private HCSSchema schema;
    public static final String AGGREGATE_BY = "AGGREGATE BY %s";

    public SyntaxBuilderPanel createBuilder() throws SQLException, IOException {
        this.props = new Properties();
        this.props.setProperty("SHOW_LEAVES", Boolean.toString(false));
        this.props.setProperty("VISIBLE_SYNTAXSPEC", Boolean.toString(false));
        this.props.setProperty("VISIBLE_DOCS", Boolean.toString(false));
        this.props.setProperty("CENTER_DIVIDER_POSITION", "70");
        this.props.setProperty("ONECLICK_TEMPLATE_DISPLAY", Boolean.toString(true));
        this.props.setProperty("VISIBLE_SYNTAXDETAIL", Boolean.toString(false));
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(this.getClass().getResourceAsStream("aggregationspec.xml"), "UTF-8");
            this.parser = new WrappedSyntaxParser(null, this.props, AGGREGATE_BY);
            HCSResources hCSResources = new HCSResources("/oracle/hcs/av/panels/aggregation/aggregationtemplates.xml");
            HCSFetchIcon hCSFetchIcon = new HCSFetchIcon();
            this.thf = new TemplateHelperFactoryImpl(this.props, null, this.parser, hCSResources, hCSFetchIcon);
            this.specParser = new HCSAggregationSpec(this.props, inputStreamReader, this.parser, this.thf, new HCSErrorDisplay(), hCSResources, hCSFetchIcon, null);
            AggSpecInsertionHandlerHelper aggSpecInsertionHandlerHelper = new AggSpecInsertionHandlerHelper();
            this.builder = SyntaxBuilderLauncher.createPanelForAV(this.props, null, null, null, null, this.parser, this.thf, this.specParser, null, aggSpecInsertionHandlerHelper);
            SyntaxChecker syntaxChecker = new SyntaxChecker(){

                @Override
                public String isValid(String string) {
                    String string2 = null;
                    String string3 = null;
                    string2 = String.format(AggregationBuilder.AGGREGATE_BY, string);
                    AggregationSyntaxChecker aggregationSyntaxChecker = new AggregationSyntaxChecker(AggregationBuilder.this.analyticView);
                    string3 = aggregationSyntaxChecker.isValid(string2);
                    return string3;
                }
            };
            this.builder.addSyntaxChecker(syntaxChecker);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            HCSErrorDisplay hCSErrorDisplay = new HCSErrorDisplay();
            hCSErrorDisplay.show(unsupportedEncodingException, HCSArb.getString("EXPRESSION_EDITOR_SPEC_ERROR_TITLE"), HCSArb.getString("EXPRESSIONBUILDER_SPEC_ERROR_MESSAGE"), (Component)Ide.getMainWindow());
        }
        return this.builder;
    }

    public SyntaxBuilderPanel initialize(OracleDatabaseImpl oracleDatabaseImpl, AnalyticView analyticView, Object object) {
        Object object2;
        this.oraDB = oracleDatabaseImpl;
        this.analyticView = analyticView;
        String string = null;
        String string2 = null;
        if (analyticView != null) {
            if (this.props.containsKey("CUBE") && this.schema != null && (object2 = this.schema.findAV(this.props.getProperty("CUBE"))) != null && !object2.getName().equals(analyticView.getName())) {
                this.schema.getAnalyticViews().remove(object2);
            }
            this.props.setProperty("CUBE", analyticView.getName());
            this.props.setProperty("SCHEMA", analyticView.getSchema().getName());
            string = Connections.getInstance().getConnectionName(oracleDatabaseImpl.getConnection());
            string2 = analyticView.getSchema().getName();
            try {
                this.schema = HCSMetadataCache.getSchemaCopy(string, analyticView.getSchema().getName());
                this.schema = SyntaxBuilderLauncher.populateAV(this.schema, this.props, analyticView, object);
            }
            catch (Exception exception) {
                LOG.log(Level.SEVERE, "Error loading schema for aggregation builder", exception);
            }
            this.specParser.setConn(oracleDatabaseImpl.getConnection());
            this.parser.setSchema(this.schema);
            this.thf.setProvider(oracleDatabaseImpl);
            this.thf.setSchema(this.schema);
            this.thf.setProperty("CUBE", analyticView.getName());
        }
        if (this.specParser.getSpec() == null) {
            try {
                object2 = new InputStreamReader(this.getClass().getResourceAsStream("aggregationspec.xml"), "UTF-8");
                this.specParser.setSpec((Reader)object2);
            }
            catch (Exception exception) {
                LOG.log(Level.SEVERE, "Error reading the aggregation specs", exception);
            }
        }
        this.builder.initialize(string, string2);
        object2 = null;
        if (analyticView != null) {
            object2 = analyticView.getConsistentSolveSpec();
        }
        object2 = object2 == null ? " " : ((String)object2).trim();
        this.builder.setText((String)object2);
        return this.builder;
    }
}

