/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av.panels.cache;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.av.model.cache.AVCacheLevelGroup;
import oracle.hcs.av.model.cache.AVCacheLevelGroupDimHierLevel;
import oracle.hcs.av.model.cache.AVCacheLevelGroupNode;
import oracle.hcs.av.model.cache.AVCacheMeasureGroup;
import oracle.hcs.av.model.cache.AVCacheMeasureGroupMeasure;
import oracle.hcs.av.model.cache.AVCacheMeasureGroupNode;
import oracle.hcs.av.model.cache.AbstractAVNavigatorCacheModelNode;
import oracle.hcs.av.panels.cache.AVCacheController;
import oracle.hcs.av.panels.cache.AVNavigatorCachePanel;
import oracle.hcs.av.panels.cache.AVObjectEditorCachePanel;
import oracle.hcs.av.panels.cache.NavigatorCacheSelectionChangeHandler;
import oracle.ide.db.components.ComponentFactory;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.DBObjectProvider;

public class AVMainCachePanel
extends BaseEditorPanel<AnalyticView>
implements NavigatorCacheSelectionChangeHandler {
    private AVNavigatorCachePanel navigatorCachePanel;
    private AVObjectEditorCachePanel objectEditorCachePanel;
    private boolean isInitialized;

    public AVMainCachePanel() {
        this.layoutCachePanels();
    }

    protected void initialisePanel() {
        AnalyticView analyticView = (AnalyticView)this.getUpdatedObject();
        AVCacheController aVCacheController = new AVCacheController(this.navigatorCachePanel);
        DBObjectProvider dBObjectProvider = this.getProvider();
        if (!this.isInitialized || this.isReinitializationNeeded(analyticView)) {
            this.navigatorCachePanel.initialisePanel(analyticView, dBObjectProvider);
            this.objectEditorCachePanel.initialisePanel(analyticView, aVCacheController, dBObjectProvider);
            this.isInitialized = true;
        }
    }

    private boolean isReinitializationNeeded(AnalyticView analyticView) {
        boolean bl = false;
        AVCacheMeasureGroup[] aVCacheMeasureGroupArray = analyticView.getCacheMeasureGroups();
        if (aVCacheMeasureGroupArray != null && aVCacheMeasureGroupArray.length > 0) {
            for (AVCacheMeasureGroup aVCacheMeasureGroup : aVCacheMeasureGroupArray) {
                if (!aVCacheMeasureGroup.getLifeCycleEditOccurred()) continue;
                bl = true;
                break;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public void clearObjectEditorPanel() {
        this.objectEditorCachePanel.clearObjectEditorPanel();
    }

    protected void commitPanel() {
        AnalyticView analyticView = (AnalyticView)this.getUpdatedObject();
        JTree jTree = this.navigatorCachePanel.getCacheNavigator();
        AbstractAVNavigatorCacheModelNode abstractAVNavigatorCacheModelNode = (AbstractAVNavigatorCacheModelNode)jTree.getModel().getRoot();
        ArrayList<Cloneable> arrayList = new ArrayList<Cloneable>();
        if (abstractAVNavigatorCacheModelNode.getChildCount() > 0) {
            Cloneable cloneable;
            Enumeration<TreeNode> enumeration = abstractAVNavigatorCacheModelNode.children();
            while (enumeration.hasMoreElements()) {
                cloneable = (AVCacheMeasureGroupNode)enumeration.nextElement();
                arrayList.add(cloneable);
            }
            cloneable = new ArrayList();
            for (AVCacheMeasureGroupNode aVCacheMeasureGroupNode : arrayList) {
                cloneable.add(this.buildCacheMeasureGroup(aVCacheMeasureGroupNode));
            }
            analyticView.setCacheMeasureGroups(cloneable.toArray(new AVCacheMeasureGroup[0]));
        } else {
            analyticView.setCacheMeasureGroups(null);
        }
        this.objectEditorCachePanel.stopCellEditing();
    }

    private AVCacheMeasureGroup buildCacheMeasureGroup(AVCacheMeasureGroupNode aVCacheMeasureGroupNode) {
        Object object;
        AVCacheMeasureGroup aVCacheMeasureGroup = null;
        aVCacheMeasureGroup = new AVCacheMeasureGroup();
        if (aVCacheMeasureGroupNode.areAllMeasuresSelected()) {
            aVCacheMeasureGroup.setCacheMeasureGroupAllSelected(true);
        } else {
            aVCacheMeasureGroup.setCacheMeasureGroupAllSelected(false);
        }
        List<AVBaseMeasure> list = aVCacheMeasureGroupNode.getMeasures();
        AVCacheMeasureGroupMeasure[] aVCacheMeasureGroupMeasureArray = null;
        ArrayList<AVCacheMeasureGroupMeasure> arrayList = new ArrayList<AVCacheMeasureGroupMeasure>();
        for (AVBaseMeasure object22 : list) {
            object = new AVCacheMeasureGroupMeasure(object22.getName());
            if (aVCacheMeasureGroupNode.areAllMeasuresSelected()) {
                ((AVCacheMeasureGroupMeasure)((Object)object)).setCacheMeasureGroupAllActive(true);
            } else {
                ((AVCacheMeasureGroupMeasure)((Object)object)).setCacheMeasureGroupAllActive(false);
            }
            arrayList.add((AVCacheMeasureGroupMeasure)((Object)object));
        }
        aVCacheMeasureGroupMeasureArray = arrayList.toArray(new AVCacheMeasureGroupMeasure[0]);
        aVCacheMeasureGroup.setCacheMeasureGroupMeasures(aVCacheMeasureGroupMeasureArray);
        ArrayList arrayList2 = new ArrayList();
        Enumeration<TreeNode> enumeration = aVCacheMeasureGroupNode.children();
        while (enumeration.hasMoreElements()) {
            object = (AVCacheLevelGroupNode)enumeration.nextElement();
            ArrayList<AVCacheLevelGroupDimHierLevel> arrayList3 = new ArrayList<AVCacheLevelGroupDimHierLevel>();
            for (String string : ((AVCacheLevelGroupNode)object).getLevelTuple()) {
                arrayList3.add(new AVCacheLevelGroupDimHierLevel(string, 1));
            }
            AVCacheLevelGroup aVCacheLevelGroup = new AVCacheLevelGroup();
            aVCacheLevelGroup.setCacheLevelGroupHierLevels(arrayList3.toArray(new AVCacheLevelGroupDimHierLevel[0]));
            aVCacheLevelGroup.setCacheLevelGroupProcessMode(((AVCacheLevelGroupNode)object).getLevelGroupProcessMode());
            arrayList2.add(aVCacheLevelGroup);
        }
        aVCacheMeasureGroup.setCacheLevelGroups(arrayList2.toArray(new AVCacheLevelGroup[0]));
        return aVCacheMeasureGroup;
    }

    @Override
    public void navigatorNodeChanged(AbstractAVNavigatorCacheModelNode abstractAVNavigatorCacheModelNode) {
        this.objectEditorCachePanel.updateObjectEditorPanel(abstractAVNavigatorCacheModelNode);
    }

    private void layoutCachePanels() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        this.navigatorCachePanel = new AVNavigatorCachePanel(this);
        this.objectEditorCachePanel = new AVObjectEditorCachePanel();
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setLeftComponent(this.navigatorCachePanel);
        jSplitPane.setRightComponent(this.objectEditorCachePanel);
        jSplitPane.setOrientation(0);
        jSplitPane.setDividerLocation(200);
        this.add(jSplitPane, gridBagConstraints);
        ComponentFactory componentFactory = this.getComponentFactory();
        componentFactory.registerComponent((Component)this.navigatorCachePanel, "cacheMeasureGroups");
    }
}

