/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.db;

import java.awt.Component;
import java.awt.Window;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.hcs.HCSArb;
import oracle.hcs.db.MetadataChange;
import oracle.hcs.db.model.AbstractSchemaObjectWithDesc;
import oracle.hcs.db.panels.HCSCompileDDLGenerator;
import oracle.hcs.db.panels.HCSDDLPanel;
import oracle.hcs.db.panels.InvalidDependenciesDialog;
import oracle.hcs.db.source.SourceMetadata;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.hcs.util.SourceValidator;
import oracle.ide.Ide;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.dialogs.MessageDialog;

public abstract class BasePanelLibrary
extends PanelLibrary
implements SourceValidator {
    private Namespace namespace;
    private String schemaName;
    private String objName;
    private String objectType;
    private SourceMetadata sourceMetaData;
    private final String SOURCE_QUERY_XML_FILE = "sourcequeries.xml";
    private DBObjectProvider dbObjectProvider;
    private DBEditorConfig dBEditorConfig;
    private List<AbstractSchemaObjectWithDesc> dependencies;
    private HCSCompileDDLGenerator compileStatementsGeneratorHelper;
    private List<MetadataChange> commitChanges;
    private Connection conn;
    private static final Logger LOG = Logger.getLogger(BasePanelLibrary.class.getName());

    public BasePanelLibrary(String string) {
        super(string);
    }

    protected Namespace getNamespace() {
        return this.namespace;
    }

    public boolean canReplaceByDefault() {
        return true;
    }

    public boolean shouldResetObjectBeforeEdit(DBEditorConfig dBEditorConfig) {
        return true;
    }

    public boolean showEditorAfterCommit() {
        if (this.shouldCompileDependenciesAfterCommit()) {
            this.compileStatementsGeneratorHelper = new HCSCompileDDLGenerator();
            this.compileDependencies(this.conn, this.dependencies);
            int n = this.compileStatementsGeneratorHelper.getCompileErrorsCount(this.conn, this.dependencies);
            if (n > 0) {
                SystemObject systemObject = this.dBEditorConfig.getUpdatedObject();
                String string = systemObject.getName();
                InvalidDependenciesDialog invalidDependenciesDialog = new InvalidDependenciesDialog(this.dependencies, this.compileStatementsGeneratorHelper, this.dbObjectProvider, string);
                invalidDependenciesDialog.display();
            }
        }
        return super.showEditorAfterCommit();
    }

    private boolean shouldCompileDependenciesAfterCommit() {
        return this.dBEditorConfig.getResult().equals((Object)DBEditorConfig.Result.SUCCESS) && this.dBEditorConfig.isEdit() && !this.commitChanges.isEmpty() && !this.dependencies.isEmpty();
    }

    protected Class<? extends Traversable> getDDLPanel() {
        return HCSDDLPanel.class;
    }

    public Map<String, Object> getProperties() {
        return new HashMap<String, Object>();
    }

    public boolean shouldValidateOnExit(BaseEditorPanel baseEditorPanel, Namespace namespace) {
        this.namespace = namespace;
        return super.shouldValidateOnExit(baseEditorPanel, namespace);
    }

    protected abstract HCSSyntaxType getObjectType();

    private List<MetadataChange> getChildObjectChanges(DBEditorConfig dBEditorConfig) {
        ArrayList<MetadataChange> arrayList = new ArrayList<MetadataChange>();
        DBObjectProvider dBObjectProvider = dBEditorConfig.getProvider();
        SystemObject systemObject = dBEditorConfig.getUpdatedObject();
        Difference difference = dBObjectProvider.getDiffEngine().difference((Object)dBEditorConfig.getOriginalObject(), (Object)dBEditorConfig.getUpdatedObject());
        this.addMetadataChanges(systemObject, difference, arrayList);
        return arrayList;
    }

    protected abstract boolean containsChanges(List<MetadataChange> var1, HCSSyntaxType var2);

    protected abstract void addMetadataChanges(SystemObject var1, Difference var2, List<MetadataChange> var3);

    protected void addMetadataChanges(SystemObject systemObject, String string, Difference difference, List<MetadataChange> list, HCSSyntaxType hCSSyntaxType) {
        Difference difference2 = difference.getChildDifference(string, false);
        this.addMetadataChanges(systemObject, difference2, list, hCSSyntaxType);
    }

    protected void addMetadataChanges(SystemObject systemObject, Difference difference, List<MetadataChange> list, HCSSyntaxType hCSSyntaxType) {
        if (this.containsChanges(list, hCSSyntaxType)) {
            return;
        }
        if (difference != null && difference.getChildren().size() > 0) {
            for (Difference difference2 : difference.getChildren()) {
                if (difference2.isSame()) continue;
                list.add(new MetadataChange(systemObject.getName(), difference2.getPropertyName(), hCSSyntaxType));
            }
        } else if (difference != null && !difference.isSame()) {
            list.add(new MetadataChange(systemObject.getName(), hCSSyntaxType));
        }
    }

    public void commitToProvider(DBEditorConfig dBEditorConfig) {
        Object object;
        Object object2;
        SystemObject systemObject;
        this.commitChanges = new ArrayList<MetadataChange>();
        this.dBEditorConfig = dBEditorConfig;
        String string = "";
        if (dBEditorConfig.getOriginalObject() == null) {
            systemObject = dBEditorConfig.getUpdatedObject();
            this.commitChanges.add(new MetadataChange(systemObject.getName(), systemObject.getName(), this.getObjectType()));
        } else {
            systemObject = dBEditorConfig.getOriginalObject();
            string = systemObject.getName();
            object2 = dBEditorConfig.getUpdatedObject();
            this.dbObjectProvider = dBEditorConfig.getProvider();
            object = this.dbObjectProvider.getDiffEngine().difference((Object)dBEditorConfig.getOriginalObject(), (Object)dBEditorConfig.getUpdatedObject());
            this.addParentObjectChanges(systemObject, (SystemObject)object2, this.commitChanges);
            this.addMetadataChanges((SystemObject)object2, "caption", (Difference)object, this.commitChanges, this.getObjectType());
            this.addMetadataChanges((SystemObject)object2, "description", (Difference)object, this.commitChanges, this.getObjectType());
            this.addMetadataChanges((SystemObject)object2, "languageDescriptions", (Difference)object, this.commitChanges, this.getObjectType());
            this.addMetadataChanges((SystemObject)object2, "forceCreate", (Difference)object, this.commitChanges, this.getObjectType());
            this.commitChanges.addAll(this.getChildObjectChanges(dBEditorConfig));
        }
        systemObject = (OracleDatabaseImpl)dBEditorConfig.getProvider();
        this.dependencies = this.getDependencies(dBEditorConfig.getSchema().getName(), (OracleDatabaseImpl)systemObject, string);
        super.commitToProvider(dBEditorConfig);
        if (dBEditorConfig.getResult().equals((Object)DBEditorConfig.Result.SUCCESS) && !this.commitChanges.isEmpty()) {
            object2 = dBEditorConfig.getSchema().getName();
            this.conn = ((Database)dBEditorConfig.getProvider()).getConnection();
            object = Connections.getInstance().getConnectionName(this.conn);
            if (dBEditorConfig.isEdit() && !this.dependencies.isEmpty()) {
                String string2;
                boolean bl = false;
                boolean bl2 = false;
                for (AbstractSchemaObjectWithDesc object32 : this.dependencies) {
                    string2 = object32.getType();
                    if (!bl && string2.equals("HIERARCHY")) {
                        bl = true;
                    } else if (!bl2 && string2.equals("ANALYTIC VIEW")) {
                        bl2 = true;
                    }
                    if (!bl || !bl2) continue;
                    break;
                }
                ArrayList arrayList = new ArrayList();
                if (bl) {
                    URL uRL = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)object, (String)"", (String)object2, (String)"HIERARCHY");
                    arrayList.add(new DBObject(uRL));
                }
                if (bl2) {
                    URL uRL = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)object, (String)"", (String)object2, (String)"ANALYTIC VIEW");
                    arrayList.add(new DBObject(uRL));
                }
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    string2 = (DBObject)iterator.next();
                    SwingUtilities.invokeLater(new Runnable((DBObject)string2){
                        final /* synthetic */ DBObject val$dbObject;
                        {
                            this.val$dbObject = dBObject;
                        }

                        @Override
                        public void run() {
                            BasePanelLibrary.this.refreshNavigator(this.val$dbObject);
                        }
                    });
                }
            }
        }
    }

    protected List<AbstractSchemaObjectWithDesc> getDependencies(String string, OracleDatabaseImpl oracleDatabaseImpl, String string2) {
        return Collections.EMPTY_LIST;
    }

    private void compileDependencies(Connection connection, List<AbstractSchemaObjectWithDesc> list) {
        this.compileStatementsGeneratorHelper.compileDependencies(list, connection);
    }

    protected void addParentObjectChanges(SystemObject systemObject, SystemObject systemObject2, List<MetadataChange> list) {
        if (!systemObject.getName().equalsIgnoreCase(systemObject2.getName())) {
            list.add(new MetadataChange(systemObject2.getName(), systemObject2.getName(), this.getObjectType()));
        }
    }

    public void reconcileDependencies(Database database, SystemObject systemObject, SystemObject systemObject2) {
    }

    public void showForceCreateWarning(Window window) {
        MessageDialog.information((Component)window, (Object)HCSArb.getString("FORCE_WARNING_MSG"), (String)HCSArb.getString("FORCE_WARNING_TITLE"), null);
    }

    protected void showErrorMessage(String string, String string2) {
        MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)string, null);
    }

    protected boolean isSourceValid(DBEditorConfig dBEditorConfig) {
        AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc = (AbstractSchemaObjectWithDesc)dBEditorConfig.getUpdatedObject();
        this.setSourceMetadata(dBEditorConfig.getProvider());
        String string = abstractSchemaObjectWithDesc.getSchema().getName();
        this.setSchemaName(string);
        this.setObjectName(abstractSchemaObjectWithDesc.getName());
        this.setObjectType(abstractSchemaObjectWithDesc.getType());
        String string2 = this.getSourceQualifiedName(abstractSchemaObjectWithDesc);
        string2 = dBEditorConfig.getProvider().getExternalName(string2);
        String string3 = this.validateSource(string2);
        return string3 == null;
    }

    private void setSourceMetadata(DBObjectProvider dBObjectProvider) {
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)dBObjectProvider;
        this.sourceMetaData = new SourceMetadata("sourcequeries.xml", oracleDatabaseImpl.getConnection());
    }

    private void setSchemaName(String string) {
        this.schemaName = string;
    }

    private void setObjectName(String string) {
        this.objName = string;
    }

    private void setObjectType(String string) {
        this.objectType = string;
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public String getUpdObjectName() {
        return this.objName;
    }

    @Override
    public String getUpdObjectType() {
        return this.objectType;
    }

    @Override
    public SourceMetadata getSourceMetadata() {
        return this.sourceMetaData;
    }

    protected String getSourceQualifiedName(AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc) {
        return "";
    }

    protected void refreshNavigator(DBObject dBObject) {
        ObjectAction objectAction = new ObjectAction();
        objectAction.setReload(true);
        ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback((ObjectAction)objectAction, (DBObject)dBObject);
        objectActionPostProcess.run();
    }
}

