/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.db.panels;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.av.model.AVDimensionality;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.HCSMetadataCache;
import oracle.hcs.db.model.AbstractSchemaObjectWithDesc;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.metadata.HCSSchema;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class HCSObjectDependenciesGenerator {
    public static HCSSchema getSchema(String string, OracleDatabaseImpl oracleDatabaseImpl) {
        HCSSchema hCSSchema = null;
        Connection connection = oracleDatabaseImpl.getConnection();
        String string2 = Connections.getInstance().getConnectionName(connection);
        try {
            HCSMetadataCache.removeSchema(string2, string);
            hCSSchema = HCSMetadataCache.getUpdatedSchema(string2, string);
        }
        catch (Exception exception) {
            Logger logger = Logger.getLogger(HCSObjectDependenciesGenerator.class.getName());
            logger.log(Level.SEVERE, exception.getMessage());
        }
        return hCSSchema;
    }

    public static List<AbstractSchemaObjectWithDesc> getDimensionDependencies(String string, OracleDatabaseImpl oracleDatabaseImpl, String string2) {
        HCSSchema hCSSchema = HCSObjectDependenciesGenerator.getSchema(string, oracleDatabaseImpl);
        ArrayList<AbstractSchemaObjectWithDesc> arrayList = new ArrayList<AbstractSchemaObjectWithDesc>();
        for (Hierarchy abstractMappableSchemaObjectWithDesc : hCSSchema.getHierarchies()) {
            AVDimensionality[] aVDimensionalityArray = abstractMappableSchemaObjectWithDesc.getDimensionName();
            if (!aVDimensionalityArray.equals(string2)) continue;
            arrayList.add(abstractMappableSchemaObjectWithDesc);
        }
        block1: for (AnalyticView analyticView : hCSSchema.getAnalyticViews()) {
            for (AVDimensionality aVDimensionality : analyticView.getDimensions()) {
                String string3 = aVDimensionality.getName();
                if (string3 == null || !string3.equals(string2)) continue;
                arrayList.add(analyticView);
                continue block1;
            }
        }
        return arrayList;
    }

    public static List<AbstractSchemaObjectWithDesc> getHierarchyDependencies(String string, OracleDatabaseImpl oracleDatabaseImpl, String string2) {
        HCSSchema hCSSchema = HCSObjectDependenciesGenerator.getSchema(string, oracleDatabaseImpl);
        ArrayList<AbstractSchemaObjectWithDesc> arrayList = new ArrayList<AbstractSchemaObjectWithDesc>();
        boolean bl = false;
        block0: for (AnalyticView analyticView : hCSSchema.getAnalyticViews()) {
            for (AVDimensionality aVDimensionality : analyticView.getDimensions()) {
                for (AVHierarchy aVHierarchy : aVDimensionality.getHierarchies()) {
                    String string3 = aVHierarchy.getName();
                    if (string3 == null || !string3.equals(string2)) continue;
                    arrayList.add(analyticView);
                    bl = true;
                    break;
                }
                if (!bl) continue;
                bl = false;
                continue block0;
            }
        }
        return arrayList;
    }
}

