/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.dimension.panels;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import oracle.hcs.syntaxbuilder.SnippetBuilderPanel;
import oracle.hcs.syntaxbuilder.specification.SpecTreeNode;
import oracle.hcs.util.HyperParamColoringHelper;

public class HyperTextSpecNodeRenderer {
    private final JTree tree;
    private final SnippetBuilderPanel editor;
    private static final Logger LOG = Logger.getLogger(HyperTextSpecNodeRenderer.class.getName());

    public HyperTextSpecNodeRenderer(JTree jTree, SnippetBuilderPanel snippetBuilderPanel) {
        this.tree = jTree;
        this.editor = snippetBuilderPanel;
    }

    public void setupTreeRendering() {
        this.tree.setEditable(true);
        HyperTextCellRenderer hyperTextCellRenderer = new HyperTextCellRenderer();
        this.tree.setCellRenderer(hyperTextCellRenderer);
        this.tree.setCellEditor(new HyperTextCellEditor(this.tree, hyperTextCellRenderer, new HyperTextCellEditorImpl()));
    }

    private class HyperTextCellEditorImpl
    extends AbstractCellEditor
    implements TreeCellEditor {
        private HyperTextCellRenderer renderer;

        public HyperTextCellEditorImpl() {
            this.renderer = new HyperTextCellRenderer();
        }

        @Override
        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            Component component = this.renderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, true);
            return component;
        }

        @Override
        public Object getCellEditorValue() {
            return "";
        }
    }

    private class HyperTextCellEditor
    extends DefaultTreeCellEditor {
        public HyperTextCellEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer, TreeCellEditor treeCellEditor) {
            super(jTree, defaultTreeCellRenderer, treeCellEditor);
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            Object object;
            if (eventObject instanceof MouseEvent) {
                Object object2;
                MouseEvent mouseEvent = (MouseEvent)eventObject;
                TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath != null && (object2 = treePath.getLastPathComponent()) != null && object2 instanceof SpecTreeNode) {
                    SpecTreeNode specTreeNode = (SpecTreeNode)object2;
                    return specTreeNode.isLeaf() && specTreeNode.getTemplateHelper() != null;
                }
            } else if (eventObject == null && (object = this.tree.getSelectionPath().getLastPathComponent()) != null && object instanceof SpecTreeNode) {
                SpecTreeNode specTreeNode = (SpecTreeNode)object;
                return specTreeNode.isLeaf() && specTreeNode.getTemplateHelper() != null;
            }
            return false;
        }
    }

    private class HyperTextCellRenderer
    extends DefaultTreeCellRenderer {
        Component component;

        public HyperTextCellRenderer() {
            this.setLeafIcon(null);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            SpecTreeNode specTreeNode = (SpecTreeNode)object;
            if (specTreeNode.isLeaf()) {
                if (specTreeNode.getTemplateHelper() != null) {
                    if (this.component == null) {
                        try {
                            this.component = specTreeNode.getTemplateHelper().getGUI(true).getTemplateViewPanel();
                            this.changeComponentColorScheme(jTree, this.component);
                        }
                        catch (Exception exception) {
                            LOG.log(Level.SEVERE, exception.getMessage(), exception);
                        }
                    }
                    return this.component;
                }
                return super.getTreeCellRendererComponent(jTree, object, bl, bl2, true, n, bl4);
            }
            return super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        }

        private void changeComponentColorScheme(JTree jTree, Component component) {
            JPanel jPanel = (JPanel)component;
            jPanel.setBackground(jTree.getBackground());
            jPanel.setForeground(jTree.getForeground());
            for (Component component2 : jPanel.getComponents()) {
                if (!(component2 instanceof HyperParamColoringHelper)) continue;
                HyperParamColoringHelper hyperParamColoringHelper = (HyperParamColoringHelper)((Object)component2);
                hyperParamColoringHelper.setBackgroundColor(jTree.getBackground());
            }
        }
    }
}

