/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.hierarchyviewer;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.hierarchy.model.HierarchyLevel;
import oracle.hcs.hierarchyviewer.HierarchyLoader;
import oracle.hcs.tree.loader.TreeLoader;

public class HierarchyET {
    private Connection conn;
    private TreeLoader treeLoader;
    private List<String> levelNames;
    private String owner;
    private String dimensionName;
    private String hierarchyName;
    private Hierarchy hierarchy;

    public HierarchyET(Connection connection, Hierarchy hierarchy) throws SQLException, IOException {
        this.owner = hierarchy.getSchema().getName();
        this.conn = connection;
        this.dimensionName = hierarchy.getDimensionName();
        this.hierarchy = hierarchy;
        this.init();
    }

    private void init() throws SQLException, IOException {
        this.hierarchyName = this.hierarchy.getName();
        HierarchyLevel[] hierarchyLevelArray = this.hierarchy.getHierarchyLevels();
        this.levelNames = new ArrayList<String>();
        for (HierarchyLevel hierarchyLevel : hierarchyLevelArray) {
            this.levelNames.add(hierarchyLevel.getName());
        }
        this.treeLoader = new HierarchyLoader(this.conn, this.hierarchy);
        this.treeLoader.getTree().setLevelNames(this.levelNames);
    }

    public void reload() throws SQLException, IOException {
        this.init();
    }

    public boolean isFlat() {
        return this.levelNames == null;
    }

    public String getViewName() {
        return this.hierarchyName;
    }

    public TreeLoader getTreeLoader() {
        return this.treeLoader;
    }

    public List<String> getLevelNames() {
        return this.levelNames;
    }

    public String getHierarchyName() {
        return this.hierarchyName;
    }
}

