/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.quickav;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.app.Format;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.HCSArb;
import oracle.hcs.av.model.AVMeasure;
import oracle.hcs.db.MetadataChange;
import oracle.hcs.db.source.DatabaseSource;
import oracle.hcs.db.source.SourceMetadata;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.quickav.AVDDL;
import oracle.hcs.quickav.QuickAVDataTableHelper;
import oracle.hcs.quickav.QuickAVDialog;
import oracle.hcs.quickav.QuickAVDimensionGenerator;
import oracle.hcs.quickav.QuickAVEditableCellRenderer;
import oracle.hcs.quickav.QuickAVSaveDDL;
import oracle.hcs.quickav.QuickAVTableAnalyzer;
import oracle.hcs.quickav.QuickAVTableCellEditor;
import oracle.hcs.quickav.model.TableCol;
import oracle.hcs.table.TableCheckBoxCellEditor;
import oracle.hcs.table.TableCheckBoxCellRenderer;
import oracle.hcs.util.CheckBoxHeader;
import oracle.hcs.util.FeatureMap;
import oracle.hcs.util.SourceSelectionDialog;
import oracle.javatools.db.Database;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.ReorderableTableModel;
import oracle.javatools.ui.table.ReorderableTableWithTitleBar;

public class QuickAVDataPanel
extends JPanel {
    private GenericTable dataSummaryTable;
    private ColumnsTableModel tableModel;
    private Connection conn;
    private JTextField factTableField;
    private JTextField avNameField;
    private SourceMetadata sourceMetadata;
    private QuickAVDataTableHelper dataTableHelper;
    private Database db;
    private BasicEditorPane sqlAnalysisPane;
    private List<MetadataChange> metadataChanges;
    private CheckBoxHeader checkBoxHeader;
    private AVDDL ddlGen;
    private ReorderableTableWithTitleBar reorderableTable;
    private final String SHORT_SUFFIX = "_AV";
    private static final Logger LOG = Logger.getLogger(QuickAVDataPanel.class.getName());
    private HCSSchema schema;
    private static final int TRUNCATE_LIMIT = 121;
    private JLabel sqlAnalysisLabel;
    private JDialog parentDlg;
    private String summaryQuery;
    private String avFieldNameStr;
    private JButton saveBtn;
    private QuickAVDimensionGenerator dimGen;
    private String internalQualifiedFactTableName;
    private DatabaseSource avFactSource;
    private final String COLUMNS_QUERY_NAME = "GET_COLUMNS_BY_OBJECT";
    private boolean supportDistinct;
    private boolean usingDistinct;

    public QuickAVDataPanel(JDialog jDialog, Connection connection, HCSSchema hCSSchema, QuickAVDataTableHelper quickAVDataTableHelper, SourceMetadata sourceMetadata, List<DatabaseSource> list, Database database, QuickAVDimensionGenerator quickAVDimensionGenerator) {
        this.conn = connection;
        this.schema = hCSSchema;
        this.db = database;
        this.dataTableHelper = quickAVDataTableHelper;
        this.sourceMetadata = sourceMetadata;
        this.parentDlg = jDialog;
        this.dimGen = quickAVDimensionGenerator;
        this.tableModel = new ColumnsTableModel(null);
        this.dataSummaryTable = new GenericTable((TableModel)this.tableModel);
        this.factTableField = new JTextField();
        this.factTableField.setEditable(false);
        this.avNameField = new JTextField();
        this.avNameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.avNameChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.avNameChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.avNameChanged();
            }

            private void avNameChanged() {
                if (QuickAVDataPanel.this.avNameField.getText() != null && !QuickAVDataPanel.this.avNameField.getText().isEmpty()) {
                    QuickAVDataPanel.this.ddlGen.setAvName(QuickAVDataPanel.this.avNameField.getText());
                    QuickAVDataPanel.this.dataTableHelper.quickAVDataTableChanged();
                }
            }
        });
        this.dataSummaryTable.getColumnModel().getColumn(3).setCellEditor(new FieldTypeCellEditor(quickAVDataTableHelper));
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(3);
        hashSet.add(4);
        QuickAVEditableCellRenderer quickAVEditableCellRenderer = new QuickAVEditableCellRenderer(hashSet);
        this.dataSummaryTable.getColumnModel().getColumn(3).setCellRenderer(quickAVEditableCellRenderer);
        this.dataSummaryTable.getColumnModel().getColumn(4).setCellRenderer(quickAVEditableCellRenderer);
        this.dataSummaryTable.putClientProperty((Object)"terminateEditOnFocusLost", (Object)true);
        this.sqlAnalysisPane = new BasicEditorPane();
        this.sqlAnalysisPane.setDocument((Document)new BasicDocument("foo.plsql"));
        TableColumn tableColumn = this.dataSummaryTable.getColumnModel().getColumn(0);
        tableColumn.setCellEditor(new TableCheckBoxCellEditor());
        tableColumn.setCellRenderer(new TableCheckBoxCellRenderer());
        this.checkBoxHeader = new CheckBoxHeader((JTable)this.dataSummaryTable);
        tableColumn.setHeaderRenderer(this.checkBoxHeader);
        tableColumn.setPreferredWidth(70);
        this.dataSummaryTable.setAutoCreateRowSorter(true);
        this.dataSummaryTable.setHiddenColumns(new int[]{5, 6});
        this.dataSummaryTable.setSelectionMode(0);
        this.setSummaryTableColumnsLength();
        this.sqlAnalysisLabel = new JLabel();
        String string = Connections.getInstance().getConnectionName(connection);
        if (FeatureMap.getInstance().isSupported(string, "REFERENCES_DISTINCT")) {
            this.supportDistinct = true;
        }
        this.layoutComponents();
        if (list != null && !list.isEmpty()) {
            DatabaseSource databaseSource;
            this.avFactSource = databaseSource = list.get(0);
            this.internalQualifiedFactTableName = QuickAVDialog.qualifyName(hCSSchema, databaseSource.getName(), databaseSource.getSchemaName());
            String string2 = this.externalizeFactTableName(this.avFactSource);
            this.factTableField.setText(string2);
            this.ddlGen = new AVDDL(hCSSchema, database, "", this.avFactSource, quickAVDimensionGenerator);
            this.analyzeSource();
        }
    }

    private void setSummaryTableColumnsLength() {
        this.dataSummaryTable.setAutoResizeMode(0);
        this.dataSummaryTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        for (int i = 1; i <= 3; ++i) {
            this.dataSummaryTable.getColumnModel().getColumn(i).setPreferredWidth(113);
        }
        this.dataSummaryTable.getColumnModel().getColumn(4).setPreferredWidth(140);
    }

    private void analyzeSource() {
        this.dataSummaryTable.getColumnModel().getColumn(4).setCellEditor(new DimensionKeyTypeCellEditor(this.dimGen));
        SwingWorker<String, String> swingWorker = new SwingWorker<String, String>(){

            @Override
            protected String doInBackground() throws Exception {
                try {
                    QuickAVDataPanel.this.summaryQuery = QuickAVDataPanel.this.beginAnalysis(QuickAVDataPanel.this.avFactSource);
                }
                catch (Exception exception) {
                    LOG.log(Level.SEVERE, exception.getMessage());
                }
                return null;
            }

            @Override
            protected void done() {
                QuickAVDataPanel.this.setSqlAnalysisPaneEditable(true);
                QuickAVDataPanel.this.sqlAnalysisPane.setText(QuickAVDataPanel.this.summaryQuery);
                QuickAVDataPanel.this.saveBtn.setEnabled(true);
                QuickAVDataPanel.this.setSqlAnalysisPaneEditable(false);
            }
        };
        swingWorker.execute();
    }

    private void setSqlAnalysisPaneEditable(boolean bl) {
        this.sqlAnalysisPane.setEditable(bl);
    }

    public void commitCellEdit() {
        if (this.dataSummaryTable.isEditing()) {
            this.dataSummaryTable.getCellEditor().stopCellEditing();
        }
    }

    public String getAVName() {
        return this.avNameField.getText();
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel(HCSArb.getString("QUICK_AV_DIALOG_USAGE")), new GridBagConstraints(0, 0, 3, 1, 0.5, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)new JLabel(HCSArb.getString("HIERARCHY_DIMENSION_SOURCE_LABEL")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)this.factTableField, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        JButton jButton = new JButton(HCSArb.getString("SOURCE_BUTTON_LABEL"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Window window = SwingUtilities.windowForComponent(QuickAVDataPanel.this);
                List<DatabaseSource> list = SourceSelectionDialog.showDialog(window, QuickAVDataPanel.this.sourceMetadata, null, QuickAVDataPanel.this.schema.getName(), "", "", true, false, "av_source_selection");
                if (list != null && !list.isEmpty()) {
                    QuickAVDataPanel.this.avFactSource = list.get(0);
                    QuickAVDataPanel.this.internalQualifiedFactTableName = QuickAVDialog.qualifyName(QuickAVDataPanel.this.schema, list.get(0).getName(), list.get(0).getSchemaName());
                    String string = QuickAVDataPanel.this.externalizeFactTableName(QuickAVDataPanel.this.avFactSource);
                    QuickAVDataPanel.this.factTableField.setText(string);
                    QuickAVDataPanel.this.ddlGen.clear();
                    QuickAVDataPanel.this.ddlGen.setFactTableSource(QuickAVDataPanel.this.avFactSource);
                    QuickAVDataPanel.this.analyzeSource();
                }
            }
        });
        this.add((Component)jButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)new JLabel(HCSArb.getString("QUICK_AV_DIALOG_AV_NAME_LABEL")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)this.avNameField, new GridBagConstraints(1, 2, 2, 1, 0.5, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        JScrollPane jScrollPane = new JScrollPane((Component)this.dataSummaryTable);
        this.reorderableTable = new ReorderableTableWithTitleBar((JTable)this.dataSummaryTable, (JComponent)jScrollPane, true, true);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.reorderableTable, "Center");
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.saveBtn = new JButton(StringUtils.stripMnemonic((String)HCSArb.getString("QUICK_AV_SAVE_BTN")));
        this.saveBtn.setMnemonic(StringUtils.getMnemonicKeyCode((String)HCSArb.get("QUICK_AV_SAVE_BTN")));
        this.saveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    QuickAVSaveDDL.saveDDLToFile(QuickAVDataPanel.this.parentDlg, QuickAVDataPanel.this.sqlAnalysisPane.getText(), String.format("%s_summary.sql", QuickAVDataPanel.this.internalQualifiedFactTableName));
                }
                catch (Exception exception) {
                    Logger.getLogger(QuickAVDataPanel.class.getName()).log(Level.SEVERE, "Error saving sql analysis for quick analytic view", exception);
                }
            }
        });
        this.saveBtn.setEnabled(false);
        JScrollPane jScrollPane2 = new JScrollPane((Component)this.sqlAnalysisPane);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)this.sqlAnalysisLabel, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        jPanel2.add((Component)jScrollPane2, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.5, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        jPanel2.add((Component)this.saveBtn, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 2, 5), 0, 0));
        jTabbedPane.add(HCSArb.getString("QUICK_AV_DIALOG_RESULTS_ANALYSIS_STATS_TAB"), jPanel);
        jTabbedPane.add(HCSArb.getString("QUICK_AV_DIALOG_SQL_ANALYSIS_STATS_TAB"), jPanel2);
        this.add((Component)jTabbedPane, new GridBagConstraints(0, 3, 3, 1, 0.5, 0.5, 10, 1, new Insets(5, 0, 0, 5), 0, 0));
    }

    private String generateDefaultName(String string, String string2) {
        string = QuickAVDataPanel.truncateName(string);
        String string3 = String.format("%s%s", string, string2);
        int n = 0;
        String string4 = string3;
        List<String> list = this.dimGen.getExistingTableAndViewNames();
        while (list.contains(string4)) {
            string4 = String.format("%s_%03d", string3, ++n);
        }
        if (n > 0) {
            string3 = string4;
        }
        return string3;
    }

    protected static String truncateName(String string) {
        if (string.length() > 121) {
            String string2 = (string = string.substring(0, 121)).substring(string.length() - 1);
            if (string2.equals("_")) {
                return string.substring(0, string.length() - 1);
            }
            return string;
        }
        return string;
    }

    public String getFactTable() {
        return this.internalQualifiedFactTableName;
    }

    private String beginAnalysis(DatabaseSource databaseSource) throws Exception {
        String string = null;
        final ArrayList arrayList = new ArrayList();
        QuickAVTableAnalyzer quickAVTableAnalyzer = new QuickAVTableAnalyzer(this.parentDlg, this.schema, this.db, this.conn, databaseSource, arrayList, this.dataTableHelper, this.getFactTable(), this.dimGen){

            @Override
            protected void done() {
                super.done();
                if (QuickAVDataPanel.this.avNameField.getText() == null || QuickAVDataPanel.this.avNameField.getText().isEmpty()) {
                    String string = QuickAVDataPanel.this.avFactSource.getName();
                    QuickAVDataPanel.this.avFieldNameStr = QuickAVDataPanel.this.generateDefaultName(string, "_AV");
                    QuickAVDataPanel.this.avNameField.setText(QuickAVDataPanel.this.db.getExternalName(QuickAVDataPanel.this.avFieldNameStr));
                    QuickAVDataPanel.this.ddlGen.setAvName(QuickAVDataPanel.this.avFieldNameStr);
                }
                QuickAVDataPanel.this.sqlAnalysisLabel.setText(HCSArb.format("QUICK_AV_SOURCE_STS_USAGE_MESSAGE", QuickAVDataPanel.this.internalQualifiedFactTableName));
                QuickAVDataPanel.this.checkBoxHeader.setSelected(true);
                QuickAVDataPanel.this.reorderableTable.getTableToolbar().setLabel(HCSArb.format("QUICK_AV_DIALOG_ROWS_IN_SRC", QuickAVDataPanel.this.getTotalRowsInTable(arrayList), QuickAVDataPanel.this.internalQualifiedFactTableName));
                QuickAVDataPanel.this.dataTableHelper.quickAVDataTableChanged();
                QuickAVDataPanel.this.tableModel.setElements(arrayList);
            }
        };
        try {
            string = (String)quickAVTableAnalyzer.get();
            string = new Format().format(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private String externalizeFactTableName(DatabaseSource databaseSource) {
        String string = databaseSource.getSchemaName();
        String string2 = databaseSource.getName();
        if (string.equals(this.schema.getName())) {
            return this.db.getExternalName(string2);
        }
        return String.format("\"%s\".\"%s\"", string, string2);
    }

    private int getTotalRowsInTable(List<TableCol> list) {
        int n = 0;
        for (TableCol tableCol : list) {
            if (tableCol.getTotalRows() <= n) continue;
            n = tableCol.getTotalRows();
        }
        return n;
    }

    public List<String> generateAVDDL() throws Exception {
        if (this.ddlGen.getDimensionsCount() == 0 && this.ddlGen.getMeasuresCount() == 0) {
            this.initMetadataObjects();
        }
        if (this.ddlGen.getDimensionsCount() == 0 || this.ddlGen.getMeasuresCount() == 0) {
            return Collections.emptyList();
        }
        this.metadataChanges = this.ddlGen.generateMetadataChanges();
        return this.ddlGen.generateDDL(this.usingDistinct);
    }

    public void createMetadataObjects() throws Exception {
        this.initMetadataObjects();
    }

    public List<AVMeasure> getMeasures() {
        if (this.ddlGen != null) {
            return this.ddlGen.getMeasures();
        }
        return Collections.EMPTY_LIST;
    }

    public List<AttributeDimension> getDimensions() {
        if (this.ddlGen != null) {
            return this.ddlGen.getDimensions();
        }
        return Collections.EMPTY_LIST;
    }

    public Collection<Hierarchy> getHierarchies() {
        if (this.ddlGen != null) {
            return this.ddlGen.getHierarchies();
        }
        return Collections.EMPTY_LIST;
    }

    private void initMetadataObjects() throws Exception {
        this.ddlGen.clear();
        List<TableCol> list = this.tableModel.getElements();
        for (TableCol tableCol : list) {
            if (!tableCol.isIncludeColumn()) continue;
            if (tableCol.getFieldType().equalsIgnoreCase(HCSArb.getString("QUICK_AV_DIALOG_DIMENSION"))) {
                if (tableCol.getMatchingDimension().equalsIgnoreCase(HCSArb.getString("QUICK_AV_CREATE_NEW_DIM"))) {
                    if (this.supportDistinct) {
                        this.ddlGen.addDimensionDistinct(tableCol.getFieldName(), tableCol.getDataType());
                        this.usingDistinct = true;
                        continue;
                    }
                    this.ddlGen.addDimension(tableCol.getFieldName(), tableCol.getFieldName(), true, tableCol.getDataType());
                    continue;
                }
                this.ddlGen.addDimension(tableCol.getMatchingDimension(), tableCol.getFieldName(), tableCol.getDataType());
                continue;
            }
            if (!tableCol.getFieldType().equalsIgnoreCase(HCSArb.getString("QUICK_AV_DIALOG_MEASURE"))) continue;
            this.ddlGen.addMeasure(tableCol.getFieldName(), tableCol.getDataType());
        }
    }

    public List<MetadataChange> getMetadataChanges() {
        return this.metadataChanges;
    }

    private class DimensionKeyTypeCellEditor
    extends QuickAVTableCellEditor {
        private QuickAVDimensionGenerator dimGen;

        public DimensionKeyTypeCellEditor(QuickAVDimensionGenerator quickAVDimensionGenerator) {
            super(null);
            this.dimGen = quickAVDimensionGenerator;
        }

        @Override
        protected void populateComboBoxModel(DefaultComboBoxModel defaultComboBoxModel) {
            defaultComboBoxModel.addElement(HCSArb.getString("QUICK_AV_CREATE_NEW_DIM"));
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            JComboBox jComboBox = this.getComboBox();
            String string = QuickAVDataPanel.this.db.getInternalName((String)jTable.getValueAt(n, 1));
            List<AttributeDimension> list = this.dimGen.findDimForMapExpression(string);
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)jComboBox.getModel();
            defaultComboBoxModel.removeAllElements();
            defaultComboBoxModel.addElement(HCSArb.getString("QUICK_AV_CREATE_NEW_DIM"));
            for (AttributeDimension attributeDimension : list) {
                defaultComboBoxModel.addElement(attributeDimension.getName());
            }
            return jComboBox;
        }
    }

    private class FieldTypeCellEditor
    extends QuickAVTableCellEditor {
        private String lastType;

        public FieldTypeCellEditor(final QuickAVDataTableHelper quickAVDataTableHelper) {
            super(quickAVDataTableHelper);
            final JComboBox jComboBox = this.getComboBox();
            this.lastType = (String)jComboBox.getSelectedItem();
            jComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (quickAVDataTableHelper != null) {
                        String string = (String)jComboBox.getSelectedItem();
                        if (!FieldTypeCellEditor.this.lastType.equalsIgnoreCase(string)) {
                            quickAVDataTableHelper.quickAVDataTableChanged();
                        }
                        FieldTypeCellEditor.this.lastType = string;
                    }
                }
            });
        }

        @Override
        protected void populateComboBoxModel(DefaultComboBoxModel defaultComboBoxModel) {
            defaultComboBoxModel.addElement(HCSArb.getString("QUICK_AV_DIALOG_DIMENSION").toUpperCase());
            defaultComboBoxModel.addElement(HCSArb.getString("QUICK_AV_DIALOG_MEASURE").toUpperCase());
        }
    }

    private class ColumnsTableModel
    extends AbstractTableModel
    implements ReorderableTableModel,
    TableModelListener {
        private final String[] columns = new String[]{HCSArb.getString("MEASURE_SELECT_COLUMN"), HCSArb.getString("QUICK_AV_DIALOG_TABLE_SOURCE_COLUMN"), HCSArb.getString("QUICK_AV_DIALOG_TABLE_DATA_TYPE_COLUMN"), HCSArb.getString("QUICK_AV_DIALOG_TABLE_TYPE_COLUMN"), HCSArb.getString("QUICK_AV_DIALOG_TABLE_MATCHING_DIM"), HCSArb.getString("QUICK_AV_DIALOG_TABLE_CARDINALITY_COLUMN"), HCSArb.getString("QUICK_AV_DIALOG_TABLE_RATIO_COLUMN")};
        protected static final int SELECT_COL = 0;
        protected static final int TABLE_COLUMN_COL = 1;
        protected static final int DATA_TYPE_COL = 2;
        protected static final int TYPE_COL = 3;
        protected static final int MATCHING_DIM_COL = 4;
        protected static final int CARDINALITY_COL = 5;
        protected static final int RATIO_COL = 6;
        private List<TableCol> elements;

        public ColumnsTableModel(List<TableCol> list) {
            this.elements = list;
            this.addTableModelListener(this);
        }

        public void setElements(List<TableCol> list) {
            this.elements = list;
            this.fireTableDataChanged();
        }

        public List<TableCol> getElements() {
            return this.elements;
        }

        @Override
        public int getRowCount() {
            if (this.elements != null) {
                return this.elements.size();
            }
            return 0;
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            boolean bl = (Boolean)this.getValueAt(n, 0);
            if (bl) {
                boolean bl2 = n2 == 3 || n2 == 0;
                boolean bl3 = n2 == 4 && ((String)this.getValueAt(n, 3)).equalsIgnoreCase(HCSArb.getString("QUICK_AV_DIALOG_DIMENSION"));
                return bl2 || bl3;
            }
            return n2 == 0;
        }

        @Override
        public String getColumnName(int n) {
            return this.columns[n];
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return String.class;
                }
                case 6: {
                    return BigDecimal.class;
                }
                case 5: {
                    return Integer.class;
                }
                case 0: {
                    return Boolean.class;
                }
            }
            return Object.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.elements != null && n < this.elements.size()) {
                TableCol tableCol = this.elements.get(n);
                switch (n2) {
                    case 0: {
                        return tableCol.isIncludeColumn();
                    }
                    case 1: {
                        String string = tableCol.getFieldName();
                        String string2 = QuickAVDataPanel.this.db.getExternalName(string);
                        return string2;
                    }
                    case 4: {
                        return tableCol.getMatchingDimension();
                    }
                    case 5: {
                        return tableCol.getCardinality();
                    }
                    case 3: {
                        return tableCol.getFieldType();
                    }
                    case 6: {
                        return tableCol.getRatio();
                    }
                    case 2: {
                        return tableCol.getDataType();
                    }
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (this.elements != null) {
                TableCol tableCol = this.elements.get(n);
                switch (n2) {
                    case 3: {
                        String string = (String)object;
                        if (tableCol.getFieldType().equalsIgnoreCase(string)) break;
                        tableCol.setFieldType((String)object);
                        if (((String)object).equalsIgnoreCase(HCSArb.getString("QUICK_AV_DIALOG_MEASURE"))) {
                            tableCol.setMatchingDimension("");
                        } else {
                            tableCol.setMatchingDimension(HCSArb.getString("QUICK_AV_CREATE_NEW_DIM"));
                        }
                        this.fireTableDataChanged();
                        QuickAVDataPanel.this.dataTableHelper.quickAVDataTableChanged();
                        break;
                    }
                    case 0: {
                        tableCol.setIncludeColumn((Boolean)object);
                        this.fireTableCellUpdated(n, n2);
                        if (!tableCol.isIncludeColumn()) {
                            tableCol.setMatchingDimension("");
                            tableCol.setFieldType("");
                        } else {
                            tableCol.setFieldType(HCSArb.getString("QUICK_AV_DIALOG_DIMENSION").toUpperCase());
                            tableCol.setMatchingDimension(HCSArb.getString("QUICK_AV_CREATE_NEW_DIM"));
                        }
                        QuickAVDataPanel.this.dataTableHelper.quickAVDataTableChanged();
                        break;
                    }
                    case 4: {
                        tableCol.setMatchingDimension((String)object);
                        this.fireTableDataChanged();
                        QuickAVDataPanel.this.dataTableHelper.quickAVDataTableChanged();
                    }
                }
            }
        }

        public void moveRow(int n, int n2, int n3) {
            if (n >= 0 && n < this.elements.size() && n2 >= 0 && n2 < this.elements.size() && n3 >= 0 && n3 < this.elements.size()) {
                if (n3 == 0) {
                    this.moveToTop(n);
                } else if (n3 == this.elements.size() - 1) {
                    this.moveToBottom(n);
                } else {
                    int n4 = 0;
                    for (int i = n; i <= n2; ++i) {
                        if (n3 + n4 >= this.elements.size()) continue;
                        this.swap(i, n3 + n4);
                        ++n4;
                    }
                }
            }
        }

        private void moveToTop(int n) {
            TableCol tableCol = this.elements.remove(n);
            this.elements.add(0, tableCol);
            this.fireTableDataChanged();
            QuickAVDataPanel.this.dataTableHelper.quickAVDataTableChanged();
        }

        private void moveToBottom(int n) {
            TableCol tableCol = this.elements.remove(n);
            this.elements.add(tableCol);
            this.fireTableDataChanged();
            QuickAVDataPanel.this.dataTableHelper.quickAVDataTableChanged();
        }

        private void swap(int n, int n2) {
            TableCol tableCol = this.elements.get(n);
            TableCol tableCol2 = this.elements.get(n2);
            this.elements.set(n2, tableCol);
            this.elements.set(n, tableCol2);
            this.fireTableDataChanged();
            QuickAVDataPanel.this.dataTableHelper.quickAVDataTableChanged();
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (this.elements != null && tableModelEvent.getColumn() == 0) {
                int n = this.countSelections();
                this.updateSelectAll(n);
            }
        }

        private int countSelections() {
            int n = 0;
            for (TableCol tableCol : this.elements) {
                if (!tableCol.isIncludeColumn()) continue;
                ++n;
            }
            return n;
        }

        private void updateSelectAll(int n) {
            if (n == this.elements.size() && n > 0) {
                QuickAVDataPanel.this.checkBoxHeader.setSelected(true);
            } else if (n < this.elements.size()) {
                QuickAVDataPanel.this.checkBoxHeader.setSelected(false);
            } else if (n == 0) {
                QuickAVDataPanel.this.checkBoxHeader.setSelected(false);
            }
            QuickAVDataPanel.this.dataSummaryTable.getTableHeader().repaint();
        }
    }
}

