/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax;

import java.util.HashMap;
import java.util.Map;
import oracle.hcs.syntax.SQLDataType;
import oracle.hcs.syntax.SyntaxException;

public final class DataType {
    private static final Map DATATYPE_MAP = new HashMap();
    public static final int TEXT_LITERAL_CATEGORY = 1;
    public static final int NUMBER_CATEGORY = 2;
    public static final int INTERVAL_CATEGORY = 4;
    public static final int TIMESTAMP_CATEGORY = 8;
    public static final int DATE_CATEGORY = 16;
    public static final int OBJECT_CATEGORY = 32;
    public static final int CLOB_CATEGORY = 64;
    public static final int LOB_CATEGORY = 128;
    public static final int RAW_CATEGORY = 256;
    public static final int LONG_CATEGORY = 512;
    public static final int ROWID_CATEGORY = 1024;
    public static final int XML_FORMAT_CATEGORY = 2048;
    public static final int XML_TYPE_CATEGORY = 4096;
    private static final int MAX_CATEGORY = 4096;
    public static final int ANY_CATEGORY = 8191;
    public static final int CASTABLE_TO_NUMBER_CATEGORY = 3;
    public static final int DATETIME_CATEGORY = 24;
    public static final int DATETIME_OR_INTERVAL_CATEGORY = 28;
    public static final int TEXT_CATEGORY = 65;
    public static final int LITERAL_CATEGORY = 31;
    public static final int TEXT_OR_NUMBER_CATEGORY = 3;
    public static final DataType NULL_TYPE = new DataType("NULL", 8191, 0);
    public static final DataType NUMBER = new DataType("NUMBER", 2, 0);
    public static final DataType BINARY_FLOAT = new DataType("BINARY_FLOAT", 2, 1);
    public static final DataType BINARY_DOUBLE = new DataType("BINARY_DOUBLE", 2, 2);
    public static final DataType FLOAT = new DataType("FLOAT", 2, 3);
    public static final DataType INTEGER = new DataType("INTEGER", 2, 4);
    public static final DataType DECIMAL = new DataType("DECIMAL", 2, 5);
    public static final DataType CHAR = new DataType("CHAR", 1, 0);
    public static final DataType NCHAR = new DataType("NCHAR", 1, 1);
    public static final DataType VARCHAR2 = new DataType("VARCHAR2", 1, 2);
    public static final DataType NVARCHAR2 = new DataType("NVARCHAR2", 1, 3);
    public static final DataType CLOB = new DataType("CLOB", 64, 4);
    public static final DataType NCLOB = new DataType("NCLOB", 64, 5);
    public static final DataType DATE = new DataType("DATE", 16, 0);
    public static final DataType TIMESTAMP = new DataType("TIMESTAMP", 8, 1);
    public static final DataType TIMESTAMP_WITH_LOCAL_TIME_ZONE = new DataType("TIMESTAMP WITH LOCAL TIME ZONE", 8, 2);
    public static final DataType TIMESTAMP_WITH_TIME_ZONE = new DataType("TIMESTAMP WITH TIME ZONE", 8, 3);
    public static final DataType YM_INTERVAL = new DataType("INTERVAL YEAR TO MONTH", 4, 0);
    public static final DataType DS_INTERVAL = new DataType("INTERVAL DAY TO SECOND", 4, 0);
    public static final DataType MLSLABEL = new DataType("MLSLABEL", 0, 0);
    public static final DataType RAW = new DataType("RAW", 256, 0);
    public static final DataType LONG_RAW = new DataType("LONG RAW", 256, 0);
    public static final DataType LONG = new DataType("LONG", 512, 0);
    public static final DataType ROWID = new DataType("ROWID", 1024, 0);
    public static final DataType LOB = new DataType("LOB", 128, 0);
    public static final DataType BLOB = new DataType("BLOB", 128, 0);
    private static final int[] IS_CASTABLE = new int[]{26, 1, 0, 0, 9, 0, 0, 0, 1, 0, 1, 0, 0};
    public static final DataType XMLTYPE = new DataType("XMLType", 4096, 0);
    public static final DataType XMLFORMAT = new DataType("XMLFormat", 2048, 0);
    public static final DataType[] LITERAL_DATA_TYPES = new DataType[]{NUMBER, FLOAT, INTEGER, DECIMAL, VARCHAR2, NVARCHAR2, CHAR, NCHAR, DATE, TIMESTAMP, TIMESTAMP_WITH_LOCAL_TIME_ZONE, TIMESTAMP_WITH_TIME_ZONE, YM_INTERVAL, DS_INTERVAL};
    private String m_Name = null;
    private int m_Mask = 0;
    private int m_Precedence = 0;
    private SQLDataType m_SQLDataType = null;

    private DataType(String string, int n, int n2) {
        this.m_Name = string;
        this.m_Mask = n;
        this.m_Precedence = n2;
        if (n != 32) {
            DATATYPE_MAP.put(string, this);
        }
        this.m_SQLDataType = new SQLDataType(this);
    }

    private int getMask() {
        return this.m_Mask;
    }

    private int getPrecedence() {
        return this.m_Precedence;
    }

    void validateType(int n) {
        if (this.matchesCategory(n)) {
            return;
        }
        String string = null;
        switch (n) {
            case 31: {
                string = "LITERAL";
                break;
            }
            case 2: {
                string = "NUMBER";
                break;
            }
            case 3: {
                string = "NUMBER";
                break;
            }
            case 65: {
                string = "CHAR";
                break;
            }
            case 24: {
                string = "DATETIME";
                break;
            }
            case 32: {
                string = "OBJECT";
            }
        }
        throw new SyntaxException("DatatypeMismatch", string, this.getName());
    }

    void validateType(DataType dataType) {
        if (this == dataType) {
            return;
        }
        throw new SyntaxException("DatatypeMismatch", dataType.getName(), this.getName());
    }

    DataType getLosslessType(DataType dataType) {
        if (this.getPrecedence() >= dataType.getPrecedence()) {
            return this;
        }
        return dataType;
    }

    int getCategory(int[] nArray, int n) {
        if (this == NULL_TYPE) {
            return n;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (!this.matchesCategory(nArray[i])) continue;
            return nArray[i];
        }
        return n;
    }

    public final String getName() {
        return this.m_Name;
    }

    public boolean matchesCategory(int n) {
        return this.matchesCategory(n, false);
    }

    public boolean matchesCategory(int n, boolean bl) {
        if ((n & this.getMask()) > 0) {
            return true;
        }
        if (!bl) {
            return false;
        }
        int n2 = 1;
        for (int n3 = 1; n3 <= 4096; n3 = 2 * n3) {
            int n4;
            if ((n & n3) != 0 && ((n4 = IS_CASTABLE[n2 - 1]) & this.getMask()) > 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static final DataType getDataType(String string) {
        return (DataType)DATATYPE_MAP.get(string);
    }

    public final SQLDataType toSQLDataType() {
        return this.m_SQLDataType;
    }
}

