/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax;

import oracle.hcs.syntax.Condition;
import oracle.hcs.syntax.DataObject;
import oracle.hcs.syntax.SyntaxObject;
import oracle.hcs.syntax.SyntaxObjectVisitor;
import oracle.hcs.syntax.SyntaxPrintingContext;
import oracle.hcs.syntax.TypedExpression;
import oracle.hcs.syntax.ValidationContext;

public final class SearchedCase
extends DataObject {
    private Condition m_WhenCondition = null;
    private TypedExpression m_ThenExpression = null;

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.append("WHEN ");
        syntaxPrintingContext.print(this.getWhenCondition());
        syntaxPrintingContext.append(" THEN ");
        syntaxPrintingContext.print(this.getThenExpression());
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        this.m_WhenCondition = validationContext.validateCond(this.m_WhenCondition);
        this.m_ThenExpression = validationContext.validateExp(this.m_ThenExpression);
        validationContext.pop();
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        return this.getWhenCondition().isDefinitionComplete() && this.getThenExpression().isDefinitionComplete();
    }

    public SearchedCase(Condition condition, TypedExpression typedExpression) {
        SearchedCase.validateValue(condition);
        SearchedCase.validateValue(typedExpression);
        this.m_WhenCondition = condition;
        this.m_ThenExpression = typedExpression;
        this.initialize();
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitSearchedCase(this, object);
    }

    public Condition getWhenCondition() {
        return this.m_WhenCondition;
    }

    public TypedExpression getThenExpression() {
        return this.m_ThenExpression;
    }

    @Override
    public boolean isCompositeObject() {
        return true;
    }
}

