/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntaxbuilder;

import java.sql.Connection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import oracle.hcs.metadata.HCSSchema;

public class HCSSpecTimeoutConnectionCache {
    private static HCSSpecTimeoutConnectionCache instance;
    private Map<String, Connection> connectionMap = new HashMap<String, Connection>();
    private Map<String, HCSSchema> schemaMap = new HashMap<String, HCSSchema>();
    private Timer timer;
    private boolean initialized = false;
    private Date lastTimeInitialized;
    private Logger LOG = Logger.getLogger(HCSSpecTimeoutConnectionCache.class.getName());
    public static final String START_INITIALIZATION = "Start_Initialization";
    public static final String GET_INSTANCE = "Get_Instance";
    private final int CACHE_EXPIRE_TIMEOUT = 45000;

    private HCSSpecTimeoutConnectionCache() {
    }

    private void initializeStartup() {
        this.initialized = true;
        this.lastTimeInitialized = new Date(System.currentTimeMillis());
        this.timer = new Timer();
        ClearTask clearTask = new ClearTask();
        clearTask.setStartTime(this.lastTimeInitialized);
        this.timer.schedule((TimerTask)clearTask, 45000L);
    }

    public static synchronized HCSSpecTimeoutConnectionCache getInstance(String string) {
        if (instance == null) {
            instance = new HCSSpecTimeoutConnectionCache();
        }
        if (string.equalsIgnoreCase(START_INITIALIZATION)) {
            instance.initializeStartup();
        }
        return instance;
    }

    public synchronized void setConnection(Connection connection, String string) {
        if (this.initialized) {
            this.connectionMap.put(string, connection);
        }
    }

    public synchronized Connection getConnection(String string) {
        Connection connection = null;
        if (this.initialized && this.connectionMap.containsKey(string)) {
            connection = this.connectionMap.get(string);
        }
        return connection;
    }

    public synchronized void setSchemaWithTimestamp(HCSSchema hCSSchema, String string) {
        if (this.initialized) {
            this.schemaMap.put(string, hCSSchema);
        }
    }

    public synchronized HCSSchema getSchemaWithTimestamp(String string) {
        HCSSchema hCSSchema = null;
        if (this.initialized && this.schemaMap.containsKey(string)) {
            hCSSchema = this.schemaMap.get(string);
        }
        return hCSSchema;
    }

    public synchronized boolean isActive() {
        return this.initialized;
    }

    public synchronized void shutdown() {
        if (this.initialized) {
            this.initialized = false;
            this.connectionMap.clear();
            this.schemaMap.clear();
            this.LOG.finest("Reset the HCSSpec startup connection cache under normal processing.");
        }
    }

    protected synchronized void resetCacheFromTimeout(Date date) {
        if (this.initialized && date.equals(this.lastTimeInitialized)) {
            this.initialized = false;
            this.connectionMap.clear();
            this.schemaMap.clear();
            this.LOG.warning("Reset the HCSSpec startup connection cache as it has expired.");
        }
    }

    class ClearTask
    extends TimerTask {
        private Date startTime;

        ClearTask() {
        }

        @Override
        public void run() {
            HCSSpecTimeoutConnectionCache hCSSpecTimeoutConnectionCache = HCSSpecTimeoutConnectionCache.getInstance(HCSSpecTimeoutConnectionCache.GET_INSTANCE);
            hCSSpecTimeoutConnectionCache.resetCacheFromTimeout(this.startTime);
        }

        public void setStartTime(Date date) {
            this.startTime = date;
        }
    }
}

