/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntaxbuilder.editor;

import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.hcs.av.calcs.CalculatedMeasurePinningTracker;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.model.Node;
import oracle.ide.view.View;
import oracle.javatools.icons.OracleIcons;

public class SyntaxEditorPinActionController
implements Controller {
    public static final int PIN_EDITOR_CMD_ID = Ide.findOrCreateCmdID((String)"VE_Pin_Editor");
    private ToggleToolButton pinToggle;
    private Toolbar toolbar;

    public SyntaxEditorPinActionController(ToggleToolButton toggleToolButton, Toolbar toolbar) {
        this.pinToggle = toggleToolButton;
        this.toolbar = toolbar;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == PIN_EDITOR_CMD_ID) {
            Node node = context.getNode();
            boolean bl = CalculatedMeasurePinningTracker.isPinned(node);
            if (!bl) {
                this.pinToggle.setIcon(RaptorImagesArb.getIcon((String)"PINNED"));
                CalculatedMeasurePinningTracker.pinNode(node);
            } else {
                this.pinToggle.setIcon(OracleIcons.getIcon((String)"pin.png"));
                CalculatedMeasurePinningTracker.unpinNode(node);
            }
            View.updateToolbarActions((Toolbar)this.toolbar);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return true;
    }
}

