/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntaxbuilder.specification;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.hcs.syntaxbuilder.specification.LazyLoader;
import oracle.hcs.templates.syntaxparser.ParseNode;
import oracle.hcs.templates.templatedialog.TemplateHelper;
import oracle.hcs.templates.templateview.BaseTemplateHyperView;
import oracle.hcs.templates.templateview.TemplateNode;

public class SpecTreeNode
extends DefaultMutableTreeNode
implements TemplateNode {
    private static final Logger LOG = Logger.getLogger(SpecTreeNode.class.getName());
    private final String type;
    private final String template;
    private final String doc;
    private final boolean insertable;
    private BaseTemplateHyperView baseTemplateHyperView;
    private transient TemplateHelper templateHelper;
    private transient Icon icon;
    private transient LazyLoader loader;
    private boolean lazy;

    public SpecTreeNode() {
        this(null, null);
    }

    public SpecTreeNode(String string, String string2, String string3, boolean bl, String string4, Icon icon) {
        super(string);
        this.template = string2 == null ? string : string2;
        this.type = string3 == null ? string : string3;
        this.icon = icon;
        this.insertable = bl;
        this.doc = string4;
    }

    public SpecTreeNode(String string, String string2) {
        this(string, string2, null);
    }

    public SpecTreeNode(String string, String string2, Icon icon) {
        this(string, string2, null, true, string, icon);
    }

    public SpecTreeNode(BaseTemplateHyperView baseTemplateHyperView) {
        this.baseTemplateHyperView = baseTemplateHyperView;
        this.type = "undefined";
        this.template = null;
        this.doc = null;
        this.insertable = false;
    }

    public BaseTemplateHyperView getBaseTemplateHyperView() {
        return this.baseTemplateHyperView;
    }

    @Override
    public boolean isEditable() {
        return this.isLeaf() && this.getTemplateHelper() != null;
    }

    @Override
    public Component getComponent() {
        JPanel jPanel = null;
        try {
            if (this.isLeaf()) {
                if (this.getBaseTemplateHyperView() != null) {
                    jPanel = this.getBaseTemplateHyperView().getPanel(0);
                } else if (this.getTemplateHelper() != null) {
                    jPanel = this.getTemplateHelper().getGUI(true).getTemplateViewPanel();
                }
            }
        }
        catch (IOException | SQLException exception) {
            LOG.log(Level.SEVERE, "geComponent()", exception);
        }
        return jPanel;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        TemplateHelper templateHelper;
        if (this.getBaseTemplateHyperView() != null) {
            this.getBaseTemplateHyperView().addPropertyChangeListener(propertyChangeListener);
        } else if (this.getTemplateHelper() != null && (templateHelper = this.getTemplateHelper()).getBaseTemplateHyperView() != null) {
            templateHelper.getBaseTemplateHyperView().addPropertyChangeListener(propertyChangeListener);
        }
    }

    public List<SpecTreeNode> getInsertables() {
        this.loadChildren();
        ArrayList<SpecTreeNode> arrayList = new ArrayList<SpecTreeNode>();
        if (this.isInsertable()) {
            arrayList.add(this);
        }
        if (!super.isLeaf()) {
            for (SpecTreeNode specTreeNode = (SpecTreeNode)this.getFirstChild(); specTreeNode != null; specTreeNode = (SpecTreeNode)specTreeNode.getNextSibling()) {
                if (!specTreeNode.isInsertable()) continue;
                arrayList.add(specTreeNode);
            }
        }
        return arrayList;
    }

    public void setTemplateHelper(TemplateHelper templateHelper) {
        this.templateHelper = templateHelper;
    }

    public TemplateHelper getTemplateHelper() {
        return this.templateHelper;
    }

    @Override
    public boolean isLeaf() {
        if (this.lazy) {
            return false;
        }
        return super.isLeaf();
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean bl, LazyLoader lazyLoader) {
        this.lazy = bl;
        this.loader = lazyLoader;
    }

    public boolean isInsertable() {
        return this.insertable;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public int matchesPattern(ParseNode parseNode) {
        if (this.templateHelper != null) {
            return this.templateHelper.matchesPattern(parseNode);
        }
        return 0;
    }

    public String getDoc() {
        return this.doc;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getType() {
        return this.type;
    }

    private void loadChildren() {
        if (this.isLazy() && this.loader != null) {
            this.lazy = false;
            this.loader.doLazyLoad(this);
            this.loader = null;
        }
    }

    public Enumeration children() {
        this.loadChildren();
        return super.children();
    }

    @Override
    public TreeNode getChildAfter(TreeNode treeNode) {
        this.loadChildren();
        return super.getChildAfter(treeNode);
    }

    @Override
    public TreeNode getChildAt(int n) {
        this.loadChildren();
        return super.getChildAt(n);
    }

    @Override
    public TreeNode getChildBefore(TreeNode treeNode) {
        this.loadChildren();
        return super.getChildBefore(treeNode);
    }

    @Override
    public int getChildCount() {
        this.loadChildren();
        return super.getChildCount();
    }

    @Override
    public TreeNode getFirstChild() {
        this.loadChildren();
        return super.getFirstChild();
    }

    @Override
    public TreeNode getLastChild() {
        this.loadChildren();
        return super.getLastChild();
    }

    @Override
    public boolean isNodeChild(TreeNode treeNode) {
        this.loadChildren();
        return super.isNodeChild(treeNode);
    }
}

