/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.templates.stringexpr;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.templates.stringexpr.ASTExpression;
import oracle.hcs.templates.stringexpr.ParamProperty;
import oracle.hcs.templates.stringexpr.ParamValue;
import oracle.hcs.templates.stringexpr.ParseException;
import oracle.hcs.templates.stringexpr.StringExprParser;
import oracle.hcs.templates.templateview.ItemElement;
import oracle.hcs.templates.templateview.TemplateHyperParamFactory;

public class ParamStringExpr {
    private static final Logger LOG = Logger.getLogger(ParamStringExpr.class.getName());
    private static final int EXPR_MARK_LENGTH = "$sexpr".length();
    private static ParamStringExpr INSTANCE;

    private ParamStringExpr() {
    }

    public static ParamStringExpr getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ParamStringExpr();
        }
        return INSTANCE;
    }

    public String getExpression(String object, ParamValue paramValue, ParamProperty paramProperty, AVBaseMeasure aVBaseMeasure, ItemElement itemElement, HashMap<String, String> hashMap) throws SQLException, IOException {
        if (object == null) {
            return null;
        }
        object = this.evaluateStringExprs((String)object, paramValue, hashMap);
        String string = null;
        while (object != null && ((String)object).indexOf("{") >= 0) {
            string = object;
            int n = ((String)object).indexOf("{");
            int n2 = ((String)object).indexOf("}");
            if (n2 < 0) continue;
            String string2 = ((String)object).substring(n + 1, n2);
            String[] stringArray = TemplateHyperParamFactory.splitDefinition(string2);
            String string3 = stringArray[3];
            String string4 = stringArray[2];
            String string5 = paramProperty.getParamPropertyValue(string3, string4, aVBaseMeasure, itemElement, hashMap);
            String string6 = object;
            String string7 = string6.substring(0, n);
            if (string5 != null) {
                object = string7;
                object = (String)object + string5;
            }
            String string8 = string6.substring(n2 + 1, string6.length());
            if (string5 != null) {
                object = (String)object + string8;
            }
            if (n == 0 && n2 == ((String)object).length() - 1 && string5 == null) {
                object = null;
            }
            if (!string.equals(object)) continue;
            break;
        }
        return object;
    }

    public String evaluateStringExprs(String object, ParamValue paramValue, HashMap<String, String> hashMap) throws SQLException, IOException {
        int n;
        if (object == null) {
            return null;
        }
        int n2 = -1;
        while ((n2 = ((String)object).indexOf("$sexpr")) != -1 && (n = ((String)object).indexOf("]$")) >= 0) {
            String string = ((String)object).substring(n2, n + 2);
            String string2 = "";
            string2 = this.evaluateStringExpr(string, paramValue, hashMap);
            String string3 = object;
            object = string3.substring(0, n2);
            if (string2 == null) {
                if (((String)object).isEmpty()) {
                    return null;
                }
                string2 = "";
            }
            object = (String)object + string2;
            object = (String)object + string3.substring(n + 2, string3.length());
        }
        return object;
    }

    private String evaluateStringExpr(String string, ParamValue paramValue, HashMap<String, String> hashMap) throws SQLException, IOException {
        String string2 = null;
        int n = EXPR_MARK_LENGTH;
        if (string.charAt(n) == ':') {
            n = string.indexOf(91, n);
            string2 = string.substring(EXPR_MARK_LENGTH + 1, n);
        }
        String string3 = string = string.substring(n + 1, string.length() - 2);
        try {
            ParamValue paramValue2 = StringExprParser.getParamValue();
            string3 = StringExprParser.getParseTree(string, paramValue);
            StringExprParser.setParamValue(paramValue2);
            if (string2 != null && hashMap != null) {
                hashMap.put(string2, string3);
            }
        }
        catch (ParseException parseException) {
            LOG.log(Level.SEVERE, String.format("Expression %s failed with %s", string, parseException.getMessage()), parseException);
            string3 = String.format(" \"%s\"->%s\n", string, parseException.getMessage());
        }
        return string3;
    }

    public Object evaluateObjectExprs(String string, ParamValue paramValue) throws SQLException, IOException {
        int n;
        Object object = null;
        if (string == null) {
            return object;
        }
        int n2 = -1;
        n2 = string.indexOf("$oexpr");
        if (n2 != -1 && (n = string.indexOf("]$")) >= 0) {
            String string2 = string.substring(n2, n + 2);
            object = this.evaluateObjectExpr(string2, paramValue);
            String string3 = string;
            string = string3.substring(0, n2);
            if (object == null && string.isEmpty()) {
                return null;
            }
        }
        return object;
    }

    private Object evaluateObjectExpr(String string, ParamValue paramValue) throws SQLException, IOException {
        String string2 = null;
        Object object = null;
        int n = EXPR_MARK_LENGTH;
        if (string.charAt(n) == ':') {
            n = string.indexOf(91, n);
            string2 = string.substring(EXPR_MARK_LENGTH + 1, n);
        }
        string = string.substring(n + 1, string.length() - 2);
        ASTExpression aSTExpression = null;
        try {
            ParamValue paramValue2 = StringExprParser.getParamValue();
            aSTExpression = StringExprParser.getParseTreeObj(string, paramValue);
            if (aSTExpression != null) {
                object = aSTExpression.getValue();
            }
            StringExprParser.setParamValue(paramValue2);
        }
        catch (ParseException parseException) {
            LOG.log(Level.SEVERE, String.format("Expression %s failed with %s", string, parseException.getMessage()), parseException);
        }
        return object;
    }
}

